/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.drools.WorkingMemory;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.protempa.AbstractParameterFactory;
import org.protempa.DerivationsBuilder;
import org.protempa.JBossRulesDerivedLocalUniqueIdValuesProvider;
import org.protempa.PropositionCopier;
import org.protempa.ProtempaUtil;
import org.protempa.SliceDefinition;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.ProviderBasedUniqueIdFactory;
import org.protempa.proposition.Segment;
import org.protempa.proposition.Sequence;
import org.protempa.proposition.TemporalProposition;

final class SliceConsequence
implements Consequence {
    private static final long serialVersionUID = -7485083104777547624L;
    private final SliceDefinition def;
    private final PropositionCopier copier;
    private final DerivationsBuilder derivationsBuilder;
    private final int minIndex;
    private final int maxIndex;
    private final boolean reverse;
    private final boolean merged;

    SliceConsequence(SliceDefinition def, DerivationsBuilder listener) {
        assert (def != null) : "def cannot be null";
        assert (listener != null) : "listener cannot be null";
        this.def = def;
        this.derivationsBuilder = listener;
        int minInd = def.getMinIndex();
        int maxInd = def.getMaxIndex();
        if (minInd < 0) {
            this.minIndex = -maxInd;
            this.maxIndex = -minInd;
            this.reverse = true;
        } else {
            this.minIndex = minInd;
            this.maxIndex = maxInd;
            this.reverse = false;
        }
        this.merged = def.isMergedInterval();
        this.copier = new PropositionCopier(def.getPropositionId(), listener);
    }

    public void evaluate(KnowledgeHelper arg0, WorkingMemory arg1) {
        List pl = (List)arg0.get(arg0.getDeclaration("result"));
        Comparator<TemporalProposition> comp = this.reverse ? ProtempaUtil.REVERSE_TEMP_PROP_COMP : ProtempaUtil.TEMP_PROP_COMP;
        Collections.sort(pl, comp);
        this.copier.grab(arg1);
        if (this.merged) {
            this.mergedInterval(arg0, pl);
        } else {
            ListIterator itr = pl.listIterator(this.minIndex);
            while (itr.hasNext() && itr.nextIndex() < this.maxIndex) {
                TemporalProposition o = (TemporalProposition)itr.next();
                o.accept(this.copier);
            }
        }
        this.copier.release();
    }

    private void mergedInterval(KnowledgeHelper kh, List<TemporalProposition> pl) {
        JBossRulesDerivedLocalUniqueIdValuesProvider provider = new JBossRulesDerivedLocalUniqueIdValuesProvider(kh.getWorkingMemory(), this.def.getPropositionId());
        ProviderBasedUniqueIdFactory factory = new ProviderBasedUniqueIdFactory(provider);
        ArrayList<TemporalProposition> slice = new ArrayList<TemporalProposition>();
        ListIterator<TemporalProposition> itr = pl.listIterator();
        while (itr.hasNext() && itr.nextIndex() < this.maxIndex) {
            slice.add(itr.next());
        }
        Segment segment = new Segment(new Sequence(this.def.getPropositionId(), slice));
        AbstractParameter result = AbstractParameterFactory.getFromAbstraction(this.def.getPropositionId(), factory.getInstance(), segment, slice, null, null, null, null);
        kh.getWorkingMemory().insert((Object)result);
        for (Proposition p : segment) {
            this.derivationsBuilder.propositionAsserted(p, result);
        }
    }
}

