/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.protempa.proposition.CompoundInterval;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.Granularity;

public abstract class IntervalSectioner<E extends TemporalProposition, K extends CompoundInterval<E>> {
    private static final IntervalFactory intervalFactory = new IntervalFactory();

    IntervalSectioner() {
    }

    public List<K> buildIntervalList(List<E> propositions) {
        return this.orderIntervals(propositions);
    }

    private List<K> orderIntervals(List<E> propositions) {
        Granularity startGran = ((TemporalProposition)propositions.get(0)).getInterval().getStartGranularity();
        Granularity finishGran = ((TemporalProposition)propositions.get(0)).getInterval().getFinishGranularity();
        ArrayList<K> result = new ArrayList<K>();
        HashSet<Long> startBoundsSet = new HashSet<Long>();
        HashSet<Long> finishBoundsSet = new HashSet<Long>();
        TreeSet<Interval> intervalSet = new TreeSet<Interval>();
        for (TemporalProposition p : propositions) {
            assert ((p.getInterval().getStartGranularity() != null ? p.getInterval().getStartGranularity().equals(startGran) : startGran == null) && (p.getInterval().getFinishGranularity() == null ? finishGran == null : p.getInterval().getFinishGranularity().equals(finishGran))) : "all intervals must have the same start and finish granularities to be combined";
            startBoundsSet.add(p.getInterval().getMinStart());
            finishBoundsSet.add(p.getInterval().getMaxFinish());
            if (startBoundsSet.contains(p.getInterval().getMaxFinish())) {
                intervalSet.add(intervalFactory.getInstance(p.getInterval().getMaxFinish(), p.getInterval().getFinishGranularity()));
            }
            if (!finishBoundsSet.contains(p.getInterval().getMinStart())) continue;
            intervalSet.add(intervalFactory.getInstance(p.getInterval().getMinStart(), p.getInterval().getStartGranularity()));
        }
        ArrayList intervalBounds = new ArrayList(startBoundsSet);
        Collections.sort(intervalBounds);
        for (int i = 0; i < intervalBounds.size() - 1; ++i) {
            intervalSet.add(intervalFactory.getInstance((Long)intervalBounds.get(i), startGran, (Long)intervalBounds.get(i + 1), finishGran));
        }
        TreeMap fakeIntervals = new TreeMap();
        block2: for (TemporalProposition temporalProposition : propositions) {
            Long ivalStart = temporalProposition.getInterval().getMinStart();
            Long ivalFinish = temporalProposition.getInterval().getMaximumFinish();
            for (Interval interval : intervalSet) {
                if ((ivalStart == null || interval.getMinStart() != null && ivalStart <= interval.getMinStart()) && (ivalFinish == null || interval.getMinStart() == null || ivalFinish > interval.getMinStart())) {
                    Long minMaxFinish = temporalProposition.getInterval().getMaxFinish() == null ? interval.getMaxFinish() : (interval.getMaxFinish() == null ? temporalProposition.getInterval().getMaxFinish() : Long.valueOf(Math.min(temporalProposition.getInterval().getMaxFinish(), interval.getMaxFinish())));
                    Interval ival = intervalFactory.getInstance(interval.getMinStart(), startGran, minMaxFinish, finishGran);
                    if (!fakeIntervals.containsKey(ival)) {
                        fakeIntervals.put(ival, new HashSet());
                    }
                    ((Set)fakeIntervals.get(ival)).add(temporalProposition);
                }
                if ((ivalFinish != null || interval.getMinStart() != null) && (ivalFinish == null || interval.getMinStart() == null || ivalFinish > interval.getMinStart())) continue;
                continue block2;
            }
        }
        for (Map.Entry entry : fakeIntervals.entrySet()) {
            HashSet<TemporalProposition> props = new HashSet<TemporalProposition>();
            for (TemporalProposition p : (Set)entry.getValue()) {
                props.add(p);
            }
            result.add(this.newCompoundInterval((Interval)entry.getKey(), props));
        }
        return result;
    }

    protected abstract K newCompoundInterval(Interval var1, Set<E> var2);
}

