/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.interval;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.protempa.proposition.interval.DefaultInterval;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.SimpleInterval;
import org.protempa.proposition.value.Granularity;

public final class IntervalFactory {
    private static final Map<List<Object>, Interval> cache = new ReferenceMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interval getInstance(Long minStart, Long maxStart, Granularity startGran, Long minFinish, Long maxFinish, Granularity finishGran) {
        Interval result;
        List<Object> key = Arrays.asList(minStart, maxStart, startGran, minFinish, maxFinish, finishGran);
        Map<List<Object>, Interval> map = cache;
        synchronized (map) {
            result = cache.get(key);
            if (result == null) {
                result = minStart == null || maxStart == null || minFinish == null || maxFinish == null ? new DefaultInterval(minStart, maxStart, startGran, minFinish, maxFinish, finishGran, null, null, null) : new SimpleInterval(minStart, maxStart, startGran, minFinish, maxFinish, finishGran);
                cache.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interval getInstance(Long start, Granularity startGran, Long finish, Granularity finishGran) {
        Interval result;
        List<Object> key = Arrays.asList(start, startGran, finish, finishGran);
        Map<List<Object>, Interval> map = cache;
        synchronized (map) {
            result = cache.get(key);
            if (result == null) {
                result = start == null || finish == null ? new DefaultInterval(start, startGran, finish, finishGran) : new SimpleInterval(start, startGran, finish, finishGran);
                cache.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interval getInstance(Long position, Granularity gran) {
        Interval result;
        List<Object> key = Arrays.asList(position, gran);
        Map<List<Object>, Interval> map = cache;
        synchronized (map) {
            result = cache.get(key);
            if (result == null) {
                result = position == null ? new DefaultInterval(position, gran, position, gran) : new SimpleInterval(position, gran);
                cache.put(key, result);
            }
        }
        return result;
    }

    public Interval getInstance() {
        return DefaultIntervalContainer.defaultInterval;
    }

    private static class DefaultIntervalContainer {
        private static Interval defaultInterval = new DefaultInterval();

        private DefaultIntervalContainer() {
        }
    }
}

