/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import java.util.HashMap;
import java.util.Map;

public enum VitalStatusCode {
    LIVING("N"),
    DECEASED_ACCURATE_TO_DAY("Y"),
    DECEASED_ACCURATE_TO_MONTH("M"),
    DECEASED_ACCURATE_TO_YEAR("X");

    private static final Map<String, VitalStatusCode> fromCodeMap;
    private final String code;

    public static VitalStatusCode getInstance(Boolean knownDeceased) {
        if (knownDeceased != null && knownDeceased.booleanValue()) {
            return DECEASED_ACCURATE_TO_DAY;
        }
        return LIVING;
    }

    public static VitalStatusCode fromCode(String code) {
        return fromCodeMap.get(code);
    }

    private VitalStatusCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    static {
        fromCodeMap = new HashMap<String, VitalStatusCode>();
        fromCodeMap.put("N", LIVING);
        fromCodeMap.put("Y", DECEASED_ACCURATE_TO_DAY);
        fromCodeMap.put("M", DECEASED_ACCURATE_TO_MONTH);
        fromCodeMap.put("X", DECEASED_ACCURATE_TO_YEAR);
    }
}

