/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.config.Settings;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.DataType;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.MetadataUtil;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.SimpleConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimensionHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;

public class ProviderDimensionFactory {
    private static final String PROVIDER_ID_PREFIX = "AIW|Provider:";
    private static final String NOT_RECORDED_PROVIDER_ID = "AIW|Provider:NotRecorded";
    private final Metadata metadata;
    private final ProviderDimension providerDimension;
    private final ProviderDimensionHandler providerDimensionHandler;

    public ProviderDimensionFactory(Metadata metadata, Settings settings, ConnectionSpec dataConnectionSpec) throws SQLException {
        this.metadata = metadata;
        this.providerDimension = new ProviderDimension();
        this.providerDimensionHandler = new ProviderDimensionHandler(dataConnectionSpec);
    }

    public ProviderDimension getInstance(Proposition encounterProp, String fullNameReference, String fullNameProperty, String firstNameReference, String firstNameProperty, String middleNameReference, String middleNameProperty, String lastNameReference, String lastNameProperty, Map<UniqueId, Proposition> references) throws InvalidConceptCodeException, SQLException {
        boolean found;
        String source;
        String id;
        HashSet<String> sources = new HashSet<String>(4);
        String firstName = this.extractNamePart(firstNameReference, firstNameProperty, encounterProp, references, sources);
        String middleName = this.extractNamePart(middleNameReference, middleNameProperty, encounterProp, references, sources);
        String lastName = this.extractNamePart(lastNameReference, lastNameProperty, encounterProp, references, sources);
        String fullName = this.extractNamePart(fullNameReference, fullNameProperty, encounterProp, references, sources);
        if (fullName == null) {
            fullName = this.constructFullName(firstName, middleName, lastName);
        }
        if (!sources.isEmpty()) {
            id = PROVIDER_ID_PREFIX + fullName;
            source = MetadataUtil.toSourceSystemCode(StringUtils.join(sources, (String)" & "));
        } else {
            id = NOT_RECORDED_PROVIDER_ID;
            source = this.metadata.getSourceSystemCode();
            fullName = "Not Recorded";
        }
        ConceptId cid = SimpleConceptId.getInstance(id, this.metadata);
        Concept concept = this.metadata.getFromIdCache(cid);
        boolean bl = found = concept != null;
        if (!found) {
            concept = new Concept(cid, null, this.metadata);
            concept.setSourceSystemCode(source);
            concept.setDisplayName(fullName);
            concept.setDataType(DataType.TEXT);
            concept.setInUse(true);
            concept.setFactTableColumn("provider_id");
            concept.setTableName("provider_dimension");
            concept.setColumnName("provider_path");
            this.metadata.addToIdCache(concept);
        }
        this.providerDimension.setConcept(concept);
        this.providerDimension.setSourceSystem(source);
        if (!found) {
            this.metadata.addProvider(this.providerDimension);
            this.providerDimensionHandler.insert(this.providerDimension);
        }
        return this.providerDimension;
    }

    public void close() throws SQLException {
        this.providerDimensionHandler.close();
    }

    private String extractNamePart(String namePartReference, String namePartProperty, Proposition encounterProp, Map<UniqueId, Proposition> references, Set<String> sources) {
        if (namePartReference != null && namePartProperty != null) {
            Proposition provider = this.resolveReference(encounterProp, namePartReference, references);
            this.extractSource(sources, provider);
            return this.getNamePart(provider, namePartProperty);
        }
        return null;
    }

    private void extractSource(Set<String> sources, Proposition provider) {
        if (provider != null) {
            sources.add(provider.getSourceSystem().getStringRepresentation());
        }
    }

    private Proposition resolveReference(Proposition encounterProp, String namePartReference, Map<UniqueId, Proposition> references) {
        Proposition provider;
        List providerUIDs = encounterProp.getReferences(namePartReference);
        int size = providerUIDs.size();
        if (size > 0) {
            if (size > 1) {
                Logger logger = TableUtil.logger();
                logger.log(Level.WARNING, "Multiple providers found for {0}, using only the first one", encounterProp);
            }
            provider = references.get(providerUIDs.get(0));
        } else {
            provider = null;
        }
        return provider;
    }

    private String getNamePart(Proposition provider, String namePartProperty) {
        String namePart = provider != null ? this.getProperty(namePartProperty, provider) : null;
        return namePart;
    }

    private String getProperty(String nameProperty, Proposition provider) {
        Value firstNameVal;
        String name = nameProperty != null ? ((firstNameVal = provider.getProperty(nameProperty)) != null ? firstNameVal.getFormatted() : null) : null;
        return name;
    }

    private String constructFullName(String firstName, String middleName, String lastName) {
        StringBuilder result = new StringBuilder();
        if (lastName != null) {
            result.append(lastName);
        }
        result.append(", ");
        if (firstName != null) {
            result.append(firstName);
        }
        if (middleName != null) {
            if (firstName != null) {
                result.append(' ');
            }
            result.append(middleName);
        }
        return result.toString();
    }
}

