/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.ConnectionSpecQueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.QuerySupport;
import edu.emory.cci.aiw.i2b2etl.ksb.ResultSetReader;
import edu.emory.cci.aiw.i2b2etl.ksb.UniqueIdTempTableHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.collections.Collections;
import org.arp.javautil.sql.InvalidConnectionSpecArguments;
import org.protempa.KnowledgeSourceReadException;

class LevelReader {
    private final QuerySupport querySupport;
    private final QueryConstructor READ_PARENTS_FROM_DB_QUERY_CONSTRUCTOR = new QueryConstructor(){

        @Override
        public void appendStatement(StringBuilder sql, String table) {
            sql.append("SELECT ").append(LevelReader.this.querySupport.getEurekaIdColumn()).append(" FROM ");
            sql.append(table);
            sql.append(" WHERE M_APPLIED_PATH='@' AND C_SYNONYM_CD='N' AND C_FULLNAME IN (SELECT C_PATH FROM ");
            sql.append(table);
            sql.append(" WHERE ").append(LevelReader.this.querySupport.getEurekaIdColumn()).append(" = ? AND M_APPLIED_PATH='@')");
        }
    };
    private static final ResultSetReader<Set<String>> RESULT_SET_READER = new ResultSetReader<Set<String>>(){

        @Override
        public Set<String> read(ResultSet rs) throws KnowledgeSourceReadException {
            try {
                HashSet<String> result = new HashSet<String>();
                if (rs != null) {
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                }
                return result;
            }
            catch (SQLException ex) {
                throw new KnowledgeSourceReadException((Throwable)ex);
            }
        }
    };
    private static final ResultSetReader<Map<String, Set<String>>> MULT_RESULT_SET_READER = new ResultSetReader<Map<String, Set<String>>>(){

        @Override
        public Map<String, Set<String>> read(ResultSet rs) throws KnowledgeSourceReadException {
            try {
                HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
                if (rs != null) {
                    while (rs.next()) {
                        Collections.putSet(result, (Object)rs.getString(1), (Object)rs.getString(2));
                    }
                }
                return result;
            }
            catch (SQLException ex) {
                throw new KnowledgeSourceReadException((Throwable)ex);
            }
        }
    };
    private final QueryConstructor READ_CHILDREN_FROM_DB_QUERY_CONSTRUCTOR = new QueryConstructor(){

        @Override
        public void appendStatement(StringBuilder sql, String table) {
            sql.append("SELECT ").append(LevelReader.this.querySupport.getEurekaIdColumn()).append(" FROM ");
            sql.append(table);
            sql.append(" WHERE M_APPLIED_PATH='@' AND C_PATH=?");
        }
    };

    LevelReader(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    Set<String> readChildrenFromDatabase(String fullName) throws KnowledgeSourceReadException {
        try (ConnectionSpecQueryExecutor queryExecutor = this.querySupport.getQueryExecutorInstance(this.READ_CHILDREN_FROM_DB_QUERY_CONSTRUCTOR);){
            Set<String> set = queryExecutor.execute(fullName, RESULT_SET_READER);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Set<String>> readChildrenFromDatabase(Collection<String> symbols) throws KnowledgeSourceReadException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        try (Connection connection = this.querySupport.getConnection();){
            try {
                try (UniqueIdTempTableHandler childTempTableHandler = new UniqueIdTempTableHandler(connection, false);){
                    for (String child : symbols) {
                        childTempTableHandler.insert(child);
                    }
                }
                var6_10 = null;
                try (QueryExecutor queryExecutor = this.querySupport.getQueryExecutorInstance(connection, new QueryConstructor(){

                    @Override
                    public void appendStatement(StringBuilder sql, String table) {
                        String ekIdCol = LevelReader.this.querySupport.getEurekaIdColumn();
                        sql.append("SELECT A2.").append(ekIdCol).append(", A1.").append(ekIdCol).append(" FROM ");
                        sql.append(table);
                        sql.append(" A1 JOIN ");
                        sql.append(table);
                        sql.append(" A2 ON (A1.C_PATH=A2.C_FULLNAME) JOIN EK_TEMP_UNIQUE_IDS A3 ON (A3.UNIQUE_ID=A2.").append(ekIdCol).append(") WHERE A2.M_APPLIED_PATH='@' and A1.C_SYNONYM_CD='N' and A2.C_SYNONYM_CD='N'");
                    }
                });){
                    Collections.putSetAll(result, queryExecutor.execute(MULT_RESULT_SET_READER));
                }
                catch (Throwable throwable) {
                    var6_10 = throwable;
                    throw throwable;
                }
                connection.commit();
            }
            catch (SQLException ex) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {}
                finally {
                    throw ex;
                }
            }
        }
        catch (SQLException | InvalidConnectionSpecArguments ex) {
            throw new KnowledgeSourceReadException(ex);
        }
        return result;
    }

    Set<String> readParentsFromDatabase(String propId) throws KnowledgeSourceReadException {
        try (ConnectionSpecQueryExecutor queryExecutor = this.querySupport.getQueryExecutorInstance(this.READ_PARENTS_FROM_DB_QUERY_CONSTRUCTOR);){
            Set<String> set = queryExecutor.execute(propId, RESULT_SET_READER);
            return set;
        }
    }
}

