/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.util;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class SqlRunner
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(SqlRunner.class.getName());
    private static final String SQL_RUNNER_BATCH_SIZE_PROPERTY = "aiw.i2b2Etl.sqlRunner.batchSize";
    private static final String SQL_RUNNER_COMMIT_SIZE_PROPERTY = "aiw.i2b2Etl.sqlRunner.commitSize";
    private final int batchSize = Integer.getInteger("aiw.i2b2Etl.sqlRunner.batchSize", 1000);
    private final int commitSize = Integer.getInteger("aiw.i2b2Etl.sqlRunner.commitSize", 10000);
    private boolean stop;
    private SQLException exception;
    private int commitCounter = 0;
    private PreparedStatement ps;
    private final boolean commit;

    SqlRunner(PreparedStatement preparedStatement, boolean commit) {
        assert (preparedStatement != null) : "preparedStatement cannot be null";
        this.ps = preparedStatement;
        this.commit = commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SqlRunner sqlRunner = this;
            synchronized (sqlRunner) {
                while (!this.isInterrupted() && !this.stop) {
                    this.wait();
                    if (this.stop) continue;
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Executing batch");
                    }
                    this.ps.executeBatch();
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Batch executed successfully");
                    }
                    this.ps.clearBatch();
                    if (this.commitCounter >= this.commitSize) {
                        if (this.commit) {
                            this.ps.getConnection().commit();
                        }
                        this.commitCounter = 0;
                    }
                    this.ps.clearParameters();
                }
            }
        }
        catch (SQLException ex) {
            this.rollback(ex);
            this.exception = ex;
            this.logMultipleSqlExceptions(ex);
        }
        catch (InterruptedException ex) {
            this.rollback(ex);
            LOGGER.log(Level.FINE, "Batch inserter was interrupted: {0}", ex);
        }
    }

    void incrementCommitCounter() {
        ++this.commitCounter;
    }

    int getCommitCounter() {
        return this.commitCounter;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    SQLException getException() {
        return this.exception;
    }

    void requestStop() {
        this.stop = true;
    }

    private void logMultipleSqlExceptions(SQLException sqlException) {
        if (sqlException.getNextException() != null) {
            LOGGER.log(Level.SEVERE, "Error doing batch insert, threw multiple SQL exceptions. The first one will propagate up the stack, but here are all of them so you can see them:");
            SQLException sqle = sqlException;
            int i = 1;
            do {
                LOGGER.log(Level.SEVERE, "Error " + i++, sqle);
            } while ((sqle = sqle.getNextException()) != null);
        }
    }

    private void rollback(Throwable throwable) {
        if (this.commit) {
            try {
                this.ps.getConnection().rollback();
            }
            catch (SQLException ignore) {
                throwable.addSuppressed(ignore);
            }
        }
    }
}

