/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.ReferenceMap;
import org.arp.javautil.arrays.Arrays;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;

class CollectSubtreeGetterSlowStrategy {
    private final Map<Set<String>, InDataSourceResult<String>> propIdInDataSourceCache;
    private final Map<Set<String>, InDataSourceResult<PropositionDefinition>> propIdPropInDataSourceCache;
    private final Map<String, PropositionDefinition> propositionDefinitionMap;
    private final PropositionDefinitionWalker propDefWalker;
    private final PropIdWalker propIdWalker;
    private final boolean narrower;

    CollectSubtreeGetterSlowStrategy(Map<String, PropositionDefinition> propositionDefinitionMap, boolean narrower) {
        assert (propositionDefinitionMap != null) : "propositionDefinitionMap cannot be null";
        this.propIdInDataSourceCache = new ReferenceMap();
        this.propIdPropInDataSourceCache = new ReferenceMap();
        this.propositionDefinitionMap = propositionDefinitionMap;
        this.narrower = narrower;
        this.propDefWalker = new PropositionDefinitionWalker();
        this.propIdWalker = new PropIdWalker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Map<Set<String>, InDataSourceResult<Object>> map = this.propIdInDataSourceCache;
        synchronized (map) {
            this.propIdInDataSourceCache.clear();
        }
        map = this.propIdPropInDataSourceCache;
        synchronized (map) {
            this.propIdPropInDataSourceCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InDataSourceResult<String> collectPropIds(boolean inDataSourceOnly, Set<String> propIds) throws KnowledgeSourceReadException {
        if (propIds.contains(null)) {
            throw new IllegalArgumentException("propIds cannot contain a null element");
        }
        Map<Set<String>, InDataSourceResult<String>> map = this.propIdInDataSourceCache;
        synchronized (map) {
            InDataSourceResult<String> cachedResult = this.propIdInDataSourceCache.get(propIds);
            if (cachedResult != null) {
                return cachedResult;
            }
            InDataSourceResult<String> inDataSourceResult = this.propIdWalker.walkNarrowerPropDefs(inDataSourceOnly, propIds);
            this.propIdInDataSourceCache.put(propIds, inDataSourceResult);
            return inDataSourceResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InDataSourceResult<PropositionDefinition> collectPropDefs(boolean inDataSourceOnly, Set<String> propIds) throws KnowledgeSourceReadException {
        if (propIds.contains(null)) {
            throw new IllegalArgumentException("propIds cannot contain a null element");
        }
        Map<Set<String>, InDataSourceResult<PropositionDefinition>> map = this.propIdPropInDataSourceCache;
        synchronized (map) {
            InDataSourceResult<PropositionDefinition> cachedResult = this.propIdPropInDataSourceCache.get(propIds);
            if (cachedResult != null) {
                return cachedResult;
            }
            InDataSourceResult<PropositionDefinition> inDataSourceResult = this.propDefWalker.walkNarrowerPropDefs(inDataSourceOnly, propIds);
            this.propIdPropInDataSourceCache.put(propIds, inDataSourceResult);
            return inDataSourceResult;
        }
    }

    private final class PropIdWalker
    extends Walker<String> {
        private PropIdWalker() {
        }

        @Override
        protected void addToFound(String propId, PropositionDefinition propDef, Set<String> found) {
            found.add(propId);
        }
    }

    private final class PropositionDefinitionWalker
    extends Walker<PropositionDefinition> {
        private PropositionDefinitionWalker() {
        }

        @Override
        protected void addToFound(String propId, PropositionDefinition propDef, Set<PropositionDefinition> found) {
            found.add(propDef);
        }
    }

    private abstract class Walker<E> {
        private Walker() {
        }

        InDataSourceResult<E> walkNarrowerPropDefs(boolean inDataSource, Set<String> propIds) {
            HashSet found = new HashSet();
            HashSet<String> missing = new HashSet<String>();
            LinkedList<String> queue = new LinkedList<String>(propIds);
            while (!queue.isEmpty()) {
                String propId = (String)queue.poll();
                PropositionDefinition pd = (PropositionDefinition)CollectSubtreeGetterSlowStrategy.this.propositionDefinitionMap.get(propId);
                if (pd != null) {
                    if (!inDataSource || pd.getInDataSource()) {
                        this.addToFound(propId, pd, found);
                    }
                    if (CollectSubtreeGetterSlowStrategy.this.narrower) {
                        Arrays.addAll(queue, (Object[][])new String[][]{pd.getChildren()});
                        continue;
                    }
                    Arrays.addAll(queue, (Object[][])new String[][]{pd.getInverseIsA()});
                    continue;
                }
                missing.add(propId);
            }
            InDataSourceResult inDataSourceResult = new InDataSourceResult(found, missing);
            return inDataSourceResult;
        }

        protected abstract void addToFound(String var1, PropositionDefinition var2, Set<E> var3);
    }

    class InDataSourceResult<E> {
        private final Set<E> result;
        private final Set<String> missing;

        private InDataSourceResult(Set<E> result, Set<String> missing) {
            this.result = result;
            this.missing = missing;
        }

        public Set<E> getResult() {
            return this.result;
        }

        public Set<String> getMissing() {
            return this.missing;
        }
    }
}

