/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.protempa.AbstractAbstractionDefinition;
import org.protempa.PropositionDefinitionCheckedVisitor;
import org.protempa.PropositionDefinitionVisitor;
import org.protempa.ProtempaException;
import org.protempa.TemporalExtendedPropositionDefinition;

public final class SliceDefinition
extends AbstractAbstractionDefinition {
    private static final long serialVersionUID = 3339167247610447388L;
    private final Set<TemporalExtendedPropositionDefinition> abstractedFrom;
    private int minIndex;
    private int maxIndex = Integer.MAX_VALUE;
    private boolean mergedInterval;

    public SliceDefinition(String id) {
        super(id);
        this.abstractedFrom = new HashSet<TemporalExtendedPropositionDefinition>();
    }

    public void setMinIndex(int minIndex) {
        if (minIndex >= 0) {
            this.minIndex = minIndex;
        }
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public void setMaxIndex(int maxIndex) {
        if (maxIndex >= 0) {
            this.maxIndex = maxIndex;
        }
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public boolean isMergedInterval() {
        return this.mergedInterval;
    }

    public void setMergedInterval(boolean mergedInterval) {
        this.mergedInterval = mergedInterval;
    }

    @Override
    public void accept(PropositionDefinitionVisitor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor cannot be null.");
        }
        processor.visit(this);
    }

    @Override
    public void acceptChecked(PropositionDefinitionCheckedVisitor processor) throws ProtempaException {
        if (processor == null) {
            throw new IllegalArgumentException("processor cannot be null.");
        }
        processor.visit(this);
    }

    @Override
    public Set<String> getAbstractedFrom() {
        HashSet<String> propIds = new HashSet<String>();
        for (TemporalExtendedPropositionDefinition tepd : this.abstractedFrom) {
            propIds.add(tepd.getPropositionId());
        }
        return propIds;
    }

    public boolean add(TemporalExtendedPropositionDefinition tepd) {
        if (tepd != null) {
            boolean result = this.abstractedFrom.add(tepd);
            if (result) {
                this.recalculateChildren();
            }
            return result;
        }
        return false;
    }

    public Set<TemporalExtendedPropositionDefinition> getTemporalExtendedPropositionDefinitions() {
        return Collections.unmodifiableSet(this.abstractedFrom);
    }

    @Override
    public void reset() {
        super.reset();
        this.minIndex = 0;
        this.maxIndex = Integer.MAX_VALUE;
        this.abstractedFrom.clear();
        this.recalculateChildren();
    }

    @Override
    public boolean isConcatenable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    protected void recalculateChildren() {
        String[] old = this.children;
        Set<String> abstractedFrom = this.getAbstractedFrom();
        this.children = abstractedFrom.toArray(new String[abstractedFrom.size()]);
        if (this.changes != null) {
            this.changes.firePropertyChange("children", old, this.children);
        }
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }
}

