/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.sync.impl;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.sync.ChangeReader;
import com.sleepycat.je.sync.SyncDataSet;
import com.sleepycat.je.sync.SyncDatabase;
import com.sleepycat.je.sync.SyncProcessor;
import com.sleepycat.je.sync.impl.LogChangeSet;
import com.sleepycat.je.sync.impl.SyncCleanerBarrier;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogChangeReader
implements ChangeReader {
    public static final LogEntryType[] targetTypes = new LogEntryType[]{LogEntryType.LOG_INS_LN_TRANSACTIONAL, LogEntryType.LOG_UPD_LN_TRANSACTIONAL, LogEntryType.LOG_DEL_LN_TRANSACTIONAL, LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL, LogEntryType.LOG_TXN_COMMIT, LogEntryType.LOG_TXN_ABORT};
    private static final LogChangeSet.LogChangeSetBinding binding = new LogChangeSet.LogChangeSetBinding();
    private final EnvironmentImpl envImpl;
    private final String dataSetName;
    private final SyncProcessor processor;
    private final boolean consolidateTransactions;
    private final long consolidateMaxMemory;
    private LogChangeSet changeSet;
    private long readStart;
    private boolean firstCreateReader = true;
    private long lastSyncEnd = 0L;
    private final Map<Long, ChangeReader.ChangeTxn> txns = new LinkedHashMap<Long, ChangeReader.ChangeTxn>();
    private final Map<DatabaseId, DbInfo> syncDbs = new HashMap<DatabaseId, DbInfo>();
    private TestHook waitHook;

    public LogChangeReader(Environment env, String dataSetName, SyncProcessor processor, boolean consolidateTransactions, long consolidateMaxMemory) {
        this.envImpl = DbInternal.getEnvironmentImpl(env);
        this.dataSetName = dataSetName;
        this.processor = processor;
        this.consolidateTransactions = consolidateTransactions;
        this.consolidateMaxMemory = consolidateMaxMemory;
        this.initChangeSet(env);
        this.getSyncDbs(env);
        this.readStart = this.changeSet.getNextSyncStart();
        assert (this.readStart != 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initChangeSet(Environment env) {
        Transaction txn;
        block3: {
            txn = env.beginTransaction(null, null);
            boolean success = false;
            try {
                DatabaseEntry changeSetData = new DatabaseEntry();
                this.processor.readChangeSetData(txn, this.dataSetName, changeSetData);
                this.changeSet = changeSetData.getData() == null ? new LogChangeSet() : (LogChangeSet)binding.entryToObject(changeSetData);
                success = true;
                Object var6_5 = null;
                if (!success) break block3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (success) {
                    txn.commit();
                    throw throwable;
                }
                txn.abort();
                throw throwable;
            }
            txn.commit();
            return;
        }
        txn.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSyncDbs(Environment env) {
        SyncDataSet dataSet = this.processor.getDataSets().get(this.dataSetName);
        Iterator<SyncDatabase> databases = dataSet.getDatabases().iterator();
        while (databases.hasNext()) {
            Object var9_8;
            Locker readLocker = null;
            boolean operationOK = false;
            DatabaseImpl dbImpl = null;
            String dbName = databases.next().getLocalName();
            try {
                readLocker = LockerFactory.getReadableLocker(env, null, false, false);
                dbImpl = this.envImpl.getDbTree().getDb(readLocker, dbName, null);
                if (dbImpl != null) {
                    this.syncDbs.put(dbImpl.getId(), new DbInfo(dbName, dbImpl.getSortedDuplicates()));
                }
                operationOK = true;
                var9_8 = null;
                if (dbImpl != null) {
                    this.envImpl.getDbTree().releaseDb(dbImpl);
                }
                if (readLocker == null) continue;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                if (dbImpl != null) {
                    this.envImpl.getDbTree().releaseDb(dbImpl);
                }
                if (readLocker != null) {
                    readLocker.operationEnd(operationOK);
                }
                throw throwable;
            }
            readLocker.operationEnd(operationOK);
            {
            }
        }
    }

    public Map<DatabaseId, DbInfo> getSyncDbs() {
        return this.syncDbs;
    }

    public LogChangeSet getChangeSet() {
        return this.changeSet;
    }

    private LNFileReader createFileReader() {
        int readBufferSize = this.envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        long currentFileNum = this.envImpl.getFileManager().getCurrentFileNum();
        long finishLsn = DbLsn.makeLsn(currentFileNum - 1L, 0xFFFFFFFFL);
        try {
            if (this.envImpl.isReplicated()) {
                VLSN durableVLSN = this.envImpl.getGroupDurableVLSN();
                if (durableVLSN.isNull()) {
                    return null;
                }
                if (durableVLSN.compareTo(new VLSN(this.readStart)) <= 0) {
                    return null;
                }
                if (this.firstCreateReader) {
                    this.readStart = this.envImpl.getLsnForVLSN(new VLSN(this.readStart), readBufferSize);
                    this.firstCreateReader = false;
                }
                finishLsn = this.envImpl.getLsnForVLSN(durableVLSN, readBufferSize);
            }
        }
        catch (EnvironmentFailureException e) {
            e.addErrorMessage("SyncDataSet: " + this.dataSetName + ", SyncProcessor: " + this.processor.getName());
            throw e;
        }
        LNFileReader reader = new LNFileReader(this.envImpl, readBufferSize, this.readStart, true, -1L, finishLsn, null, -1L);
        for (LogEntryType entryType : targetTypes) {
            reader.addTargetType(entryType);
        }
        return reader;
    }

    @Override
    public Iterator<ChangeReader.ChangeTxn> getChangeTxns() {
        return new LogChangeIterator();
    }

    private void resetChangeSetNextSyncStart() {
        block1: {
            block0: {
                if (this.txns.size() != 0) break block0;
                this.changeSet.setNextSyncStart(this.changeSet.getLastSyncEnd());
                break block1;
            }
            Iterator<ChangeReader.ChangeTxn> i$ = this.txns.values().iterator();
            if (!i$.hasNext()) break block1;
            ChangeReader.ChangeTxn changeTxn = i$.next();
            this.changeSet.setNextSyncStart(((JEChangeTxn)changeTxn).getStartPoint());
        }
    }

    public void setWaitHook(TestHook waitHook) {
        this.waitHook = waitHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardChanges(Transaction txn) {
        SyncCleanerBarrier syncCleanerBarrier = this.envImpl.getSyncCleanerBarrier();
        synchronized (syncCleanerBarrier) {
            TestHookExecute.doHookIfSet(this.waitHook);
            if (this.lastSyncEnd > this.changeSet.getLastSyncEnd()) {
                this.changeSet.setLastSyncEnd(this.lastSyncEnd);
            }
            this.resetChangeSetNextSyncStart();
            this.writeSyncDB(txn);
        }
    }

    private void writeSyncDB(Transaction txn) {
        DatabaseEntry data = new DatabaseEntry();
        binding.objectToEntry(this.changeSet, data);
        this.processor.writeChangeSetData(txn, this.dataSetName, data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LogChangeIterator
    implements Iterator<ChangeReader.ChangeTxn> {
        private LNFileReader reader;
        private ChangeReader.ChangeTxn nextChangeTxn;

        public LogChangeIterator() {
            this.reader = LogChangeReader.this.createFileReader();
        }

        @Override
        public boolean hasNext() {
            if (this.reader == null) {
                return false;
            }
            if (this.nextChangeTxn != null) {
                return true;
            }
            if (!this.hasNextChangeTxn()) {
                this.nextChangeTxn = null;
                return false;
            }
            return true;
        }

        @Override
        public ChangeReader.ChangeTxn next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No ChangeTxn can be read from the log.");
            }
            ChangeReader.ChangeTxn returnVal = this.nextChangeTxn;
            LogChangeReader.this.txns.remove(this.nextChangeTxn.getTransactionId());
            this.nextChangeTxn = null;
            long commitPoint = ((JEChangeTxn)returnVal).getCommitPoint();
            if (LogChangeReader.this.lastSyncEnd < commitPoint) {
                LogChangeReader.this.lastSyncEnd = commitPoint;
            }
            return returnVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator returned by ChangeReader.getChangeTxns() doesn't support remove operation.");
        }

        private boolean hasNextChangeTxn() {
            while (this.reader.readNextEntry()) {
                JEChangeTxn txn;
                if (this.reader.isLN() && !this.reader.isInvisible()) {
                    this.addChange();
                }
                if (this.reader.isCommit() && this.isValidChangeTxn()) {
                    this.nextChangeTxn = (ChangeReader.ChangeTxn)LogChangeReader.this.txns.get(this.reader.getTxnCommitId());
                    return true;
                }
                if (!this.reader.isAbort() || (txn = (JEChangeTxn)LogChangeReader.this.txns.get(this.reader.getTxnAbortId())) == null) continue;
                this.resetReadStart(false);
                txn.clear();
                LogChangeReader.this.txns.remove(txn.getTransactionId());
            }
            return false;
        }

        private void addChange() {
            DatabaseId dbId = this.reader.getDatabaseId();
            if (!LogChangeReader.this.syncDbs.containsKey(dbId)) {
                return;
            }
            DbInfo dbInfo = (DbInfo)LogChangeReader.this.syncDbs.get(dbId);
            long txnId = this.reader.getTxnId();
            JEChangeTxn txn = (JEChangeTxn)LogChangeReader.this.txns.get(txnId);
            if (txn == null) {
                txn = new JEChangeTxn(txnId, this.getEntryPoint());
                LogChangeReader.this.txns.put(txnId, txn);
            }
            LNLogEntry<?> lnEntry = this.reader.getLNLogEntry();
            lnEntry.postFetchInit(dbInfo.duplicates);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = lnEntry.getLN().getData() != null ? new DatabaseEntry() : null;
            lnEntry.getUserKeyData(key, data);
            LogEntryType entryType = LogEntryType.findType(this.reader.getLogEntryType());
            assert (entryType.isUserLNType() && entryType.isTransactional());
            ChangeReader.ChangeType type = ChangeReader.ChangeType.DELETE;
            if (entryType == LogEntryType.LOG_INS_LN_TRANSACTIONAL) {
                type = ChangeReader.ChangeType.INSERT;
            } else if (entryType == LogEntryType.LOG_UPD_LN_TRANSACTIONAL) {
                type = ChangeReader.ChangeType.UPDATE;
            }
            txn.addChange(dbInfo.name, new JEChange(type, key, data, dbInfo.name));
            this.resetReadStart(false);
        }

        private boolean isValidChangeTxn() {
            JEChangeTxn txn = (JEChangeTxn)LogChangeReader.this.txns.get(this.reader.getTxnCommitId());
            if (txn == null) {
                return false;
            }
            if (this.getEntryPoint() > LogChangeReader.this.changeSet.getLastSyncEnd()) {
                txn.setCommitPoint(this.getEntryPoint());
                this.resetReadStart(true);
                return true;
            }
            txn.clear();
            LogChangeReader.this.txns.remove(txn.getTransactionId());
            return false;
        }

        private void resetReadStart(boolean commitEntry) {
            if (LogChangeReader.this.readStart < this.reader.getLastLsn()) {
                LogChangeReader.this.readStart = this.reader.getLastLsn();
                if (commitEntry) {
                    LogChangeReader.this.readStart += this.reader.getLastEntrySize();
                }
            }
        }

        private long getEntryPoint() {
            return LogChangeReader.this.envImpl.isReplicated() ? this.reader.getVLSN() : this.reader.getLastLsn();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JEChangeTxn
    implements ChangeReader.ChangeTxn {
        private final long txnId;
        private long startPoint = 0L;
        private long commitPoint = 0L;
        private final Set<String> dbNames = new HashSet<String>();
        private final ArrayList<ChangeReader.Change> operations = new ArrayList();

        public JEChangeTxn(long txnId, long startPoint) {
            this.txnId = txnId;
            this.startPoint = startPoint;
        }

        @Override
        public long getTransactionId() {
            return this.txnId;
        }

        @Override
        public String getDataSetName() {
            return LogChangeReader.this.dataSetName;
        }

        @Override
        public Set<String> getDatabaseNames() {
            return this.dbNames;
        }

        @Override
        public Iterator<ChangeReader.Change> getOperations() {
            return this.operations.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discardChanges(Transaction txn) {
            SyncCleanerBarrier syncCleanerBarrier = LogChangeReader.this.envImpl.getSyncCleanerBarrier();
            synchronized (syncCleanerBarrier) {
                this.clear();
                LogChangeReader.this.changeSet.setLastSyncEnd(this.commitPoint);
                LogChangeReader.this.resetChangeSetNextSyncStart();
                LogChangeReader.this.writeSyncDB(txn);
            }
        }

        private void addChange(String dbName, ChangeReader.Change operation) {
            if (!this.dbNames.contains(dbName)) {
                this.dbNames.add(dbName);
            }
            this.operations.add(operation);
        }

        private void setCommitPoint(long commitPoint) {
            this.commitPoint = commitPoint;
        }

        private long getStartPoint() {
            return this.startPoint;
        }

        private long getCommitPoint() {
            return this.commitPoint;
        }

        private void clear() {
            this.dbNames.clear();
            this.operations.clear();
        }
    }

    public class JEChange
    implements ChangeReader.Change {
        private final ChangeReader.ChangeType type;
        private final DatabaseEntry key;
        private final DatabaseEntry data;
        private final String dbName;

        public JEChange(ChangeReader.ChangeType type, DatabaseEntry key, DatabaseEntry data, String dbName) {
            this.type = type;
            this.key = key;
            this.data = data;
            this.dbName = dbName;
        }

        public ChangeReader.ChangeType getType() {
            return this.type;
        }

        public DatabaseEntry getKey() {
            return this.key;
        }

        public DatabaseEntry getData() {
            return this.data;
        }

        public String getDatabaseName() {
            return this.dbName;
        }
    }

    public class DbInfo {
        public final String name;
        public final boolean duplicates;

        DbInfo(String name, boolean duplicates) {
            this.name = name;
            this.duplicates = duplicates;
        }
    }
}

