/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.DbCacheSizeRepEnv;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class DbCacheSize {
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance();
    private static final String MAIN_HEADER = " Minimum Bytes    Maximum Bytes   Description\n---------------  ---------------  -----------";
    private static final String LEVELS_HEADER = " Minimum Bytes    Maximum Bytes      Nodes    Level\n---------------  ---------------  ----------  -----";
    private static final int COLUMN_WIDTH = 15;
    private static final String COLUMN_SEPARATOR = "  ";
    private static final int MAX_LEVELS = 9;
    private static final int DEFAULT_DENSITY = 70;
    private static final int ORDERED_DENSITY = 100;
    private final EnvironmentConfig envConfig = new EnvironmentConfig();
    private final Map<String, String> repParams = new HashMap<String, String>();
    private long records = 0L;
    private int keySize = 0;
    private int dataSize = -1;
    private int nodeMaxEntries = 128;
    private int binMaxEntries = -1;
    private int density = 70;
    private int keyPrefix = 0;
    private boolean orderedInsertion = false;
    private boolean duplicates = false;
    private boolean replicated = false;
    private boolean outputProperties = false;
    private boolean doMeasure = false;
    private long envOverhead;
    private long minInSize;
    private long maxInSize;
    private long minBinSize;
    private long minBinSizeWithData;
    private long maxBinSize;
    private long maxBinSizeWithData;
    private long minBtreeSize;
    private long minBtreeSizeWithData;
    private long maxBtreeSize;
    private long maxBtreeSizeWithData;
    private long measuredBtreeSize;
    private long measuredBtreeSizeWithData;
    private int btreeLevels;
    private final long[] numLevel = new long[9];
    private final long[] minLevel = new long[9];
    private final long[] maxLevel = new long[9];
    private File tempDir;

    DbCacheSize() {
    }

    void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String name = args[i];
            String val = null;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                val = args[++i];
            }
            if (name.equals("-records")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -records");
                }
                try {
                    this.records = Long.parseLong(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.records > 0L) continue;
                DbCacheSize.usage(val + " is not a positive integer");
                continue;
            }
            if (name.equals("-key")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -key");
                }
                try {
                    this.keySize = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.keySize > 0) continue;
                DbCacheSize.usage(val + " is not a positive integer");
                continue;
            }
            if (name.equals("-data")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -data");
                }
                try {
                    this.dataSize = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.dataSize >= 0) continue;
                DbCacheSize.usage(val + " is not a non-negative integer");
                continue;
            }
            if (name.equals("-keyprefix")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -keyprefix");
                }
                try {
                    this.keyPrefix = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.keyPrefix >= 0) continue;
                DbCacheSize.usage(val + " is not a non-negative integer");
                continue;
            }
            if (name.equals("-orderedinsertion")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.orderedInsertion = true;
                continue;
            }
            if (name.equals("-duplicates")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.duplicates = true;
                continue;
            }
            if (name.equals("-replicated")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.replicated = true;
                continue;
            }
            if (name.equals("-nodemax")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -nodemax");
                }
                try {
                    this.nodeMaxEntries = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.nodeMaxEntries > 0) continue;
                DbCacheSize.usage(val + " is not a positive integer");
                continue;
            }
            if (name.equals("-binmax")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -binmax");
                }
                try {
                    this.binMaxEntries = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.binMaxEntries > 0) continue;
                DbCacheSize.usage(val + " is not a positive integer");
                continue;
            }
            if (name.equals("-density")) {
                DbCacheSize.usage("-density is no longer supported, see -orderedinsertion");
                continue;
            }
            if (name.equals("-overhead")) {
                DbCacheSize.usage("-overhead is no longer supported");
                continue;
            }
            if (name.startsWith("-je.")) {
                if (val == null) {
                    DbCacheSize.usage("No value after " + name);
                }
                if (name.startsWith("-je.rep.")) {
                    this.repParams.put(name.substring(1), val);
                    continue;
                }
                this.envConfig.setConfigParam(name.substring(1), val);
                continue;
            }
            if (name.equals("-measure")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.doMeasure = true;
                continue;
            }
            if (name.equals("-outputproperties")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.outputProperties = true;
                continue;
            }
            DbCacheSize.usage("Unknown arg: " + name);
        }
        if (this.records == 0L) {
            DbCacheSize.usage("-records not specified");
        }
        if (this.keySize == 0) {
            DbCacheSize.usage("-key not specified");
        }
    }

    void cleanup() {
        if (this.tempDir != null) {
            this.emptyTempDir();
            this.tempDir.delete();
        }
    }

    long getEnvOverhead() {
        return this.envOverhead;
    }

    long getMinBtreeSize() {
        return this.minBtreeSize;
    }

    long getMaxBtreeSize() {
        return this.maxBtreeSize;
    }

    long getMinBtreeSizeWithData() {
        return this.minBtreeSizeWithData;
    }

    long getMaxBtreeSizeWithData() {
        return this.maxBtreeSizeWithData;
    }

    long getMeasuredBtreeSize() {
        return this.measuredBtreeSize;
    }

    long getMeasuredBtreeSizeWithData() {
        return this.measuredBtreeSizeWithData;
    }

    int getBtreeLevels() {
        return this.btreeLevels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        DbCacheSize dbCacheSize = new DbCacheSize();
        try {
            block6: {
                try {
                    dbCacheSize.parseArgs(args);
                    dbCacheSize.calculateCacheSizes();
                    if (dbCacheSize.outputProperties) {
                        dbCacheSize.printProperties(System.out);
                    } else {
                        dbCacheSize.printCacheSizes(System.out);
                    }
                    if (!dbCacheSize.doMeasure) break block6;
                    dbCacheSize.measure(System.out);
                }
                catch (Throwable e) {
                    e.printStackTrace(System.out);
                    Object var4_3 = null;
                    dbCacheSize.cleanup();
                }
            }
            Object var4_2 = null;
            dbCacheSize.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            dbCacheSize.cleanup();
            throw throwable;
        }
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println("usage:\njava " + CmdUtil.getJavaCommand(DbCacheSize.class) + "\n   -records <count>" + "\n      # Total records (key/data pairs); required" + "\n   -key <bytes> " + "\n      # Average key bytes per record; required" + "\n  [-data <bytes>]" + "\n      # Average data bytes per record; if omitted no leaf" + "\n      # node sizes are included in the output; required with" + "\n      # -duplicates, and specifies the primary key length" + "\n  [-keyprefix <bytes>]" + "\n      # Expected size of the prefix for the keys in each" + "\n      # BIN; default: zero, key prefixing is not configured;" + "\n      # required with -duplicates" + "\n  [-nodemax <entries>]" + "\n      # Number of entries per Btree node; default: 128" + "\n  [-orderedinsertion]" + "\n      # Assume ordered insertions and no deletions, so BINs" + "\n      # are 100% full; default: unordered insertions and/or" + "\n      # deletions, BINs are 70% full" + "\n  [-duplicates]" + "\n      # Indicates that sorted duplicates are used, including" + "\n      # MANY_TO_ONE and MANY_TO_MANY secondary indices;" + "\n      # default: false" + "\n  [-replicated]" + "\n      # Use a ReplicatedEnvironment; default: false" + "\n  [-ENV_PARAM_NAME VALUE]..." + "\n      # Any number of EnvironmentConfig parameters and" + "\n      # ReplicationConfig parameters (if -replicated)" + "\n  [-outputproperties]" + "\n      # Writes Java properties to System.out:" + "\n      #  overhead, minInternalNodes, maxInternalNodes, " + "\n      #  minAllNodes, maxAllNodes (with -data)");
        System.exit(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void calculateCacheSizes() {
        if (this.binMaxEntries <= 0) {
            this.binMaxEntries = this.nodeMaxEntries;
        }
        Environment env = this.openCalcEnvironment(true);
        boolean success = false;
        try {
            int level;
            this.envOverhead = env.getStats(null).getCacheTotalBytes();
            int density = this.orderedInsertion ? 100 : 70;
            int nodeAvg = this.nodeMaxEntries * density / 100;
            int binAvg = this.binMaxEntries * density / 100;
            long nBinNodes = (this.records + (long)binAvg - 1L) / (long)binAvg;
            this.calcTreeSizes(env, nodeAvg, binAvg);
            this.numLevel[0] = nBinNodes;
            this.minLevel[0] = nBinNodes * this.minBinSize;
            this.maxLevel[0] = nBinNodes * this.maxBinSize;
            this.btreeLevels = 1;
            long nodes = nBinNodes / (long)nodeAvg;
            while (true) {
                if (this.btreeLevels >= 9) {
                    throw new IllegalArgumentException("Maximum levels (9) exceeded.");
                }
                if (nodes == 0L) {
                    nodes = 1L;
                }
                this.numLevel[this.btreeLevels] = nodes;
                this.minLevel[this.btreeLevels] = nodes * this.minInSize;
                this.maxLevel[this.btreeLevels] = nodes * this.maxInSize;
                ++this.btreeLevels;
                if (nodes == 1L) break;
                nodes /= (long)nodeAvg;
            }
            this.minBtreeSize = 0L;
            this.maxBtreeSize = 0L;
            for (level = 0; level < this.btreeLevels; ++level) {
                this.minBtreeSize += this.minLevel[level];
                this.maxBtreeSize += this.maxLevel[level];
            }
            this.minBtreeSizeWithData = nBinNodes * this.minBinSizeWithData;
            this.maxBtreeSizeWithData = nBinNodes * this.maxBinSizeWithData;
            for (level = 1; level < this.btreeLevels; ++level) {
                this.minBtreeSizeWithData += this.minLevel[level];
                this.maxBtreeSizeWithData += this.maxLevel[level];
            }
            success = true;
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            try {
                env.close();
                throw throwable;
            }
            catch (RuntimeException e) {
                if (!success) throw throwable;
                throw e;
            }
        }
        try {
            env.close();
            return;
        }
        catch (RuntimeException e) {
            if (!success) return;
            throw e;
        }
    }

    private void calcTreeSizes(Environment env, int nodeAvg, int binAvg) {
        OperationStatus status;
        if (this.nodeMaxEntries != this.binMaxEntries) {
            throw new IllegalArgumentException("-binmax not currently supported because a per-BIN max is not implemented in the Btree, so we can't measure an actual BIN node with the given -binmax value");
        }
        assert (nodeAvg == binAvg);
        if (nodeAvg > 65535) {
            throw new IllegalArgumentException("Entries per node (" + nodeAvg + ") is greater than 0xFFFF");
        }
        byte[] keyBytes = new byte[nodeAvg <= 255 ? 1 : 2];
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        Database db = this.openDatabase(env, true);
        for (int i = 0; i < nodeAvg; ++i) {
            if (keyBytes.length == 1) {
                keyBytes[0] = (byte)i;
            } else {
                assert (keyBytes.length == 2);
                keyBytes[0] = (byte)(i >> 8);
                keyBytes[1] = (byte)i;
            }
            this.setKeyData(keyBytes, this.keyPrefix, keyEntry, dataEntry);
            status = this.duplicates ? db.putNoDupData(null, keyEntry, dataEntry) : db.putNoOverwrite(null, keyEntry, dataEntry);
            if (status == OperationStatus.SUCCESS) continue;
            throw new IllegalStateException(status.toString());
        }
        Cursor cursor = db.openCursor(null, null);
        status = cursor.getFirst(keyEntry, dataEntry, null);
        assert (status == OperationStatus.SUCCESS);
        BIN bin = DbInternal.getCursorImpl(cursor).getBIN();
        bin.recalcKeyPrefix();
        bin.compactMemory();
        this.minBinSizeWithData = bin.getInMemorySize();
        for (int i = 0; i < nodeAvg; ++i) {
            assert (status == OperationStatus.SUCCESS);
            CursorImpl cursorImpl = DbInternal.getCursorImpl(cursor);
            assert (bin == cursorImpl.getBIN());
            assert (!this.duplicates ? bin.getTarget(i) != null : bin.getTarget(i) == null);
            if (!this.duplicates) {
                cursorImpl.evict();
            }
            status = cursor.getNext(keyEntry, dataEntry, null);
        }
        assert (status == OperationStatus.NOTFOUND);
        cursor.close();
        bin.compactMemory();
        this.minBinSize = bin.getInMemorySize();
        bin.clearLsnCompaction();
        this.maxBinSize = bin.getInMemorySize();
        long lsnSavings = this.maxBinSize - this.minBinSize;
        this.maxBinSizeWithData = this.minBinSizeWithData + lsnSavings;
        IN in = DbInternal.getDatabaseImpl(db).getTree().getRootINLatchedExclusive(CacheMode.DEFAULT);
        assert (bin == in.getTarget(0));
        for (int i = 1; i < nodeAvg; ++i) {
            ChildReference child = new ChildReference(bin, bin.getKey(i), bin.getLsn(i));
            int result = in.insertEntry1(child);
            assert ((result & 0x20000) != 0);
            assert (i == (result & 0xFFFDFFFF));
        }
        in.recalcKeyPrefix();
        in.compactMemory();
        in.releaseLatch();
        this.minInSize = in.getInMemorySize();
        this.maxInSize = this.minInSize + lsnSavings;
        db.close();
    }

    private void setKeyData(byte[] keyBytes, int keyOffset, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
        byte[] finalData;
        byte[] finalKey;
        byte[] fullKey = this.duplicates ? new byte[this.keySize + this.dataSize] : new byte[this.keySize];
        if (this.keyPrefix + keyBytes.length > fullKey.length) {
            throw new IllegalArgumentException("Key doesn't fit, allowedLen=" + fullKey.length + " keyLen=" + keyBytes.length + " prefixLen=" + this.keyPrefix);
        }
        System.arraycopy(keyBytes, 0, fullKey, keyOffset, keyBytes.length);
        if (this.duplicates) {
            finalKey = new byte[this.keySize];
            finalData = new byte[this.dataSize];
            System.arraycopy(fullKey, 0, finalKey, 0, this.keySize);
            System.arraycopy(fullKey, this.keySize, finalData, 0, this.dataSize);
        } else {
            finalKey = fullKey;
            finalData = new byte[Math.max(0, this.dataSize)];
        }
        keyEntry.setData(finalKey);
        dataEntry.setData(finalData);
    }

    private void printProperties(PrintStream out) {
        out.println("overhead=" + this.envOverhead);
        out.println("minInternalNodes=" + this.minBtreeSize);
        out.println("maxInternalNodes=" + this.maxBtreeSize);
        if (this.dataSize >= 0) {
            out.println("minAllNodes=" + this.minBtreeSizeWithData);
            out.println("maxAllNodes=" + this.maxBtreeSizeWithData);
        }
    }

    private void printCacheSizes(PrintStream out) {
        out.println();
        out.println("=== Environment Cache Overhead ===");
        out.println();
        out.print(INT_FORMAT.format(this.envOverhead));
        out.println(" minimum bytes");
        out.println();
        out.println("To account for JE daemon operation and record locks,");
        out.println("a significantly larger amount is needed in practice.");
        out.println();
        out.println("=== Database Cache Size ===");
        out.println();
        out.println(MAIN_HEADER);
        out.println(this.line(this.minBtreeSize, this.maxBtreeSize, "Internal nodes only"));
        if (this.dataSize >= 0) {
            out.println(this.line(this.minBtreeSizeWithData, this.maxBtreeSizeWithData, "Internal nodes and leaf nodes"));
            if (this.duplicates) {
                out.println("\nNote that leaf nodes do not use additional memory");
                out.println("in a database configured for duplicates.");
            }
        } else if (!this.duplicates) {
            out.println("\nTo get leaf node sizing specify -data");
        }
        out.println();
        out.println("=== Internal Node Usage by Btree Level ===");
        out.println();
        out.println(LEVELS_HEADER);
        for (int level = 0; level < this.btreeLevels; ++level) {
            StringBuilder buf = new StringBuilder();
            buf.append(INT_FORMAT.format(this.numLevel[level]));
            buf.append("    ");
            buf.append(level + 1);
            String lastCol = buf.toString();
            out.println(this.line(this.minLevel[level], this.maxLevel[level], lastCol));
        }
    }

    private String line(long col1, long col2, String comment) {
        StringBuilder buf = new StringBuilder(100);
        this.column(buf, INT_FORMAT.format(col1));
        buf.append(COLUMN_SEPARATOR);
        this.column(buf, INT_FORMAT.format(col2));
        buf.append(COLUMN_SEPARATOR);
        this.column(buf, comment);
        return buf.toString();
    }

    private void column(StringBuilder buf, String str) {
        int start = buf.length();
        while (buf.length() - start + str.length() < 15) {
            buf.append(' ');
        }
        buf.append(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void measure(PrintStream out) {
        Environment env = this.openMeasureEnvironment(true);
        try {
            Database db = this.openDatabase(env, true);
            if (out != null) {
                out.println("\nMeasuring with cache size: " + INT_FORMAT.format(env.getConfig().getCacheSize()));
            }
            this.insertRecords(out, env, db);
            this.measuredBtreeSize = DbCacheSize.getStats(out, env, "Stats after insert");
            db.close();
            db = null;
            env.close();
            env = null;
            env = this.openMeasureEnvironment(false);
            db = this.openDatabase(env, false);
            if (out != null) {
                out.println("\nPreloading with cache size: " + INT_FORMAT.format(env.getConfig().getCacheSize()));
            }
            PreloadStatus status = DbCacheSize.preloadRecords(out, db, false);
            DbCacheSize.getStats(out, env, "Stats for internal nodes only after preload (" + status + ")");
            if (this.dataSize >= 0) {
                status = DbCacheSize.preloadRecords(out, db, true);
                this.measuredBtreeSizeWithData = DbCacheSize.getStats(out, env, "Stats for all nodes after preload (" + status + ")");
            }
            db.close();
            db = null;
            env.close();
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (env == null) throw throwable;
            try {
                env.close();
                throw throwable;
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private Environment openMeasureEnvironment(boolean createNew) {
        EnvironmentConfig config = this.envConfig.clone();
        config.setCachePercent(90);
        return this.openEnvironment(config, createNew);
    }

    private Environment openCalcEnvironment(boolean createNew) {
        EnvironmentConfig config = this.envConfig.clone();
        return this.openEnvironment(config, createNew);
    }

    private Environment openEnvironment(EnvironmentConfig config, boolean createNew) {
        this.mkTempDir();
        if (createNew) {
            this.emptyTempDir();
        }
        config.setTransactional(true);
        config.setAllowCreate(createNew);
        config.setConfigParam("je.env.runCleaner", "false");
        config.setConfigParam("je.env.runCheckpointer", "false");
        if (this.replicated) {
            try {
                Class<?> repEnvClass = Class.forName("com.sleepycat.je.rep.utilint.DbCacheSizeRepEnv");
                DbCacheSizeRepEnv repEnv = (DbCacheSizeRepEnv)repEnvClass.newInstance();
                return repEnv.open(this.tempDir, config, this.repParams);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        if (!this.repParams.isEmpty()) {
            throw new IllegalArgumentException("Cannot set replication params in a standalone environment.  May add -replicated.");
        }
        return new Environment(this.tempDir, config);
    }

    private void mkTempDir() {
        if (this.tempDir == null) {
            try {
                this.tempDir = File.createTempFile("DbCacheSize", null);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.tempDir.delete();
            this.tempDir.mkdir();
        }
    }

    private void emptyTempDir() {
        if (this.tempDir == null) {
            return;
        }
        File[] children = this.tempDir.listFiles();
        if (children != null) {
            for (File child : children) {
                child.delete();
            }
        }
    }

    private Database openDatabase(Environment env, boolean createNew) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(createNew);
        dbConfig.setExclusiveCreate(createNew);
        dbConfig.setNodeMaxEntries(this.nodeMaxEntries);
        dbConfig.setKeyPrefixing(this.keyPrefix > 0);
        dbConfig.setSortedDuplicates(this.duplicates);
        return env.openDatabase(null, "foo", dbConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertRecords(PrintStream out, Environment env, Database db) {
        int keyOffset;
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        int lastKey = (int)(this.records - 1L);
        byte[] lastKeyBytes = BigInteger.valueOf(lastKey).toByteArray();
        int maxKeyBytes = lastKeyBytes.length;
        if (this.keyPrefix == 0) {
            keyOffset = 0;
        } else {
            int calcPrefix;
            int nodeAvg = this.orderedInsertion ? this.nodeMaxEntries : this.nodeMaxEntries * 70 / 100;
            int prevKey = lastKey - nodeAvg * 2;
            byte[] prevKeyBytes = this.padLeft(BigInteger.valueOf(prevKey).toByteArray(), maxKeyBytes);
            for (calcPrefix = 0; calcPrefix < lastKeyBytes.length && calcPrefix < prevKeyBytes.length && lastKeyBytes[calcPrefix] == prevKeyBytes[calcPrefix]; ++calcPrefix) {
            }
            keyOffset = this.keyPrefix - calcPrefix;
        }
        ArrayList<Integer> rndKeys = null;
        if (!this.orderedInsertion) {
            rndKeys = new ArrayList<Integer>(lastKey + 1);
            for (int i = 0; i <= lastKey; ++i) {
                rndKeys.add(i);
            }
            Collections.shuffle(rndKeys, new Random(123L));
        }
        Transaction txn = env.beginTransaction(null, null);
        Cursor cursor = db.openCursor(txn, null);
        boolean success = false;
        try {
            cursor.setCacheMode(CacheMode.EVICT_LN);
            for (int i = 0; i <= lastKey; ++i) {
                int keyVal = this.orderedInsertion ? i : (Integer)rndKeys.get(i);
                byte[] keyBytes = this.padLeft(BigInteger.valueOf(keyVal).toByteArray(), maxKeyBytes);
                this.setKeyData(keyBytes, keyOffset, keyEntry, dataEntry);
                OperationStatus status = this.duplicates ? cursor.putNoDupData(keyEntry, dataEntry) : cursor.putNoOverwrite(keyEntry, dataEntry);
                if (status == OperationStatus.KEYEXIST && !this.orderedInsertion) {
                    --i;
                    continue;
                }
                if (status != OperationStatus.SUCCESS) {
                    throw new IllegalStateException("Could not insert: " + (Object)((Object)status));
                }
                if (i % 10000 != 0) continue;
                EnvironmentStats stats = env.getStats(null);
                if (stats.getNNodesScanned() > 0L) {
                    throw new IllegalStateException("*** Ran out of cache memory at record " + i + " -- try increasing Java heap size ***");
                }
                if (out == null) continue;
                out.print(".");
                out.flush();
            }
            success = true;
            Object var20_21 = null;
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            cursor.close();
            if (success) {
                txn.commit();
                throw throwable;
            }
            txn.abort();
            throw throwable;
        }
        cursor.close();
        if (success) {
            txn.commit();
        } else {
            txn.abort();
        }
        env.checkpoint(new CheckpointConfig().setForce(true));
    }

    private byte[] padLeft(byte[] data, int size) {
        assert (data.length <= size);
        if (data.length == size) {
            return data;
        }
        byte[] b = new byte[size];
        System.arraycopy(data, 0, b, size - data.length, data.length);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PreloadStatus preloadRecords(final PrintStream out, Database db, boolean loadLNs) {
        PreloadStats stats;
        Thread thread = null;
        if (out != null) {
            thread = new Thread(){

                public void run() {
                    try {
                        while (true) {
                            out.print(".");
                            out.flush();
                            Thread.sleep(5000L);
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            };
            thread.start();
        }
        try {
            stats = db.preload(new PreloadConfig().setLoadLNs(loadLNs));
            Object var6_5 = null;
            if (thread != null) {
                thread.interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (thread != null) {
                thread.interrupt();
            }
            throw throwable;
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace(out);
            }
        }
        db.getEnvironment().checkpoint(new CheckpointConfig().setForce(true));
        return stats.getStatus();
    }

    private static long getStats(PrintStream out, Environment env, String msg) {
        if (out != null) {
            out.println();
            out.println(msg + ':');
        }
        EnvironmentStats stats = env.getStats(null);
        long btreeSize = DbInternal.getEnvironmentImpl(env).getMemoryBudget().getTreeMemoryUsage();
        if (out != null) {
            out.println("CacheSize=" + INT_FORMAT.format(stats.getCacheTotalBytes()) + " BtreeSize=" + INT_FORMAT.format(btreeSize) + " BottomINs=" + INT_FORMAT.format(stats.getNCachedBINs()) + " UpperINs=" + INT_FORMAT.format(stats.getNCachedUpperINs()) + " NCacheMiss=" + INT_FORMAT.format(stats.getNCacheMiss()));
        }
        if (stats.getNNodesScanned() > 0L) {
            throw new IllegalStateException("*** All records did not fit in the cache ***");
        }
        return btreeSize;
    }
}

