/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.conversion;

import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionHandler;
import org.mvel.conversion.Converter;

public class StringArrayCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV;

    static {
        Class<?> clazz;
        CNV = new HashMap<Class, Converter>();
        try {
            clazz = Class.forName("[Ljava.lang.Object;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz, new Converter(){

            public Object convert(Object o) {
                Object[] old = (Object[])o;
                String[] n = new String[old.length];
                int i = 0;
                while (i < old.length) {
                    n[i] = String.valueOf(old[i]);
                    ++i;
                }
                return n;
            }
        });
    }

    public Object convertFrom(Object in) {
        if (in.getClass().isArray()) {
            Object[] old = (Object[])in;
            String[] n = new String[old.length];
            int i = 0;
            while (i < old.length) {
                n[i] = String.valueOf(old[i]);
                ++i;
            }
            return n;
        }
        return new String[]{String.valueOf(in)};
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

