/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;

abstract class ConceptCodeBuilder {
    private static int NUM_LENGTH = Math.min(5, 50);
    private final Metadata metadata;

    ConceptCodeBuilder(Metadata metadata) {
        assert (metadata != null) : "metadata cannot be null";
        this.metadata = metadata;
    }

    protected Metadata getMetadata() {
        return this.metadata;
    }

    abstract String build() throws InvalidConceptCodeException;

    protected String truncateIfNeeded(String conceptCode) throws InvalidConceptCodeException {
        boolean chopped = false;
        int number = 0;
        String codeWithoutNumber = null;
        while (conceptCode.length() > 50) {
            if (String.valueOf(number).length() > NUM_LENGTH) {
                throw new InvalidConceptCodeException("Could not create a concept code that is not already in use");
            }
            if (!chopped) {
                codeWithoutNumber = conceptCode.substring(0, Math.min(conceptCode.length(), 50 - NUM_LENGTH));
            }
            conceptCode = codeWithoutNumber + number++;
        }
        return conceptCode;
    }
}

