/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptDimensionHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptHierarchyLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import java.sql.SQLException;

public final class ConceptDimensionLoader
extends ConceptHierarchyLoader {
    private final ConceptDimensionHandler handler;

    public ConceptDimensionLoader(ConceptDimensionHandler handler) {
        this.handler = handler;
    }

    @Override
    protected void loadConcept(Concept concept) throws SQLException {
        if (concept.isInUse() && !concept.isModifier()) {
            for (String path : concept.getHierarchyPaths()) {
                ConceptDimension conceptDimension = new ConceptDimension();
                conceptDimension.setPath(path);
                conceptDimension.setConceptCode(concept.getConceptCode());
                conceptDimension.setDisplayName(concept.getDisplayName());
                conceptDimension.setSourceSystemCode(concept.getSourceSystemCode());
                conceptDimension.setDownloaded(TableUtil.setTimestampAttribute(concept.getDownloaded()));
                conceptDimension.setUpdated(TableUtil.setTimestampAttribute(concept.getUpdated()));
                this.handler.insert(conceptDimension);
            }
        }
    }
}

