/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.KnowledgeSourceReadException;

public class TableAccessReader {
    private String[] ontTables;
    private final String excludeTableName;

    public TableAccessReader(String excludeTableName) {
        this.excludeTableName = excludeTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] read(Connection connection) throws KnowledgeSourceReadException {
        TableAccessReader tableAccessReader = this;
        synchronized (tableAccessReader) {
            if (this.ontTables == null) {
                Throwable throwable;
                StringBuilder query = new StringBuilder();
                query.append("SELECT DISTINCT C_TABLE_NAME FROM TABLE_ACCESS");
                if (this.excludeTableName != null) {
                    query.append(" WHERE C_TABLE_NAME <> ?");
                }
                ArrayList<String> tables = new ArrayList<String>();
                try (PreparedStatement stmt = connection.prepareStatement(query.toString());){
                    if (this.excludeTableName != null) {
                        stmt.setString(1, this.excludeTableName);
                    }
                    throwable = null;
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            tables.add(rs.getString(1));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (SQLException ex) {
                    throw new KnowledgeSourceReadException((Throwable)ex);
                }
                try {
                    Iterator itr = tables.iterator();
                    while (itr.hasNext()) {
                        String tableName = (String)itr.next();
                        Statement stmt = connection.createStatement();
                        throwable = null;
                        try {
                            ResultSet resultSet = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE 1 = 0");
                            Throwable throwable3 = null;
                            try {
                                ResultSetMetaData metaData = resultSet.getMetaData();
                                boolean found = false;
                                int n = metaData.getColumnCount();
                                for (int i = 1; i <= n; ++i) {
                                    if (!"EK_UNIQUE_ID".equals(metaData.getColumnLabel(i))) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                itr.remove();
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (resultSet == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                resultSet.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(TableAccessReader.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.ontTables = tables.toArray(new String[tables.size()]);
            }
        }
        return (String[])this.ontTables.clone();
    }
}

