/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb.oracle;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.collections.Collections;
import org.arp.javautil.io.Retryable;
import org.arp.javautil.io.Retryer;
import org.arp.javautil.sql.ConnectionSpec;
import org.arp.javautil.sql.SQLExecutor;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.relationaldb.DataStager;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.RetryableSQLExecutor;
import org.protempa.backend.dsb.relationaldb.SQLOrderBy;
import org.protempa.backend.dsb.relationaldb.StagedColumnSpec;
import org.protempa.backend.dsb.relationaldb.StagingSpec;
import org.protempa.backend.dsb.relationaldb.TableSpec;
import org.protempa.backend.dsb.relationaldb.oracle.Ojdbc6OracleStagingCreateStatement;

final class Ojdbc6OracleDataStager
implements DataStager {
    private static final Logger LOGGER = Logger.getLogger(Ojdbc6OracleDataStager.class.getName());
    private final StagingSpec[] stagingSpecs;
    private final ReferenceSpec referenceSpec;
    private final List<EntitySpec> entitySpecs;
    private final Set<Filter> filters;
    private final Set<String> propIds;
    private final Set<String> keyIds;
    private final SQLOrderBy order;
    private final ConnectionSpec connectionSpec;
    private final Map<String, List<EntitySpec>> propIdToEntitySpecs;
    private final Map<StagingSpec, List<TableSpec>> tempTables = new HashMap<StagingSpec, List<TableSpec>>();
    private final Map<TableSpec, Integer> indexIds = new HashMap<TableSpec, Integer>();
    private final boolean streamingMode;

    Ojdbc6OracleDataStager(StagingSpec[] stagingSpecs, ReferenceSpec referenceSpec, List<EntitySpec> entitySpecs, Set<Filter> filters, Set<String> propIds, Set<String> keyIds, SQLOrderBy order, ConnectionSpec connectionSpec, boolean streamingMode) {
        this.stagingSpecs = stagingSpecs;
        this.referenceSpec = referenceSpec;
        this.entitySpecs = entitySpecs;
        this.filters = filters;
        this.propIds = propIds;
        this.keyIds = keyIds;
        this.order = order;
        this.connectionSpec = connectionSpec;
        this.propIdToEntitySpecs = new HashMap<String, List<EntitySpec>>();
        this.populatePropIdEntitySpecMap();
        this.streamingMode = streamingMode;
    }

    private void populatePropIdEntitySpecMap() {
        for (EntitySpec es : this.entitySpecs) {
            for (String propId : es.getPropositionIds()) {
                Collections.putList(this.propIdToEntitySpecs, (Object)propId, (Object)es);
            }
        }
    }

    @Override
    public void stageTables() throws SQLException {
        this.createTables();
        this.indexTables();
        this.analyzeTables();
        this.mergeTables();
    }

    @Override
    public void cleanup() throws SQLException {
        for (StagingSpec ss : this.stagingSpecs) {
            this.dropTables(ss);
        }
    }

    private void execute(String sql) throws SQLException {
        RetryableSQLExecutor operation;
        Retryer retryer;
        if (this.connectionSpec != null && !(retryer = new Retryer(3)).execute((Retryable)(operation = new RetryableSQLExecutor(this.connectionSpec, sql, null)))) {
            SQLException ex = SQLExecutor.assembleSQLException((List)retryer.getErrors());
            throw ex;
        }
    }

    private void dropTables(StagingSpec stagingSpec) throws SQLException {
        String dropView = "BEGIN EXECUTE IMMEDIATE 'DROP VIEW " + TableSpec.withSchemaAndTable(stagingSpec.getStagingArea().getSchema(), stagingSpec.getStagingArea().getTable()) + "'; EXCEPTION WHEN OTHERS THEN IF sqlcode != -0942 THEN RAISE; END IF; END;";
        LOGGER.log(Level.INFO, "Dropping view {0}: {1}", new Object[]{stagingSpec.getStagingArea(), dropView});
        this.execute(dropView);
        for (TableSpec table : this.tempTables.get(stagingSpec)) {
            this.doDropForStagingSpec(table);
        }
    }

    private void doDropForStagingSpec(TableSpec table) throws SQLException {
        String dropTable = "BEGIN EXECUTE IMMEDIATE 'DROP TABLE " + TableSpec.withSchemaAndTable(table.getSchema(), table.getTable()) + "'; EXCEPTION WHEN OTHERS THEN IF sqlcode != -0942 THEN RAISE; END IF; END;";
        LOGGER.log(Level.INFO, "Dropping table {0}: {1}", new Object[]{table, dropTable});
        this.execute(dropTable);
    }

    private void createTables() throws SQLException {
        for (StagingSpec stagingSpec : this.stagingSpecs) {
            int i = 0;
            for (EntitySpec es : stagingSpec.getEntitySpecs()) {
                HashSet<Filter> filtersCopy = new HashSet<Filter>(this.filters);
                this.removeNonApplicableFilters(filtersCopy, es);
                String stgTableName = stagingSpec.getStagingArea().getTable() + "_" + i;
                StagingSpec newStagingSpec = StagingSpec.newTableName(stagingSpec, stgTableName);
                this.doDropForStagingSpec(newStagingSpec.getStagingArea());
                Ojdbc6OracleStagingCreateStatement stmt = new Ojdbc6OracleStagingCreateStatement(newStagingSpec, es, this.referenceSpec, Arrays.asList((Object[][])new EntitySpec[][]{stagingSpec.getEntitySpecs()}), this.filters, this.propIds, this.keyIds, this.order, null, this.streamingMode);
                String sql = stmt.generateStatement();
                LOGGER.log(Level.INFO, "Creating staging area for entity spec {0}: {1}", new Object[]{es.getName(), sql});
                this.execute(sql);
                Collections.putList(this.tempTables, (Object)stagingSpec, (Object)newStagingSpec.getStagingArea());
                this.indexIds.put(newStagingSpec.getStagingArea(), 0);
                ++i;
            }
        }
    }

    private void analyzeTables() throws SQLException {
        for (StagingSpec stagingSpec : this.stagingSpecs) {
            for (TableSpec tableSpec : this.tempTables.get(stagingSpec)) {
                String sql = "begin DBMS_STATS.gather_table_stats('" + tableSpec.getSchema() + "', '" + tableSpec.getTable() + "'); end;";
                LOGGER.log(Level.INFO, "Analyzing staging table {0}: {1}", new Object[]{tableSpec, sql});
                this.execute(sql);
            }
        }
    }

    private void indexTables() throws SQLException {
        for (StagingSpec spec : this.stagingSpecs) {
            this.indexPrimaryKeys(spec);
            this.indexOtherColumns(spec);
        }
    }

    private String generateUniqueIndex(TableSpec table) {
        this.indexIds.put(table, this.indexIds.get(table) + 1);
        return table.getTable().toUpperCase() + "_IDX" + this.indexIds.get(table);
    }

    private void indexPrimaryKeys(StagingSpec stagingSpec) throws SQLException {
        for (TableSpec tableSpec : this.tempTables.get(stagingSpec)) {
            StringBuilder sql = new StringBuilder("CREATE UNIQUE INDEX ");
            sql.append(tableSpec.getSchema());
            sql.append(".");
            sql.append(this.generateUniqueIndex(tableSpec));
            sql.append(" ON ");
            sql.append(tableSpec.getSchema());
            sql.append(".");
            sql.append(tableSpec.getTable());
            sql.append(" (");
            sql.append(stagingSpec.getUniqueColumn());
            sql.append(")");
            if (stagingSpec.getIndexTablespace() != null) {
                sql.append(" TABLESPACE ");
                sql.append(stagingSpec.getIndexTablespace());
            }
            sql.append(" NOLOGGING ");
            LOGGER.log(Level.INFO, "Indexing primary key {0} for staging table {1}: {2}", new Object[]{stagingSpec.getUniqueColumn(), tableSpec, sql});
            this.execute(sql.toString());
        }
    }

    private void indexOtherColumns(StagingSpec stagingSpec) throws SQLException {
        for (TableSpec table : this.tempTables.get(stagingSpec)) {
            HashSet<String> indexed = new HashSet<String>();
            for (StagedColumnSpec column : stagingSpec.getStagedColumns()) {
                String realColumn = Ojdbc6OracleDataStager.getRealColumn(column);
                if (realColumn.equals(stagingSpec.getUniqueColumn()) || indexed.contains(realColumn)) continue;
                StringBuilder sql = new StringBuilder("CREATE BITMAP INDEX ");
                sql.append(stagingSpec.getStagingArea().getSchema());
                sql.append(".");
                sql.append(this.generateUniqueIndex(table));
                sql.append(" ON ");
                sql.append(table.getSchema());
                sql.append(".");
                sql.append(table.getTable());
                sql.append(" (");
                sql.append(realColumn);
                sql.append(")");
                if (stagingSpec.getIndexTablespace() != null) {
                    sql.append(" TABLESPACE ");
                    sql.append(stagingSpec.getIndexTablespace());
                }
                sql.append(" NOLOGGING");
                LOGGER.log(Level.INFO, "Indexing column {0} (as {1}) for staging table {2}: {3}", new Object[]{column.getColumn(), realColumn, table.getTable(), sql});
                this.execute(sql.toString());
                indexed.add(realColumn);
            }
        }
    }

    private static String getRealColumn(StagedColumnSpec spec) {
        if (null != spec.getAsName() && !spec.getAsName().isEmpty()) {
            return spec.getAsName();
        }
        return spec.getColumn();
    }

    private void mergeTables() throws SQLException {
        for (StagingSpec ss : this.stagingSpecs) {
            StringBuilder sql = new StringBuilder("CREATE OR REPLACE VIEW ");
            sql.append(ss.getStagingArea().getSchema());
            sql.append(".");
            sql.append(ss.getStagingArea().getTable());
            sql.append(" AS ");
            List<TableSpec> ssTables = this.tempTables.get(ss);
            for (int i = 0; i < ssTables.size(); ++i) {
                sql.append("SELECT * FROM ");
                sql.append(ssTables.get(i).getSchema());
                sql.append(".");
                sql.append(ssTables.get(i).getTable());
                if (i >= ssTables.size() - 1) continue;
                sql.append(" UNION ");
            }
            LOGGER.log(Level.INFO, "Merging staging tables for staging area {0}: {1}", new Object[]{ss.getStagingArea(), sql});
            this.execute(sql.toString());
        }
    }

    private void removeNonApplicableFilters(Set<Filter> filtersCopy, EntitySpec entitySpec) {
        HashSet<EntitySpec> entitySpecsSet = new HashSet<EntitySpec>();
        HashSet<String> filterPropIds = new HashSet<String>();
        Object[] entitySpecPropIds = entitySpec.getPropositionIds();
        Iterator<Filter> itr = filtersCopy.iterator();
        while (itr.hasNext()) {
            Filter f = itr.next();
            for (String filterPropId : f.getPropositionIds()) {
                filterPropIds.add(filterPropId);
            }
            for (EntitySpec es : this.entitySpecs) {
                if (!Collections.containsAny(filterPropIds, (Object[])es.getPropositionIds())) continue;
                entitySpecsSet.add(es);
            }
            if (!Collections.containsAny(filterPropIds, (Object[])entitySpecPropIds)) {
                itr.remove();
            }
            entitySpecsSet.clear();
            filterPropIds.clear();
        }
    }
}

