/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.graph;

import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.arp.javautil.graph.Weight;

public class WeightFactory {
    public static final Weight POS_INFINITY = new Weight(true);
    public static final Weight NEG_INFINITY = new Weight(false);
    public static final Weight POS_EPSILON = new Weight(1L);
    public static final Weight NEG_EPSILON = new Weight(-1L);
    public static final Weight ZERO = new Weight(0L);
    private static final Map<Number, Weight> cache = new ReferenceMap();

    public Weight getInstance() {
        return this.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight getInstance(Number val) {
        Weight weight;
        Map<Number, Weight> map = cache;
        synchronized (map) {
            weight = cache.get(val);
            if (weight == null) {
                weight = new Weight(val);
                cache.put(val, weight);
            }
        }
        return weight;
    }
}

