/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.serviceloader;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class SingletonServiceLoader {
    public static <S> S load(Class<S> service) {
        ServiceLoader<S> load = ServiceLoader.load(service);
        return SingletonServiceLoader.doLoad(load, service);
    }

    public static <S> S load(Class<S> service, ClassLoader loader) {
        ServiceLoader<S> load = ServiceLoader.load(service, loader);
        return SingletonServiceLoader.doLoad(load, service);
    }

    private static <S> S doLoad(ServiceLoader<S> load, Class<S> service) throws ServiceConfigurationError {
        Iterator<S> itr = load.iterator();
        S result = null;
        if (!itr.hasNext()) {
            throw new ServiceConfigurationError("No " + service.getName() + " classes were found by service discovery");
        }
        result = itr.next();
        if (itr.hasNext()) {
            throw new ServiceConfigurationError("Multiple " + service.getName() + " classes were found by service discovery");
        }
        return result;
    }
}

