/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.arp.javautil.arrays.Arrays;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.filter.PropertyValueFilter;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.ColumnSpecInfo;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.InClause;
import org.protempa.backend.dsb.relationaldb.Operator;
import org.protempa.backend.dsb.relationaldb.OrderByClause;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;
import org.protempa.backend.dsb.relationaldb.SQLOrderBy;
import org.protempa.backend.dsb.relationaldb.SelectClause;
import org.protempa.backend.dsb.relationaldb.StagingSpec;
import org.protempa.backend.dsb.relationaldb.TableAliaser;
import org.protempa.backend.dsb.relationaldb.TimeSpecProcessor;
import org.protempa.backend.dsb.relationaldb.WhereClause;
import org.protempa.backend.dsb.relationaldb.WhereConstraintProcessor;
import org.protempa.backend.dsb.relationaldb.mappings.Mappings;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.OrdinalValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;
import org.protempa.proposition.value.ValueVisitor;

public abstract class AbstractWhereClause
implements WhereClause {
    private final Set<String> propIds;
    private final ColumnSpecInfo info;
    private final List<EntitySpec> entitySpecs;
    private final Set<Filter> filters;
    private final TableAliaser referenceIndices;
    private final Set<String> keyIds;
    private final SQLOrderBy order;
    private final SQLGenResultProcessor resultProcessor;
    private final SelectClause selectClause;
    private final StagingSpec[] stagedTables;

    protected AbstractWhereClause(Set<String> propIds, ColumnSpecInfo info, List<EntitySpec> entitySpecs, Set<Filter> filters, TableAliaser referenceIndices, Set<String> keyIds, SQLOrderBy order, SQLGenResultProcessor resultProcessor, SelectClause selectClause, StagingSpec[] stagedTables) {
        this.propIds = propIds;
        this.info = info;
        this.entitySpecs = Collections.unmodifiableList(entitySpecs);
        this.filters = Collections.unmodifiableSet(filters);
        this.referenceIndices = referenceIndices;
        this.keyIds = Collections.unmodifiableSet(keyIds);
        this.order = order;
        this.resultProcessor = resultProcessor;
        this.selectClause = selectClause;
        this.stagedTables = stagedTables;
    }

    protected Set<String> getPropIds() {
        return this.propIds;
    }

    protected ColumnSpecInfo getInfo() {
        return this.info;
    }

    protected List<EntitySpec> getEntitySpecs() {
        return this.entitySpecs;
    }

    protected Set<Filter> getFilters() {
        return this.filters;
    }

    protected TableAliaser getReferenceIndices() {
        return this.referenceIndices;
    }

    protected Set<String> getKeyIds() {
        return this.keyIds;
    }

    protected SQLOrderBy getOrder() {
        return this.order;
    }

    protected SQLGenResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }

    protected SelectClause getSelectClause() {
        return this.selectClause;
    }

    protected StagingSpec[] getStagedTables() {
        return this.stagedTables;
    }

    @Override
    public abstract InClause getInClause(ColumnSpec var1, Object[] var2, boolean var3);

    @Override
    public abstract OrderByClause getOrderByClause(ColumnSpec var1);

    @Override
    public String generateClause() {
        StringBuilder wherePart = new StringBuilder();
        EntitySpec prevEntitySpec = null;
        boolean first = true;
        boolean inGroup = false;
        int n = this.entitySpecs.size();
        for (int j = 0; j < n; ++j) {
            EntitySpec entitySpec = this.entitySpecs.get(j);
            if (n > 1 && j > 0) {
                int wherePartLength;
                if (prevEntitySpec.getName().equals(entitySpec.getName())) {
                    if (!inGroup) {
                        if (!first) {
                            wherePart.append(" AND ");
                            first = true;
                        }
                        wherePart.append(" ((");
                        inGroup = true;
                    } else {
                        wherePart.append(") OR (");
                        first = true;
                    }
                    wherePartLength = wherePart.length();
                    wherePart.append(this.processForWhereClause(prevEntitySpec, first));
                    if (wherePart.length() > wherePartLength) {
                        first = false;
                    }
                } else if (inGroup) {
                    first = true;
                    wherePartLength = wherePart.length();
                    wherePart.append(") OR (");
                    wherePart.append(this.processForWhereClause(prevEntitySpec, first));
                    wherePart.append(")) ");
                    if (wherePart.length() > wherePartLength) {
                        first = false;
                    }
                    inGroup = false;
                } else {
                    wherePartLength = wherePart.length();
                    wherePart.append(this.processForWhereClause(prevEntitySpec, first));
                    if (wherePart.length() > wherePartLength) {
                        first = false;
                    }
                }
            }
            prevEntitySpec = entitySpec;
        }
        if (inGroup) {
            first = true;
            wherePart.append(") OR (");
            wherePart.append(this.processForWhereClause(prevEntitySpec, first));
            wherePart.append(")) ");
        } else {
            wherePart.append(this.processForWhereClause(prevEntitySpec, first));
        }
        this.processKeyIdConstraintsForWhereClause(this.info, wherePart, this.keyIds);
        if (wherePart.length() > 0) {
            wherePart.insert(0, "WHERE ");
        }
        wherePart.append(this.processOrder(this.info));
        return wherePart.toString();
    }

    private void processKeyIdConstraintsForWhereClause(ColumnSpecInfo info, StringBuilder wherePart, Set<String> keyIds) {
        if (keyIds != null && !keyIds.isEmpty()) {
            if (wherePart.length() > 0) {
                wherePart.append(" AND ");
            }
            ColumnSpec keySpec = info.getColumnSpecs().get(0).getColumnSpec();
            wherePart.append(this.getInClause(keySpec, keyIds.toArray(), false).generateClause());
        }
    }

    private String processForWhereClause(EntitySpec entitySpec, boolean first) {
        StringBuilder wherePart = new StringBuilder();
        int wherePartLength = wherePart.length();
        wherePart.append(TimeSpecProcessor.processStartTimeSpec(entitySpec, this.filters, first, this.referenceIndices));
        if (wherePart.length() > wherePartLength) {
            first = false;
        }
        wherePartLength = wherePart.length();
        wherePart.append(TimeSpecProcessor.processFinishTimeSpec(entitySpec, this.filters, first, this.referenceIndices));
        if (wherePart.length() > wherePartLength) {
            first = false;
        }
        wherePartLength = wherePart.length();
        if (wherePart.length() > wherePartLength) {
            first = false;
        }
        wherePartLength = wherePart.length();
        wherePart.append(this.processConstraintSpecsForWhereClause(entitySpec, first));
        return wherePart.toString();
    }

    private StringBuilder processConstraintSpecs(EntitySpec entitySpec, boolean first) {
        StringBuilder wherePart = new StringBuilder();
        block0: for (ColumnSpec constraintSpec : entitySpec.getConstraintSpecs()) {
            for (StagingSpec stagingSpec : this.getStagedTables()) {
                if (constraintSpec.getLastSpec().isSameSchemaAndTable(stagingSpec.getReplacedTable())) continue block0;
            }
            int wherePartLength = wherePart.length();
            wherePart.append(this.processConstraintSpecForWhereClause(constraintSpec, null, first));
            if (wherePart.length() <= wherePartLength) continue;
            first = false;
        }
        return wherePart;
    }

    private StringBuilder processPropertySpecs(PropertySpec[] propertySpecs, boolean first) {
        StringBuilder wherePart = new StringBuilder();
        for (PropertySpec ps : propertySpecs) {
            ColumnSpec constraintSpec = ps.getConstraintSpec();
            if (constraintSpec == null) continue;
            int wherePartLength = wherePart.length();
            wherePart.append(this.processConstraint(constraintSpec, null, null, first));
            if (wherePart.length() <= wherePartLength) continue;
            first = false;
        }
        block1: for (Filter filter : this.filters) {
            for (PropertySpec ps : propertySpecs) {
                PropertyValueFilter pvf;
                if (!(filter instanceof PropertyValueFilter) || !(pvf = (PropertyValueFilter)filter).getProperty().equals(ps.getName())) continue;
                ColumnSpec colSpec = ps.getCodeSpec();
                int wherePartLength = wherePart.length();
                wherePart.append(this.processPropertyValueFilter(colSpec, pvf.getValueComparator(), pvf.getValues(), first));
                if (wherePart.length() <= wherePartLength) continue block1;
                first = false;
                continue block1;
            }
        }
        return wherePart;
    }

    private StringBuilder processCodeSpec(EntitySpec entitySpec, boolean first) {
        StringBuilder wherePart = new StringBuilder();
        ColumnSpec codeSpec = entitySpec.getCodeSpec();
        if (codeSpec != null) {
            List<ColumnSpec> codeSpecL = codeSpec.asList();
            if (codeSpecL.get(codeSpecL.size() - 1).isPropositionIdsComplete() && !this.needsPropIdInClause(entitySpec.getPropositionIds())) {
                this.setCaseClauseIfNeeded(codeSpec, this.propIds);
            } else {
                int wherePartLength = wherePart.length();
                wherePart.append(this.processConstraintSpecForWhereClause(codeSpec, this.propIds, first));
                if (wherePart.length() > wherePartLength) {
                    first = false;
                }
            }
        }
        return wherePart;
    }

    private String processConstraintSpecsForWhereClause(EntitySpec entitySpec, boolean first) {
        StringBuilder wherePart = new StringBuilder();
        int wherePartLength = wherePart.length();
        wherePart.append((CharSequence)this.processConstraintSpecs(entitySpec, first));
        if (first && wherePart.length() > wherePartLength) {
            first = false;
            wherePartLength = wherePart.length();
        }
        wherePart.append((CharSequence)this.processPropertySpecs(entitySpec.getPropertySpecs(), first));
        if (first && wherePart.length() > wherePartLength) {
            first = false;
            wherePartLength = wherePart.length();
        }
        wherePart.append((CharSequence)this.processCodeSpec(entitySpec, first));
        return wherePart.toString();
    }

    private void setCaseClauseIfNeeded(ColumnSpec columnSpec, Set<?> propIds) {
        if (AbstractWhereClause.hasConstraint(columnSpec) && this.resultProcessor != null) {
            this.resultProcessor.setCasePresent(columnSpec.getConstraint() == Operator.LIKE);
            Mappings filteredMappings = AbstractWhereClause.filterMappingsByTarget(this.propIds, columnSpec.getMappings());
            this.selectClause.setCaseClause(AbstractWhereClause.filteredSqlCodes(propIds, filteredMappings), columnSpec, filteredMappings);
        }
    }

    private String processConstraintSpecForWhereClause(ColumnSpec columnSpec, Set<?> propIds, boolean first) {
        StringBuilder wherePart = new StringBuilder();
        if (AbstractWhereClause.hasConstraint(columnSpec)) {
            this.setCaseClauseIfNeeded(columnSpec, null);
            wherePart.append(this.processConstraint(columnSpec, propIds, null, first));
        }
        return wherePart.toString();
    }

    private String processPropertyValueFilter(ColumnSpec columnSpec, ValueComparator comparator, Value[] values, boolean first) {
        StringBuilder wherePart = new StringBuilder();
        Operator constraint = AbstractWhereClause.valueComparatorToSqlOp(comparator);
        if (columnSpec != null && constraint != null) {
            ValueExtractor ve = new ValueExtractor();
            for (Value value : values) {
                value.accept((ValueVisitor)ve);
            }
            wherePart.append(this.processConstraint(columnSpec, ve.values, constraint, first));
        }
        return wherePart.toString();
    }

    private String processConstraint(ColumnSpec columnSpec, Set<?> propIds, Operator constraintOverride, boolean first) {
        StringBuilder wherePart = new StringBuilder();
        ColumnSpec cs = columnSpec.getLastSpec();
        Operator constraint = cs.getConstraint();
        if (constraintOverride != null) {
            constraint = constraintOverride;
        }
        Mappings propIdToSqlCodes = cs.getMappings();
        if (constraint != null && this.referenceIndices.getIndex(cs) > -1) {
            Mappings filteredConstraintValues = AbstractWhereClause.filterMappingsByTarget(propIds, propIdToSqlCodes);
            if (!first) {
                wherePart.append(" AND ");
            }
            wherePart.append('(');
            Object[] sqlCodes = AbstractWhereClause.filteredSqlCodes(propIds, filteredConstraintValues);
            wherePart.append(WhereConstraintProcessor.getInstance(cs, constraint, this, sqlCodes, this.referenceIndices).processConstraint()).append(')');
        }
        return wherePart.toString();
    }

    private boolean needsPropIdInClause(String[] entitySpecPropIds) {
        Set entitySpecPropIdsSet = Arrays.asSet((Object[])entitySpecPropIds);
        ArrayList<String> filteredPropIds = new ArrayList<String>(entitySpecPropIds.length);
        for (String propId : this.propIds) {
            if (!entitySpecPropIdsSet.contains(propId)) continue;
            filteredPropIds.add(propId);
        }
        return (float)filteredPropIds.size() < (float)entitySpecPropIds.length * 0.85f && filteredPropIds.size() <= 2000;
    }

    private String processOrder(ColumnSpecInfo info) {
        StringBuilder wherePart = new StringBuilder();
        if (this.order != null && info.isUsingKeyIdIndex()) {
            ColumnSpec keyIdSpec = info.getColumnSpecs().get(0).getColumnSpec();
            wherePart.append(this.getOrderByClause(keyIdSpec).generateClause());
        }
        return wherePart.toString();
    }

    private static Operator valueComparatorToSqlOp(ValueComparator valueComparator) throws IllegalStateException {
        Operator constraint = null;
        switch (valueComparator) {
            case GREATER_THAN: {
                constraint = Operator.GREATER_THAN;
                break;
            }
            case LESS_THAN: {
                constraint = Operator.LESS_THAN;
                break;
            }
            case EQUAL_TO: {
                constraint = Operator.EQUAL_TO;
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                constraint = Operator.GREATER_THAN_OR_EQUAL_TO;
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                constraint = Operator.LESS_THAN_OR_EQUAL_TO;
                break;
            }
            case IN: {
                constraint = Operator.EQUAL_TO;
                break;
            }
            case NOT_IN: {
                constraint = Operator.NOT_EQUAL_TO;
                break;
            }
            default: {
                throw new AssertionError((Object)("invalid valueComparator: " + valueComparator));
            }
        }
        return constraint;
    }

    private static Mappings filterMappingsByTarget(Set<?> propIds, Mappings mappings) {
        Mappings filteredMappings = propIds != null && mappings != null ? mappings.subMappingsByTargets(propIds.toArray(new String[propIds.size()])) : mappings;
        return filteredMappings;
    }

    private static Object[] filteredSqlCodes(Set<?> codes, Mappings mappings) {
        Object[] sqlCodes = null;
        if (mappings != null && !mappings.isEmpty()) {
            sqlCodes = mappings.readSources();
        } else if (codes != null) {
            sqlCodes = codes.toArray();
        }
        return sqlCodes;
    }

    private static boolean hasConstraint(ColumnSpec columnSpec) {
        if (columnSpec != null) {
            List<ColumnSpec> columnSpecL = columnSpec.asList();
            ColumnSpec cs = columnSpecL.get(columnSpecL.size() - 1);
            return cs.getConstraint() != null;
        }
        return false;
    }

    private static class ValueExtractor
    implements ValueVisitor {
        Set<Object> values = new HashSet<Object>();

        private ValueExtractor() {
        }

        public void visit(NominalValue nominalValue) {
            this.values.add(nominalValue.getString());
        }

        public void visit(OrdinalValue ordinalValue) {
            this.values.add(ordinalValue.getValue());
        }

        public void visit(BooleanValue booleanValue) {
            this.values.add(booleanValue.getBoolean());
        }

        public void visit(ValueList<? extends Value> listValue) {
            for (Value val : listValue) {
                val.accept((ValueVisitor)this);
            }
        }

        public void visit(NumberValue numberValue) {
            this.values.add(numberValue.getNumber());
        }

        public void visit(InequalityNumberValue inequalityNumberValue) {
            throw new UnsupportedOperationException("inequalityNumberValue not supported");
        }

        public void visit(DateValue dateValue) {
            this.values.add(dateValue.getDate());
        }
    }
}

