/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.OutputConfig;
import org.protempa.dest.table.PropositionColumnSpec;
import org.protempa.dest.table.ValueOutputConfig;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.PropertyNamesConverter;

class PropositionColumnSpecConverter
extends AbstractConverter {
    private static final String OUTPUT_CONFIG = "outputConfig";
    private static final String VALUE_OUTPUT_CONFIG = "valueOutputConfig";
    private static final String PROPERTY_NAMES = "propertyNames";
    private static final String COLUMN_NAME_PREFIX_OVERRIDE = "columnNamePrefixOverride";
    private static final String LINKS = "links";
    private static final String NUM_INSTANCES = "numInstances";

    PropositionColumnSpecConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return PropositionColumnSpec.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        ValueOutputConfig valueOutputConfig;
        PropositionColumnSpec columnSpec = (PropositionColumnSpec)source;
        String columnNameOverride = columnSpec.getColumnNamePrefixOverride();
        if (columnNameOverride != null) {
            writer.addAttribute(COLUMN_NAME_PREFIX_OVERRIDE, columnNameOverride);
        }
        writer.addAttribute(NUM_INSTANCES, Integer.toString(columnSpec.getNumInstances()));
        writer.startNode(PROPERTY_NAMES);
        context.convertAnother((Object)columnSpec.getPropertyNames(), (Converter)new PropertyNamesConverter(this.getKnowledgeSource()));
        writer.endNode();
        OutputConfig outputConfig = columnSpec.getOutputConfig();
        if (outputConfig != null) {
            writer.startNode(OUTPUT_CONFIG);
            context.convertAnother((Object)outputConfig);
            writer.endNode();
        }
        if ((valueOutputConfig = columnSpec.getValueOutputConfig()) != null) {
            writer.startNode(VALUE_OUTPUT_CONFIG);
            context.convertAnother((Object)valueOutputConfig);
            writer.endNode();
        }
        writer.startNode(LINKS);
        context.convertAnother((Object)columnSpec.getLinks());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ValueOutputConfig valueOutputConfig;
        OutputConfig outputConfig;
        String columnNameOverride = reader.getAttribute(COLUMN_NAME_PREFIX_OVERRIDE);
        int numInstances = this.intAttributeValue(reader, NUM_INSTANCES);
        reader.moveDown();
        this.expect(reader, PROPERTY_NAMES);
        PropertyNamesConverter converter = new PropertyNamesConverter(this.getKnowledgeSource());
        String[] propertyNames = (String[])context.convertAnother(null, String[].class, (Converter)converter);
        reader.moveUp();
        reader.moveDown();
        if (OUTPUT_CONFIG.equals(reader.getNodeName())) {
            outputConfig = (OutputConfig)context.convertAnother(null, OutputConfig.class);
            reader.moveUp();
            reader.moveDown();
        } else {
            outputConfig = null;
        }
        if (VALUE_OUTPUT_CONFIG.equals(reader.getNodeName())) {
            valueOutputConfig = (ValueOutputConfig)context.convertAnother(null, ValueOutputConfig.class);
            reader.moveUp();
            reader.moveDown();
        } else {
            valueOutputConfig = null;
        }
        this.expect(reader, LINKS);
        Link[] links = (Link[])context.convertAnother(null, Link[].class);
        reader.moveUp();
        this.expectNoMore(reader);
        return new PropositionColumnSpec(columnNameOverride, propertyNames, outputConfig, valueOutputConfig, links, numInstances);
    }
}

