/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.arp.javautil.string.StringUtil;
import org.protempa.backend.dsb.relationaldb.ColumnOp;
import org.protempa.backend.dsb.relationaldb.IColumnSpec;
import org.protempa.backend.dsb.relationaldb.JoinSpec;
import org.protempa.backend.dsb.relationaldb.Operator;
import org.protempa.backend.dsb.relationaldb.TableSpec;
import org.protempa.backend.dsb.relationaldb.mappings.Mappings;

public class ColumnSpec
implements Serializable,
IColumnSpec {
    private static final long serialVersionUID = 2254623617064935923L;
    private final String schema;
    private final String table;
    private final String column;
    private final JoinSpec joinSpec;
    private final Operator constraint;
    private final Mappings mappings;
    private final ColumnOp columnOp;
    private final boolean propositionIdsComplete;
    private final String expr;

    public ColumnSpec(String expr) {
        this.expr = expr;
        this.schema = null;
        this.table = null;
        this.column = null;
        this.joinSpec = null;
        this.constraint = null;
        this.mappings = null;
        this.columnOp = null;
        this.propositionIdsComplete = false;
    }

    public ColumnSpec(String schema, String table, JoinSpec joinSpec) {
        this(schema, table, null, joinSpec);
    }

    public ColumnSpec(String schema, String table) {
        this(schema, table, null, null);
    }

    public ColumnSpec(String schema, String table, String column, Operator constraint, Mappings mappings, ColumnOp columnOp, boolean propositionIdsComplete) {
        this(schema, table, column, null, constraint, mappings, columnOp, propositionIdsComplete);
    }

    public ColumnSpec(String schema, String table, String column, Operator constraint, Mappings mappings, boolean propositionIdsComplete) {
        this(schema, table, column, null, constraint, mappings, null, propositionIdsComplete);
    }

    public ColumnSpec(String schema, String table, String column, Operator constraint, Mappings mappings) {
        this(schema, table, column, null, constraint, mappings, null, false);
    }

    public ColumnSpec(String schema, String table, String column) {
        this(schema, table, column, null);
    }

    public ColumnSpec(String schema, String table, String column, JoinSpec joinSpec) {
        this(schema, table, column, joinSpec, null, null, null, false);
    }

    private ColumnSpec(String schema, String table, String column, JoinSpec joinSpec, Operator constraint, Mappings mappings, ColumnOp columnOp, boolean propositionIdsComplete) {
        if (table == null) {
            throw new IllegalArgumentException("table cannot be null");
        }
        this.schema = schema != null ? schema.intern() : null;
        this.table = table.intern();
        this.column = column;
        this.joinSpec = joinSpec;
        this.constraint = constraint;
        if (this.constraint != null && this.column == null) {
            throw new IllegalArgumentException("A column must be specified if a constraint is specified.");
        }
        if (this.constraint != null && mappings == null) {
            throw new IllegalArgumentException("mappings must be specified if a constraint is specified.");
        }
        this.mappings = mappings;
        if (this.joinSpec != null) {
            this.joinSpec.setPrevColumnSpec(this);
        }
        this.columnOp = columnOp;
        this.propositionIdsComplete = propositionIdsComplete;
        this.expr = null;
    }

    public String getExpr() {
        return this.expr;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public JoinSpec getJoin() {
        return this.joinSpec;
    }

    @Override
    public Operator getConstraint() {
        return this.constraint;
    }

    String getTarget(Object source) {
        if (this.mappings != null) {
            return this.mappings.getTarget(source);
        }
        return null;
    }

    @Override
    public Mappings getMappings() {
        return this.mappings;
    }

    @Override
    public ColumnOp getColumnOp() {
        return this.columnOp;
    }

    @Override
    public boolean isPropositionIdsComplete() {
        return this.propositionIdsComplete;
    }

    boolean isSameSchemaAndTable(ColumnSpec columnSpec) {
        return StringUtil.equals((String)columnSpec.schema, (String)this.schema) && StringUtil.equals((String)columnSpec.table, (String)this.table);
    }

    public boolean isSameSchemaAndTable(TableSpec tableSpec) {
        return StringUtil.equals((String)tableSpec.getSchema(), (String)this.schema) && StringUtil.equals((String)tableSpec.getTable(), (String)this.table);
    }

    public ColumnSpec getLastSpec() {
        if (this.joinSpec == null) {
            return this;
        }
        List<ColumnSpec> l = this.asList();
        return l.get(l.size() - 1);
    }

    List<ColumnSpec> asList() {
        ArrayList<ColumnSpec> columnSpecs = new ArrayList<ColumnSpec>();
        ColumnSpec spec = this;
        columnSpecs.add(spec);
        while (spec.getJoin() != null) {
            spec = spec.getJoin().getNextColumnSpec();
            columnSpecs.add(spec);
        }
        return columnSpecs;
    }

    public String toString() {
        String result = "";
        for (ColumnSpec spec : this.asList()) {
            result = result + spec.getSchema() + "." + spec.getTable() + "." + spec.getColumn() + " -> ";
        }
        return result;
    }
}

