/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.ParameterSetter;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructorUnionedMetadataQueryBuilder;
import edu.emory.cci.aiw.i2b2etl.ksb.ResultSetReader;
import edu.emory.cci.aiw.i2b2etl.ksb.TableAccessReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.protempa.KnowledgeSourceReadException;

public class QueryExecutor
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(QueryExecutor.class.getName());
    private static final ParameterSetter EMPTY_PARAM_SETTER = new ParameterSetter(){

        @Override
        public int set(PreparedStatement stmt, int j) throws SQLException {
            return j;
        }
    };
    private final Connection connection;
    private String sql;
    private PreparedStatement preparedStatement;
    private String[] ontTables;
    private final QueryConstructor queryConstructor;
    private TableAccessReader ontTableReader;
    private String[] tables;

    public QueryExecutor(Connection connection, QueryConstructor queryConstructor, TableAccessReader ontTableReader) {
        this.connection = connection;
        this.queryConstructor = queryConstructor;
        this.ontTableReader = ontTableReader;
    }

    public QueryExecutor(Connection connection, QueryConstructor queryConstructor, String ... tables) {
        this.connection = connection;
        this.queryConstructor = queryConstructor;
        this.tables = tables;
    }

    public <E> E execute(ResultSetReader<E> resultSetReader) throws KnowledgeSourceReadException {
        return this.execute(EMPTY_PARAM_SETTER, resultSetReader);
    }

    public <E> E execute(String bindArgument, ResultSetReader<E> resultSetReader) throws KnowledgeSourceReadException {
        return this.execute((PreparedStatement stmt, int j) -> {
            stmt.setString(j++, bindArgument);
            return j;
        }, resultSetReader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E> E execute(ParameterSetter paramSetter, ResultSetReader<E> resultSetReader) throws KnowledgeSourceReadException {
        try {
            this.prepare();
            if (this.preparedStatement == null) {
                return resultSetReader.read(null);
            }
            int j = 1;
            int n = this.ontTables.length;
            for (int i = 0; i < n; ++i) {
                j = paramSetter.set(this.preparedStatement, j);
            }
            long start = System.currentTimeMillis();
            try (ResultSet rs = this.preparedStatement.executeQuery();){
                E result = resultSetReader.read(rs);
                double queryTime = (double)(System.currentTimeMillis() - start) / 1000.0;
                if (LOGGER.isLoggable(Level.FINE) && queryTime >= 1.0) {
                    LOGGER.log(Level.FINE, "Long running query ({0} seconds): {1}", new Object[]{queryTime, this.sql});
                }
                E e = result;
                return e;
            }
        }
        catch (SQLException ex) {
            throw new KnowledgeSourceReadException((Throwable)ex);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void close() throws KnowledgeSourceReadException {
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
            }
            catch (SQLException ex) {
                throw new KnowledgeSourceReadException((Throwable)ex);
            }
            this.preparedStatement = null;
        }
    }

    public void prepare() throws KnowledgeSourceReadException {
        if (this.preparedStatement == null) {
            try {
                this.readOntologyTables();
                if (this.ontTables.length > 0) {
                    QueryConstructorUnionedMetadataQueryBuilder builder = new QueryConstructorUnionedMetadataQueryBuilder();
                    this.sql = builder.queryConstructor(this.queryConstructor).ontTables(this.ontTables).build();
                    LOGGER.log(Level.FINE, "Preparing query {0}", this.sql);
                    this.preparedStatement = this.connection.prepareStatement(this.sql);
                    this.preparedStatement.setFetchSize(1000);
                }
            }
            catch (SQLException ex) {
                throw new KnowledgeSourceReadException((Throwable)ex);
            }
        }
    }

    private void readOntologyTables() throws KnowledgeSourceReadException {
        this.ontTables = this.ontTableReader != null ? this.ontTableReader.read(this.connection) : (this.tables != null ? this.tables : ArrayUtils.EMPTY_STRING_ARRAY);
    }
}

