/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.UnknownPropositionDefinitionException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ModifierConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropDefConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropertyConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.table.FactHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.InvalidFactException;
import edu.emory.cci.aiw.i2b2etl.dest.table.ObservationFact;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.RejectedFactHandlerFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import edu.emory.cci.aiw.i2b2etl.dest.table.VisitDimension;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.arp.javautil.sql.ConnectionSpec;
import org.drools.util.StringUtils;
import org.protempa.KnowledgeSourceCache;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.dest.table.Derivation;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.LinkTraverser;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.comparator.AllPropositionIntervalComparator;
import org.protempa.proposition.value.Value;

public final class PropositionFactHandler
extends FactHandler {
    private static final Comparator<Proposition> PROP_COMP = new AllPropositionIntervalComparator();
    private final LinkTraverser linkTraverser;
    private final Link[] links;
    private final Link[] derivationLinks;
    private KnowledgeSourceCache cache;
    private final Set<ConceptId> missingConcepts;

    public PropositionFactHandler(ConnectionSpec connSpec, Link[] links, String propertyName, String start, String finish, String unitsPropertyName, String[] potentialDerivedPropIds, Metadata metadata, KnowledgeSourceCache cache, RejectedFactHandlerFactory rejectedFactHandlerFactory) throws SQLException {
        super(connSpec, propertyName, start, finish, unitsPropertyName, metadata, rejectedFactHandlerFactory);
        if (cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
        this.linkTraverser = new LinkTraverser();
        this.links = links;
        if (potentialDerivedPropIds == null) {
            potentialDerivedPropIds = StringUtils.EMPTY_STRING_ARRAY;
        }
        this.derivationLinks = new Link[]{new Derivation(potentialDerivedPropIds, Derivation.Behavior.MULT_FORWARD)};
        this.cache = cache;
        this.missingConcepts = new HashSet<ConceptId>();
    }

    @Override
    public void handleRecord(PatientDimension patient, VisitDimension visit, ProviderDimension provider, Proposition encounterProp, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, Set<Proposition> derivedPropositions) throws InvalidFactException {
        assert (patient != null) : "patient cannot be null";
        assert (visit != null) : "visit cannot be null";
        assert (provider != null) : "provider cannot be null";
        try {
            List props = this.linkTraverser.traverseLinks(this.links, encounterProp, forwardDerivations, backwardDerivations, references, this.cache);
            HashSet<Proposition> derivedPropCache = new HashSet<Proposition>();
            for (Proposition prop : props) {
                String propertyName = this.getPropertyName();
                Value propertyVal = propertyName != null ? prop.getProperty(propertyName) : null;
                PropDefConceptId conceptId = PropDefConceptId.getInstance(prop.getId(), propertyName, propertyVal, this.getMetadata());
                this.doInsert(conceptId, prop, encounterProp, patient, visit, provider);
                List derivedProps = this.linkTraverser.traverseLinks(this.derivationLinks, prop, forwardDerivations, backwardDerivations, references, this.cache);
                for (Proposition derivedProp : derivedProps) {
                    if (!derivedPropCache.add(derivedProp)) continue;
                    PropDefConceptId derivedConceptId = PropDefConceptId.getInstance(derivedProp.getId(), null, null, this.getMetadata());
                    this.doInsert(derivedConceptId, derivedProp, encounterProp, patient, visit, provider);
                }
            }
        }
        catch (UnknownPropositionDefinitionException ex) {
            throw new InvalidFactException(ex);
        }
    }

    private void doInsert(PropertyConceptId conceptId, Proposition prop, Proposition encounterProp, PatientDimension patient, VisitDimension visit, ProviderDimension provider) throws InvalidFactException, UnknownPropositionDefinitionException {
        assert (conceptId != null) : "conceptId cannot be null";
        assert (prop != null) : "prop cannot be null";
        assert (encounterProp != null) : "encounterProp cannot be null";
        assert (patient != null) : "patient cannot be null";
        assert (visit != null) : "visit cannot be null";
        assert (provider != null) : "provider cannot be null";
        if (this.getMetadata().getFromIdCache(conceptId) == null) {
            if (this.missingConcepts.add(conceptId)) {
                TableUtil.logger().log(Level.WARNING, "No metadata for concept {0}; this data will not be loaded", conceptId);
            }
        } else {
            ObservationFact obx = this.populateObxFact(prop, encounterProp, patient, visit, provider, conceptId, null);
            PropositionDefinition propDef = this.cache.get(prop.getId());
            if (propDef == null) {
                throw new UnknownPropositionDefinitionException(prop);
            }
            try {
                this.insert(obx);
            }
            catch (SQLException ex) {
                String msg = "Observation fact not created";
                throw new InvalidFactException(msg, ex);
            }
            for (String propertyName : prop.getPropertyNames()) {
                boolean found;
                PropertyDefinition propertyDefinition = propDef.propertyDefinition(propertyName);
                if (propertyDefinition == null) continue;
                ModifierConceptId modConceptId = ModifierConceptId.getInstance(propertyDefinition.getDeclaringPropId(), propertyName, prop.getProperty(propertyName), this.getMetadata());
                boolean bl = found = this.getMetadata().getFromIdCache(modConceptId) != null;
                if (!found) {
                    modConceptId = ModifierConceptId.getInstance(propertyDefinition.getDeclaringPropId(), propertyName, null, this.getMetadata());
                    boolean bl2 = found = this.getMetadata().getFromIdCache(modConceptId) != null;
                }
                if (!found) {
                    if (!this.missingConcepts.add(modConceptId)) continue;
                    TableUtil.logger().log(Level.WARNING, "No metadata for modifier {0}; this modifier data will not be loaded. If you already are loading it as a concept, you may ignore this warning.", modConceptId);
                    continue;
                }
                ObservationFact modObx = this.populateObxFact(prop, encounterProp, patient, visit, provider, conceptId, modConceptId);
                try {
                    this.insert(modObx);
                }
                catch (SQLException ex) {
                    throw new InvalidFactException("Modifier fact not created", ex);
                }
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.missingConcepts.clear();
        super.close();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private abstract class PropositionWrapper
    implements Comparable<PropositionWrapper> {
        private PropositionWrapper() {
        }

        abstract Concept getConcept();

        abstract Proposition getProposition();

        @Override
        public int compareTo(PropositionWrapper o) {
            return PROP_COMP.compare(this.getProposition(), o.getProposition());
        }
    }
}

