/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest;

import edu.emory.cci.aiw.i2b2etl.dest.I2b2QueryResultsHandler;
import edu.emory.cci.aiw.i2b2etl.dest.I2b2Statistics;
import edu.emory.cci.aiw.i2b2etl.dest.config.Concepts;
import edu.emory.cci.aiw.i2b2etl.dest.config.Configuration;
import edu.emory.cci.aiw.i2b2etl.dest.config.Data;
import edu.emory.cci.aiw.i2b2etl.dest.config.DataSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.FolderSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.Settings;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.arp.javautil.arrays.Arrays;
import org.protempa.DataSource;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.ReferenceDefinition;
import org.protempa.dest.AbstractDestination;
import org.protempa.dest.GetSupportedPropositionIdsException;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.Statistics;
import org.protempa.dest.StatisticsException;
import org.protempa.query.Query;

public final class I2b2Destination
extends AbstractDestination {
    private final Configuration config;
    private final boolean insertSupportedPropositionIds;

    public I2b2Destination(Configuration config) {
        this(config, false);
    }

    public I2b2Destination(Configuration config, boolean inferSupportedPropositionIds) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.config = config;
        this.insertSupportedPropositionIds = inferSupportedPropositionIds;
    }

    public QueryResultsHandler getQueryResultsHandler(Query query, DataSource dataSource, KnowledgeSource knowledgeSource) throws QueryResultsHandlerInitException {
        return new I2b2QueryResultsHandler(query, dataSource, knowledgeSource, this.config);
    }

    public boolean isGetStatisticsSupported() {
        return true;
    }

    public Statistics getStatistics() throws StatisticsException {
        return new I2b2Statistics(this.config);
    }

    public String[] getSupportedPropositionIds(DataSource dataSource, KnowledgeSource knowledgeSource) throws GetSupportedPropositionIdsException {
        try {
            return this.readPropIdsFromKnowledgeSource(dataSource, knowledgeSource);
        }
        catch (KnowledgeSourceReadException ex) {
            throw new GetSupportedPropositionIdsException((Throwable)ex);
        }
    }

    private String[] readPropIdsFromKnowledgeSource(DataSource dataSource, KnowledgeSource knowledgeSource) throws KnowledgeSourceReadException {
        if (this.insertSupportedPropositionIds) {
            HashSet<String> result = new HashSet<String>();
            Settings settings = this.config.getSettings();
            Data data = this.config.getData();
            Concepts concepts = this.config.getConcepts();
            String visitPropId = settings.getVisitDimension();
            if (visitPropId != null) {
                result.add(visitPropId);
                PropositionDefinition visitProp = knowledgeSource.readPropositionDefinition(visitPropId);
                if (visitProp == null) {
                    throw new KnowledgeSourceReadException("Invalid visit proposition id: " + visitPropId);
                }
                for (DataSpec dataSpec : data.getAll()) {
                    if (dataSpec.getReferenceName() == null) continue;
                    ReferenceDefinition refDef = visitProp.referenceDefinition(dataSpec.getReferenceName());
                    if (refDef == null) {
                        throw new KnowledgeSourceReadException("missing reference " + dataSpec.getReferenceName() + " for proposition definition " + visitPropId);
                    }
                    Arrays.addAll(result, (Object[][])new String[][]{refDef.getPropositionIds()});
                }
                for (FolderSpec folderSpec : concepts.getFolderSpecs()) {
                    for (String proposition : folderSpec.getPropositions()) {
                        result.add(proposition);
                    }
                }
            }
            Set collectPropIdDescendantsUsingInverseIsA = knowledgeSource.collectPropIdDescendantsUsingInverseIsA(result.toArray(new String[result.size()]));
            return collectPropIdDescendantsUsingInverseIsA.toArray(new String[collectPropIdDescendantsUsingInverseIsA.size()]);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

