/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata;

import edu.emory.cci.aiw.i2b2etl.dest.config.Data;
import edu.emory.cci.aiw.i2b2etl.dest.config.FolderSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.Settings;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.DataType;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.DemographicsBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.InvalidPromoteArgumentException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.MetadataUtil;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuildException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.PhenotypesBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.PropositionConceptTreeBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.ProviderConceptTreeBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.SubtreeBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.UnknownPropositionDefinitionException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.ValueSetConceptTreeBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropDefConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.SimpleConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimension;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.TableAccessReader;
import edu.emory.cci.aiw.i2b2etl.ksb.UniqueIdTempTableHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.collections.Collections;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.proposition.value.Value;

public final class Metadata {
    private static final PropositionDefinition[] EMPTY_PROPOSITION_DEFINITION_ARRAY = new PropositionDefinition[0];
    private static final Logger LOGGER = Logger.getLogger(Metadata.class.getName());
    private Concept conceptRoot;
    private final Map<ConceptId, Concept> conceptCache = new HashMap<ConceptId, Concept>();
    private final Map<List<Object>, ConceptId> conceptIdCache = new ReferenceMap();
    private final Data dataSection;
    private final Settings settings;
    private final PropositionDefinition[] userDefinedPropositionDefinitions;
    private final String sourceSystemCode;
    private ProviderConceptTreeBuilder providerConceptTreeBuilder;
    private final KnowledgeSourceCache cache;
    private final FolderSpec[] folderSpecs;
    private final List<Concept> modifierRoots;
    private List<Concept> allRoots;
    private ConnectionSpec metaConnectionSpec;
    private Collection<PropositionDefinition> propDefs;
    private static final QueryConstructor ALL_CONCEPTS_QUERY = (sql, table) -> {
        sql.append("SELECT DISTINCT EK_UNIQUE_ID, C_FULLNAME FROM ");
        sql.append(table);
    };
    private static final QueryConstructor ALL_CONCEPTS_QUERY_WITH_TMP = (sql, table) -> {
        sql.append("SELECT DISTINCT EK_UNIQUE_ID, C_FULLNAME FROM ");
        sql.append(table);
        sql.append(" A1 JOIN EK_TEMP_UNIQUE_IDS A2 ON (A1.EK_UNIQUE_ID=A2.UNIQUE_ID) WHERE M_APPLIED_PATH = '@'");
        sql.append(" UNION ALL ");
        sql.append("SELECT DISTINCT EK_UNIQUE_ID, C_FULLNAME FROM ");
        sql.append(table);
        sql.append(" WHERE M_APPLIED_PATH <> '@'");
    };

    Metadata(Collection<PropositionDefinition> propDefs, String sourceSystemCode, KnowledgeSourceCache cache, PropositionDefinition[] userDefinedPropositionDefinitions, FolderSpec[] folderSpecs, Settings settings, Data dataSection, ConnectionSpec metaConnectionSpec) {
        if (propDefs == null) {
            throw new IllegalArgumentException("propDefs cannot be null");
        }
        if (dataSection == null) {
            throw new IllegalArgumentException("dataSource cannot be null");
        }
        if (folderSpecs == null) {
            throw new IllegalArgumentException("folderSpecs cannot be null");
        }
        if (sourceSystemCode == null) {
            throw new IllegalArgumentException("sourceSystemCode cannot be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
        this.metaConnectionSpec = metaConnectionSpec;
        this.modifierRoots = new ArrayList<Concept>();
        this.sourceSystemCode = MetadataUtil.toSourceSystemCode(sourceSystemCode);
        this.userDefinedPropositionDefinitions = userDefinedPropositionDefinitions == null ? EMPTY_PROPOSITION_DEFINITION_ARRAY : (PropositionDefinition[])userDefinedPropositionDefinitions.clone();
        this.cache = cache;
        this.settings = settings;
        this.dataSection = dataSection;
        this.folderSpecs = (FolderSpec[])folderSpecs.clone();
        this.propDefs = propDefs;
    }

    void init() throws OntologyBuildException {
        this.allRoots = new ArrayList<Concept>();
        String rootNodeDisplayName = this.settings.getRootNodeName();
        if (rootNodeDisplayName != null) {
            try {
                this.conceptRoot = new Concept(SimpleConceptId.getInstance(rootNodeDisplayName, this), null, this);
            }
            catch (InvalidConceptCodeException ex) {
                throw new OntologyBuildException("Could not build ontology", ex);
            }
            this.conceptRoot.setDisplayName(rootNodeDisplayName);
            this.conceptRoot.setDataType(DataType.TEXT);
            this.conceptRoot.setSourceSystemCode(this.sourceSystemCode);
            this.allRoots.add(this.conceptRoot);
        }
        this.providerConceptTreeBuilder = new ProviderConceptTreeBuilder(this);
        try {
            SubtreeBuilder[] builders;
            this.constructTreePre();
            for (SubtreeBuilder builder : builders = new SubtreeBuilder[]{new PhenotypesBuilder(this.cache, this), new DemographicsBuilder(this.cache, this), this.providerConceptTreeBuilder}) {
                builder.build(this.conceptRoot);
                if (this.conceptRoot != null) continue;
                Concept[] builderRoot = builder.getRoots();
                Arrays.addAll(this.allRoots, (Object[][])new Concept[][]{builderRoot});
            }
        }
        catch (InvalidPromoteArgumentException | UnknownPropositionDefinitionException | InvalidConceptCodeException | IOException | SQLException | KnowledgeSourceReadException ex) {
            Metadata.throwOntologyBuildException(ex);
        }
        assert (!this.allRoots.contains(null)) : "Null root concepts! " + this.allRoots;
        this.setI2B2PathsToConcepts();
    }

    public ConnectionSpec getMetaConnectionSpec() {
        return this.metaConnectionSpec;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Data getDataSection() {
        return this.dataSection;
    }

    public Concept getConceptRoot() {
        return this.conceptRoot;
    }

    public void addModifierRoot(Concept concept) {
        if (concept != null) {
            this.modifierRoots.add(concept);
            this.allRoots.add(concept);
        }
    }

    public Concept[] getModifierRoots() {
        return this.modifierRoots.toArray(new Concept[this.modifierRoots.size()]);
    }

    public Concept[] getAllRoots() {
        return this.allRoots.toArray(new Concept[this.allRoots.size()]);
    }

    public PropositionDefinition[] getPhenotypeDefinitions() {
        return (PropositionDefinition[])this.userDefinedPropositionDefinitions.clone();
    }

    public String getSourceSystemCode() {
        return this.sourceSystemCode;
    }

    public FolderSpec[] getFolderSpecs() {
        return (FolderSpec[])this.folderSpecs.clone();
    }

    public ProviderDimension addProvider(ProviderDimension providerDimension) throws InvalidConceptCodeException, SQLException {
        this.providerConceptTreeBuilder.add(providerDimension);
        return providerDimension;
    }

    Concept newContainerConcept(String displayName, String conceptCode) throws OntologyBuildException {
        ConceptId conceptId = SimpleConceptId.getInstance(displayName, this);
        Concept concept = this.newConcept(conceptId, conceptCode, this.getSourceSystemCode());
        concept.setCVisualAttributes("CAE");
        concept.setDisplayName(displayName);
        return concept;
    }

    Concept getOrCreateHardCodedFolder(String ... conceptIdSuffixes) throws InvalidConceptCodeException {
        String conceptIdSuffix = StringUtils.join((Object[])conceptIdSuffixes, (char)'|');
        ConceptId conceptId = SimpleConceptId.getInstance("AIW|" + conceptIdSuffix, this);
        Concept root = this.getFromIdCache(conceptId);
        if (root == null) {
            root = this.createHardCodedFolder(conceptIdSuffix, conceptIdSuffixes[conceptIdSuffixes.length - 1]);
        }
        return root;
    }

    private Concept createHardCodedFolder(String conceptIdSuffix, String displayName) throws InvalidConceptCodeException {
        ConceptId conceptId = SimpleConceptId.getInstance("AIW|" + conceptIdSuffix, this);
        Concept root = new Concept(conceptId, null, this);
        root.setSourceSystemCode(this.sourceSystemCode);
        root.setDisplayName(displayName);
        root.setDataType(DataType.TEXT);
        this.addToIdCache(root);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Concept getFromIdCache(ConceptId conceptId) {
        Map<ConceptId, Concept> map = this.conceptCache;
        synchronized (map) {
            return this.conceptCache.get(conceptId);
        }
    }

    public Concept getFromIdCache(String propId, String propertyName, Value value) {
        return this.getFromIdCache(PropDefConceptId.getInstance(propId, propertyName, value, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToIdCache(Concept concept) {
        Map<ConceptId, Concept> map = this.conceptCache;
        synchronized (map) {
            if (this.conceptCache.containsKey(concept.getId())) {
                throw new IllegalArgumentException("concept already added!");
            }
            this.conceptCache.put(concept.getId(), concept);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInConceptIdCache(List<Object> key, ConceptId conceptId) {
        Map<List<Object>, ConceptId> map = this.conceptIdCache;
        synchronized (map) {
            if (this.conceptIdCache.containsKey(key)) {
                throw new IllegalArgumentException("concept id already added!");
            }
            this.conceptIdCache.put(key, conceptId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConceptId getFromConceptIdCache(List<Object> key) {
        Map<List<Object>, ConceptId> map = this.conceptIdCache;
        synchronized (map) {
            return this.conceptIdCache.get(key);
        }
    }

    public String[] extractDerived() throws KnowledgeSourceReadException {
        HashSet<String> potentialDerivedConceptCodes = new HashSet<String>();
        for (Concept r : this.getAllRoots()) {
            Enumeration<TreeNode> emu = r.depthFirstEnumeration();
            while (emu.hasMoreElements()) {
                Concept concept = (Concept)emu.nextElement();
                if (!concept.isDerived()) continue;
                potentialDerivedConceptCodes.add(concept.getId().getId());
            }
        }
        return potentialDerivedConceptCodes.toArray(new String[potentialDerivedConceptCodes.size()]);
    }

    public Concept newConcept(ConceptId conceptId, String conceptCodePrefix, String sourceSystemCode) throws OntologyBuildException {
        Concept concept = this.getFromIdCache(conceptId);
        if (concept == null) {
            try {
                concept = new Concept(conceptId, conceptCodePrefix, this);
            }
            catch (InvalidConceptCodeException ex) {
                throw new OntologyBuildException("Error building ontology", ex);
            }
        } else {
            throw new OntologyBuildException("Duplicate concept: " + concept.getConceptCode());
        }
        concept.setSourceSystemCode(MetadataUtil.toSourceSystemCode(sourceSystemCode));
        concept.setDisplayName(concept.getConceptCode());
        this.addToIdCache(concept);
        return concept;
    }

    private void constructTreePre() throws IOException, SQLException, KnowledgeSourceReadException, UnknownPropositionDefinitionException, InvalidConceptCodeException, OntologyBuildException, InvalidPromoteArgumentException {
        for (FolderSpec folderSpec : this.folderSpecs) {
            this.processFolderSpec(folderSpec);
        }
    }

    private void processFolderSpec(FolderSpec folderSpec) throws InvalidConceptCodeException, KnowledgeSourceReadException, InvalidPromoteArgumentException, UnknownPropositionDefinitionException, OntologyBuildException {
        if (folderSpec.getProperty() == null) {
            PropositionConceptTreeBuilder propProxy = new PropositionConceptTreeBuilder(this.cache, folderSpec.getPropositions(), folderSpec.getConceptCodePrefix(), folderSpec.getValueType(), folderSpec.getModifiers(), folderSpec.isAlreadyLoaded(), this);
            propProxy.build(this.conceptRoot);
            if (this.conceptRoot == null) {
                Arrays.addAll(this.allRoots, (Object[][])new Concept[][]{propProxy.getRoots()});
            }
        } else {
            for (String propId : folderSpec.getPropositions()) {
                ConceptId conceptId = PropDefConceptId.getInstance(propId, null, this);
                Concept concept = this.getFromIdCache(conceptId);
                if (concept == null) {
                    concept = new Concept(conceptId, folderSpec.getConceptCodePrefix(), this);
                    concept.setSourceSystemCode(this.sourceSystemCode);
                    PropositionDefinition propDef = this.cache.get(propId);
                    if (propDef == null) {
                        throw new UnknownPropositionDefinitionException(propId);
                    }
                    concept.setDisplayName(propDef.getDisplayName());
                    concept.setDataType(DataType.TEXT);
                    concept.setAlreadyLoaded(folderSpec.isAlreadyLoaded());
                    this.addToIdCache(concept);
                    if (this.conceptRoot != null) {
                        this.conceptRoot.add(concept);
                    } else {
                        this.allRoots.add(concept);
                    }
                }
                ValueSetConceptTreeBuilder vsProxy = new ValueSetConceptTreeBuilder(this.cache, folderSpec.getPropositions(), folderSpec.getProperty(), folderSpec.getConceptCodePrefix(), this);
                vsProxy.build(concept);
            }
        }
    }

    private void setI2B2PathsToConcepts() throws OntologyBuildException {
        Map result;
        block58: {
            if (this.metaConnectionSpec != null) {
                boolean allAlreadyLoaded = true;
                for (FolderSpec folderSpec : this.folderSpecs) {
                    if (folderSpec.isAlreadyLoaded()) continue;
                    allAlreadyLoaded = false;
                    break;
                }
                try (Connection connection = this.metaConnectionSpec.getOrCreate();){
                    QueryConstructor theQuery;
                    Throwable throwable;
                    block57: {
                        try {
                            if (allAlreadyLoaded) {
                                throwable = null;
                                try (UniqueIdTempTableHandler tmp = new UniqueIdTempTableHandler(this.metaConnectionSpec.getDatabaseProduct(), connection, false);){
                                    for (PropositionDefinition pd : this.propDefs) {
                                        tmp.insert(pd.getId());
                                    }
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                theQuery = ALL_CONCEPTS_QUERY_WITH_TMP;
                                break block57;
                            }
                            theQuery = ALL_CONCEPTS_QUERY;
                        }
                        catch (SQLException sqle) {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            throw sqle;
                        }
                    }
                    try {
                        throwable = null;
                        try (QueryExecutor qe = new QueryExecutor(connection, theQuery, new TableAccessReader(this.metaConnectionSpec.getDatabaseProduct(), this.settings.getMetaTableName(), new String[0]));){
                            result = qe.execute(rs -> {
                                HashMap result1 = new HashMap();
                                if (rs != null) {
                                    try {
                                        while (rs.next()) {
                                            Collections.putList(result1, (Object)rs.getString(1), (Object)rs.getString(2));
                                        }
                                    }
                                    catch (SQLException ex) {
                                        throw new KnowledgeSourceReadException((Throwable)ex);
                                    }
                                }
                                return result1;
                            });
                            connection.commit();
                            break block58;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (SQLException | KnowledgeSourceReadException ksre) {
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        throw ksre;
                    }
                }
                catch (SQLException | KnowledgeSourceReadException ex) {
                    throw new OntologyBuildException(ex);
                }
            }
            result = new HashMap();
        }
        for (Concept c : this.getAllRoots()) {
            Enumeration<TreeNode> emu = c.preorderEnumeration();
            boolean isInPhenotypes = false;
            while (emu.hasMoreElements()) {
                List get;
                Concept conceptFromCache;
                Concept concept = (Concept)emu.nextElement();
                TreeNode parent = concept.getParent();
                if (parent != null && parent.equals(c)) {
                    isInPhenotypes = false;
                }
                if (concept.getSymbol().equals("AIW|Phenotypes")) {
                    isInPhenotypes = true;
                }
                if ((conceptFromCache = this.getFromIdCache(concept.getId())) != null && (isInPhenotypes || !result.containsKey(conceptFromCache.getSymbol()))) {
                    conceptFromCache.addHierarchyPath(concept.getFullName());
                }
                if (conceptFromCache == null || (get = (List)result.get(concept.getSymbol())) == null) continue;
                for (String hp : get) {
                    conceptFromCache.addHierarchyPath(hp);
                }
            }
        }
    }

    private static void throwOntologyBuildException(Throwable ex) throws OntologyBuildException {
        throw new OntologyBuildException("Error building ontology", ex);
    }
}

