/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.ConnectionSpecQueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.LevelReader;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.TableAccessReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.arp.javautil.sql.ConnectionSpec;
import org.arp.javautil.sql.DatabaseAPI;
import org.arp.javautil.sql.DatabaseProduct;
import org.arp.javautil.sql.InvalidConnectionSpecArguments;
import org.protempa.KnowledgeSourceReadException;

class QuerySupport {
    private static final String DEFAULT_EUREKA_ID_COLUMN = "EK_UNIQUE_ID";
    private final DatabaseAPI databaseApi;
    private final String databaseId;
    private final String username;
    private final String password;
    private final String excludeTableName;
    private final TableAccessReader.TableAccessReaderBuilder tableAccessReaderBuilder;
    private final String eurekaIdColumn;
    private final DatabaseProduct databaseProduct;
    private final ConnectionSpec connectionSpec;
    private final LevelReader levelReader;

    QuerySupport(DatabaseAPI databaseApi, String databaseId, String username, String password, String excludeTableName, String eurekaIdColumn) throws InvalidConnectionSpecArguments, SQLException {
        this.databaseApi = databaseApi;
        this.eurekaIdColumn = eurekaIdColumn;
        this.databaseId = databaseId;
        this.username = username;
        this.password = password;
        this.excludeTableName = excludeTableName;
        this.connectionSpec = this.databaseApi.newConnectionSpecInstance(databaseId, username, password, false);
        this.tableAccessReaderBuilder = new TableAccessReader.TableAccessReaderBuilder(this.connectionSpec.getDatabaseProduct()).excludeTableName(excludeTableName);
        try (Connection cn = this.connectionSpec.getOrCreate();){
            this.databaseProduct = DatabaseProduct.fromMetaData((DatabaseMetaData)cn.getMetaData());
        }
        this.levelReader = new LevelReader(this);
    }

    String getEurekaIdColumn() {
        return this.eurekaIdColumn;
    }

    DatabaseAPI getDatabaseApi() {
        return this.databaseApi;
    }

    String getDatabaseId() {
        return this.databaseId;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getExcludeTableName() {
        return this.excludeTableName;
    }

    TableAccessReader.TableAccessReaderBuilder getTableAccessReaderBuilder() {
        return new TableAccessReader.TableAccessReaderBuilder(this.tableAccessReaderBuilder);
    }

    Connection getConnection() throws InvalidConnectionSpecArguments, SQLException {
        return this.connectionSpec.getOrCreate();
    }

    DatabaseProduct getDatabaseProduct() throws KnowledgeSourceReadException {
        return this.databaseProduct;
    }

    LevelReader getLevelReader() {
        return this.levelReader;
    }

    ConnectionSpecQueryExecutor getQueryExecutorInstanceRestrictByTables(QueryConstructor queryConstructor, String ... tables) throws KnowledgeSourceReadException {
        try {
            return new ConnectionSpecQueryExecutor(this.databaseApi, this.databaseId, this.username, this.password, queryConstructor, tables);
        }
        catch (SQLException | InvalidConnectionSpecArguments ex) {
            throw new KnowledgeSourceReadException(ex);
        }
    }

    ConnectionSpecQueryExecutor getQueryExecutorInstance(QueryConstructor queryConstructor) throws KnowledgeSourceReadException {
        try {
            return new ConnectionSpecQueryExecutor(this.databaseApi, this.databaseId, this.username, this.password, queryConstructor, this.getTableAccessReaderBuilder().build());
        }
        catch (SQLException | InvalidConnectionSpecArguments ex) {
            throw new KnowledgeSourceReadException(ex);
        }
    }

    ConnectionSpecQueryExecutor getQueryExecutorInstance(QueryConstructor queryConstructor, TableAccessReader tableAccessReader) throws KnowledgeSourceReadException {
        try {
            return new ConnectionSpecQueryExecutor(this.databaseApi, this.databaseId, this.username, this.password, queryConstructor, tableAccessReader);
        }
        catch (SQLException | InvalidConnectionSpecArguments ex) {
            throw new KnowledgeSourceReadException(ex);
        }
    }

    ConnectionSpecQueryExecutor getQueryExecutorInstanceRestrictByEkUniqueIds(QueryConstructor queryConstructor, String ... ekUniqueIds) throws KnowledgeSourceReadException {
        try {
            return new ConnectionSpecQueryExecutor(this.databaseApi, this.databaseId, this.username, this.password, queryConstructor, this.getTableAccessReaderBuilder().restrictTablesBy(ekUniqueIds).build());
        }
        catch (SQLException | InvalidConnectionSpecArguments ex) {
            throw new KnowledgeSourceReadException(ex);
        }
    }

    QueryExecutor getQueryExecutorInstanceRestrictByTables(Connection connection, QueryConstructor queryConstructor, String ... tables) throws KnowledgeSourceReadException {
        if (connection != null) {
            return new QueryExecutor(connection, queryConstructor, tables);
        }
        return this.getQueryExecutorInstanceRestrictByTables(queryConstructor, tables);
    }

    QueryExecutor getQueryExecutorInstance(Connection connection, QueryConstructor queryConstructor) throws KnowledgeSourceReadException {
        if (connection != null) {
            return new QueryExecutor(connection, queryConstructor, this.getTableAccessReaderBuilder().build());
        }
        return this.getQueryExecutorInstance(queryConstructor);
    }

    QueryExecutor getQueryExecutorInstance(Connection connection, QueryConstructor queryConstructor, TableAccessReader tableAccessReader) throws KnowledgeSourceReadException {
        if (connection != null) {
            return new QueryExecutor(connection, queryConstructor, tableAccessReader);
        }
        return this.getQueryExecutorInstance(queryConstructor);
    }

    QueryExecutor getQueryExecutorInstanceRestrictByEkUniqueIds(Connection connection, QueryConstructor queryConstructor, String ... ekUniqueIds) throws KnowledgeSourceReadException {
        if (connection != null) {
            return new QueryExecutor(connection, queryConstructor, this.getTableAccessReaderBuilder().restrictTablesBy(ekUniqueIds).build());
        }
        return this.getQueryExecutorInstance(queryConstructor);
    }

    static class QuerySupportBuilder {
        private DatabaseAPI databaseApi = DatabaseAPI.DRIVERMANAGER;
        private String databaseId;
        private String username;
        private String password;
        private String excludeTableName;
        private String eurekaIdColumn = "EK_UNIQUE_ID";

        QuerySupportBuilder() {
        }

        DatabaseAPI getDatabaseApi() {
            return this.databaseApi;
        }

        void setDatabaseApi(DatabaseAPI databaseApi) {
            this.databaseApi = databaseApi;
        }

        String getDatabaseId() {
            return this.databaseId;
        }

        void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        String getUsername() {
            return this.username;
        }

        void setUsername(String username) {
            this.username = username;
        }

        String getPassword() {
            return this.password;
        }

        void setPassword(String password) {
            this.password = password;
        }

        String getExcludeTableName() {
            return this.excludeTableName;
        }

        void setExcludeTableName(String excludeTableName) {
            this.excludeTableName = excludeTableName;
        }

        String getEurekaIdColumn() {
            return this.eurekaIdColumn;
        }

        void setEurekaIdColumn(String eurekaIdColumn) {
            this.eurekaIdColumn = eurekaIdColumn;
        }

        QuerySupport build() throws InvalidConnectionSpecArguments, SQLException {
            return new QuerySupport(this.databaseApi, this.databaseId, this.username, this.password, this.excludeTableName, this.eurekaIdColumn);
        }
    }
}

