/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dsb;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.arp.javautil.sql.InvalidConnectionSpecArguments;
import org.protempa.DataSourceReadException;
import org.protempa.KeySetSpec;
import org.protempa.SourceSystem;
import org.protempa.backend.BackendInitializationException;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.annotations.BackendInfo;
import org.protempa.backend.annotations.BackendProperty;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.JDBCDateTimeTimestampDateValueFormat;
import org.protempa.backend.dsb.relationaldb.JDBCDateTimeTimestampPositionParser;
import org.protempa.backend.dsb.relationaldb.JDBCPositionFormat;
import org.protempa.backend.dsb.relationaldb.JDBCValueFormat;
import org.protempa.backend.dsb.relationaldb.JoinSpec;
import org.protempa.backend.dsb.relationaldb.Operator;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.RelationalDbDataSourceBackend;
import org.protempa.backend.dsb.relationaldb.mappings.DefaultMappings;
import org.protempa.backend.dsb.relationaldb.mappings.Mappings;
import org.protempa.proposition.value.AbsoluteTimeGranularity;
import org.protempa.proposition.value.AbsoluteTimeGranularityFactory;
import org.protempa.proposition.value.AbsoluteTimeUnit;
import org.protempa.proposition.value.AbsoluteTimeUnitFactory;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.GranularityFactory;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.UnitFactory;
import org.protempa.proposition.value.ValueType;

@BackendInfo(displayName="I2B2 Data Source Backend")
public final class I2B2DataSourceBackend
extends RelationalDbDataSourceBackend {
    private static final AbsoluteTimeUnitFactory ABS_TIME_UNIT_FACTORY = new AbsoluteTimeUnitFactory();
    private static final AbsoluteTimeGranularityFactory ABS_TIME_GRANULARITY_FACTORY = new AbsoluteTimeGranularityFactory();
    private static final JDBCPositionFormat POSITION_PARSER = new JDBCDateTimeTimestampPositionParser();
    private static final String PATIENT_DIMENSION = "patient_dimension";
    private static final String VISIT_DIMENSION = "visit_dimension";
    private static final String OBSERVATION_FACT = "observation_fact";
    private static final String PROVIDER_DIMENSION = "provider_dimension";
    private static final Logger LOGGER = Logger.getLogger(I2B2DataSourceBackend.class.getPackage().getName());
    private Long resultInstanceId;

    public I2B2DataSourceBackend() {
        this.setDefaultKeyIdTable(PATIENT_DIMENSION);
        this.setDefaultKeyIdColumn("patient_num");
        this.setDefaultKeyIdJoinKey("patient_num");
    }

    public void initialize(BackendInstanceSpec config) throws BackendInitializationException {
        super.initialize(config);
    }

    protected EntitySpec[] constantSpecs(String keyIdSchema, String keyIdTable, String keyIdColumn, String keyIdJoinKey) throws IOException {
        ColumnSpec[] columnSpecArray;
        ColumnSpec[] columnSpecArray2;
        ColumnSpec[] columnSpecArray3;
        DefaultMappings riId = new DefaultMappings((Map)new HashMap<Object, String>(){
            {
                this.put(I2B2DataSourceBackend.this.resultInstanceId, "" + I2B2DataSourceBackend.this.resultInstanceId);
            }
        });
        DefaultMappings hive = new DefaultMappings((Map)new HashMap<Object, String>(){
            {
                this.put("HIVE", "HIVE");
            }
        });
        String schemaName = this.getSchemaName();
        EntitySpec[] entitySpecArray = new EntitySpec[4];
        String[] stringArray = new String[]{"Patient"};
        ColumnSpec columnSpec = new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn);
        ColumnSpec[] columnSpecArray4 = new ColumnSpec[]{new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn)};
        PropertySpec[] propertySpecArray = new PropertySpec[]{new PropertySpec("patientId", null, new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn), ValueType.NOMINALVALUE)};
        ReferenceSpec[] referenceSpecArray = new ReferenceSpec[]{new ReferenceSpec("encounters", "Encounters", new ColumnSpec[]{new ColumnSpec(keyIdSchema, keyIdTable, new JoinSpec(keyIdJoinKey, "patient_num", new ColumnSpec(schemaName, VISIT_DIMENSION, "encounter_num")))}, ReferenceSpec.Type.MANY), new ReferenceSpec("patientDetails", "Patient Details", new ColumnSpec[]{new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn)}, ReferenceSpec.Type.MANY), new ReferenceSpec("patientAliases", "Patient Aliases", new ColumnSpec[]{new ColumnSpec(keyIdSchema, keyIdTable, new JoinSpec(keyIdJoinKey, "patient_num", new ColumnSpec(schemaName, "PATIENT_MAPPING", "PATIENT_IDE")))}, ReferenceSpec.Type.MANY)};
        if (this.isInKeySetMode()) {
            ColumnSpec[] columnSpecArray5 = new ColumnSpec[1];
            columnSpecArray3 = columnSpecArray5;
            columnSpecArray5[0] = new ColumnSpec(keyIdSchema, keyIdTable, "RESULT_INSTANCE_ID", Operator.EQUAL_TO, (Mappings)riId);
        } else {
            columnSpecArray3 = null;
        }
        entitySpecArray[0] = new EntitySpec("Patients", null, stringArray, true, columnSpec, columnSpecArray4, null, null, propertySpecArray, referenceSpecArray, null, null, columnSpecArray3, null, null, null, null, null);
        String[] stringArray2 = new String[]{"PatientAlias"};
        ColumnSpec columnSpec2 = new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn, new JoinSpec(keyIdJoinKey, "patient_num", new ColumnSpec(schemaName, "PATIENT_MAPPING")));
        ColumnSpec[] columnSpecArray6 = new ColumnSpec[]{new ColumnSpec(schemaName, "PATIENT_MAPPING", "PATIENT_IDE"), new ColumnSpec(schemaName, "PATIENT_MAPPING", "PATIENT_IDE_SOURCE")};
        PropertySpec[] propertySpecArray2 = new PropertySpec[]{new PropertySpec("patientId", null, new ColumnSpec(schemaName, "PATIENT_MAPPING", "PATIENT_IDE"), ValueType.NOMINALVALUE), new PropertySpec("fieldName", null, new ColumnSpec(schemaName, "PATIENT_MAPPING", "PATIENT_IDE_SOURCE"), ValueType.NOMINALVALUE)};
        if (this.isInKeySetMode()) {
            ColumnSpec[] columnSpecArray7 = new ColumnSpec[2];
            columnSpecArray7[0] = new ColumnSpec(schemaName, "PATIENT_MAPPING", new JoinSpec("patient_num", keyIdJoinKey, new ColumnSpec(keyIdSchema, keyIdTable, "RESULT_INSTANCE_ID", Operator.EQUAL_TO, (Mappings)riId)));
            columnSpecArray2 = columnSpecArray7;
            columnSpecArray7[1] = new ColumnSpec(schemaName, "PATIENT_MAPPING", "PATIENT_IDE_SOURCE", Operator.NOT_EQUAL_TO, (Mappings)hive);
        } else {
            ColumnSpec[] columnSpecArray8 = new ColumnSpec[1];
            columnSpecArray2 = columnSpecArray8;
            columnSpecArray8[0] = new ColumnSpec(schemaName, "PATIENT_MAPPING", "PATIENT_IDE_SOURCE", Operator.NOT_EQUAL_TO, (Mappings)hive);
        }
        entitySpecArray[1] = new EntitySpec("Patient Aliases", null, stringArray2, true, columnSpec2, columnSpecArray6, null, null, propertySpecArray2, null, null, null, columnSpecArray2, null, null, null, null, null);
        String[] stringArray3 = new String[]{"PatientDetails"};
        ColumnSpec columnSpec3 = new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn, new JoinSpec(keyIdJoinKey, "patient_num", new ColumnSpec(schemaName, PATIENT_DIMENSION)));
        ColumnSpec[] columnSpecArray9 = new ColumnSpec[]{new ColumnSpec(schemaName, PATIENT_DIMENSION, "patient_num")};
        PropertySpec[] propertySpecArray3 = new PropertySpec[]{new PropertySpec("patientId", null, new ColumnSpec(schemaName, PATIENT_DIMENSION, "patient_num"), ValueType.NOMINALVALUE), new PropertySpec("gender", null, new ColumnSpec(schemaName, PATIENT_DIMENSION, "SEX_CD", Operator.EQUAL_TO, this.getMappingsFactory().getInstance("gender.txt"), true), ValueType.NOMINALVALUE), new PropertySpec("race", null, new ColumnSpec(schemaName, PATIENT_DIMENSION, "RACE_CD", Operator.EQUAL_TO, this.getMappingsFactory().getInstance("race.txt"), true), ValueType.NOMINALVALUE), new PropertySpec("ethnicity", null, new ColumnSpec(schemaName, PATIENT_DIMENSION, "RACE_CD", Operator.EQUAL_TO, this.getMappingsFactory().getInstance("ethnicity.txt"), true), ValueType.NOMINALVALUE), new PropertySpec("dateOfBirth", null, new ColumnSpec(schemaName, PATIENT_DIMENSION, "BIRTH_DATE"), ValueType.DATEVALUE, (JDBCValueFormat)new JDBCDateTimeTimestampDateValueFormat()), new PropertySpec("language", null, new ColumnSpec(schemaName, PATIENT_DIMENSION, "LANGUAGE_CD", Operator.EQUAL_TO, this.getMappingsFactory().getInstance("language.txt"), true), ValueType.NOMINALVALUE), new PropertySpec("maritalStatus", null, new ColumnSpec(schemaName, PATIENT_DIMENSION, "MARITAL_STATUS_CD", Operator.EQUAL_TO, this.getMappingsFactory().getInstance("marital_status.txt"), true), ValueType.NOMINALVALUE)};
        ReferenceSpec[] referenceSpecArray2 = new ReferenceSpec[]{new ReferenceSpec("encounters", "Encounters", new ColumnSpec[]{new ColumnSpec(schemaName, PATIENT_DIMENSION, new JoinSpec("patient_num", "patient_num", new ColumnSpec(schemaName, VISIT_DIMENSION, "encounter_num")))}, ReferenceSpec.Type.MANY), new ReferenceSpec("patient", "Patients", new ColumnSpec[]{new ColumnSpec(schemaName, PATIENT_DIMENSION, "patient_num")}, ReferenceSpec.Type.ONE)};
        if (this.isInKeySetMode()) {
            ColumnSpec[] columnSpecArray10 = new ColumnSpec[1];
            columnSpecArray = columnSpecArray10;
            columnSpecArray10[0] = new ColumnSpec(schemaName, PATIENT_DIMENSION, new JoinSpec("patient_num", keyIdJoinKey, new ColumnSpec(keyIdSchema, keyIdTable, "RESULT_INSTANCE_ID", Operator.EQUAL_TO, (Mappings)riId)));
        } else {
            columnSpecArray = null;
        }
        entitySpecArray[2] = new EntitySpec("Patient Details", null, stringArray3, true, columnSpec3, columnSpecArray9, null, null, propertySpecArray3, referenceSpecArray2, null, null, columnSpecArray, null, null, null, null, null);
        entitySpecArray[3] = new EntitySpec("Providers", null, new String[]{"AttendingPhysician"}, false, new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn, new JoinSpec(keyIdJoinKey, "patient_num", new ColumnSpec(schemaName, PATIENT_DIMENSION, new JoinSpec("patient_num", "patient_num", new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, new JoinSpec("provider_id", "provider_id", new ColumnSpec(schemaName, PROVIDER_DIMENSION))))))))), new ColumnSpec[]{new ColumnSpec(schemaName, PROVIDER_DIMENSION, "provider_id")}, null, null, new PropertySpec[]{new PropertySpec("fullName", null, new ColumnSpec(schemaName, PROVIDER_DIMENSION, "NAME_CHAR"), ValueType.NOMINALVALUE)}, null, null, null, null, null, null, null, null, null);
        return entitySpecArray;
    }

    protected EntitySpec[] eventSpecs(String keyIdSchema, String keyIdTable, String keyIdColumn, String keyIdJoinKey) throws IOException {
        ColumnSpec[] columnSpecArray;
        ColumnSpec[] columnSpecArray2;
        ColumnSpec[] columnSpecArray3;
        DefaultMappings riId = new DefaultMappings((Map)new HashMap<Object, String>(){
            {
                this.put(I2B2DataSourceBackend.this.resultInstanceId, "" + I2B2DataSourceBackend.this.resultInstanceId);
            }
        });
        String schemaName = this.getSchemaName();
        Mappings icd9DxMappings = this.getMappingsFactory().getInstance("icd9_diagnosis.txt");
        Mappings icd9PxMappings = this.getMappingsFactory().getInstance("icd9_procedure.txt");
        EntitySpec[] entitySpecArray = new EntitySpec[3];
        String[] stringArray = new String[]{"Encounter"};
        ColumnSpec columnSpec = new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn, new JoinSpec(keyIdJoinKey, "patient_num", new ColumnSpec(schemaName, PATIENT_DIMENSION, new JoinSpec("patient_num", "patient_num", new ColumnSpec(schemaName, VISIT_DIMENSION)))));
        ColumnSpec[] columnSpecArray4 = new ColumnSpec[]{new ColumnSpec(schemaName, VISIT_DIMENSION, "encounter_num")};
        ColumnSpec columnSpec2 = new ColumnSpec(schemaName, VISIT_DIMENSION, "START_DATE");
        ColumnSpec columnSpec3 = new ColumnSpec(schemaName, VISIT_DIMENSION, "END_DATE");
        PropertySpec[] propertySpecArray = new PropertySpec[]{new PropertySpec("encounterId", null, new ColumnSpec(schemaName, VISIT_DIMENSION, "encounter_num"), ValueType.NOMINALVALUE)};
        ReferenceSpec[] referenceSpecArray = new ReferenceSpec[]{new ReferenceSpec("patient", "Patients", new ColumnSpec[]{new ColumnSpec(schemaName, VISIT_DIMENSION, "patient_num")}, ReferenceSpec.Type.ONE), new ReferenceSpec("patientDetails", "Patient Details", new ColumnSpec[]{new ColumnSpec(schemaName, VISIT_DIMENSION, "patient_num")}, ReferenceSpec.Type.ONE), new ReferenceSpec("diagnosisCodes", "Diagnosis Codes", new ColumnSpec[]{new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "encounter_num"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "provider_id"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "start_date")))}, ReferenceSpec.Type.MANY), new ReferenceSpec("procedures", "ICD9 Procedure Codes", new ColumnSpec[]{new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "encounter_num"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "provider_id"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "start_date")))}, ReferenceSpec.Type.MANY), new ReferenceSpec("msdrg", "MSDRG Codes", new ColumnSpec[]{new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "encounter_num"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "provider_id"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "start_date")))}, ReferenceSpec.Type.ONE), new ReferenceSpec("aprdrg", "APR DRG Codes", new ColumnSpec[]{new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "encounter_num"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "provider_id"))), new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "start_date")))}, ReferenceSpec.Type.ONE), new ReferenceSpec("provider", "Providers", new ColumnSpec[]{new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT, "provider_id")))}, ReferenceSpec.Type.ONE)};
        if (this.isInKeySetMode()) {
            ColumnSpec[] columnSpecArray5 = new ColumnSpec[1];
            columnSpecArray3 = columnSpecArray5;
            columnSpecArray5[0] = new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("patient_num", keyIdJoinKey, new ColumnSpec(keyIdSchema, keyIdTable, "RESULT_INSTANCE_ID", Operator.EQUAL_TO, (Mappings)riId)));
        } else {
            columnSpecArray3 = null;
        }
        entitySpecArray[0] = new EntitySpec("Encounters", null, stringArray, true, columnSpec, columnSpecArray4, columnSpec2, columnSpec3, propertySpecArray, referenceSpecArray, null, null, columnSpecArray3, null, null, (Granularity)AbsoluteTimeGranularity.DAY, POSITION_PARSER, null);
        String[] stringArray2 = icd9DxMappings.readTargets();
        ColumnSpec columnSpec4 = new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn, new JoinSpec(keyIdJoinKey, "patient_num", new ColumnSpec(schemaName, PATIENT_DIMENSION, new JoinSpec("patient_num", "patient_num", new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT)))))));
        ColumnSpec[] columnSpecArray6 = new ColumnSpec[]{new ColumnSpec(schemaName, OBSERVATION_FACT, "encounter_num"), new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd"), new ColumnSpec(schemaName, OBSERVATION_FACT, "provider_id"), new ColumnSpec(schemaName, OBSERVATION_FACT, "start_date")};
        ColumnSpec columnSpec5 = new ColumnSpec(schemaName, OBSERVATION_FACT, "START_DATE");
        PropertySpec[] propertySpecArray2 = new PropertySpec[]{new PropertySpec("code", null, new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd"), ValueType.NOMINALVALUE)};
        ColumnSpec columnSpec6 = new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd", Operator.EQUAL_TO, icd9DxMappings, false);
        if (this.isInKeySetMode()) {
            ColumnSpec[] columnSpecArray7 = new ColumnSpec[1];
            columnSpecArray2 = columnSpecArray7;
            columnSpecArray7[0] = new ColumnSpec(schemaName, OBSERVATION_FACT, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("patient_num", keyIdJoinKey, new ColumnSpec(keyIdSchema, keyIdTable, "RESULT_INSTANCE_ID", Operator.EQUAL_TO, (Mappings)riId)))));
        } else {
            columnSpecArray2 = null;
        }
        entitySpecArray[1] = new EntitySpec("Diagnosis Codes", null, stringArray2, true, columnSpec4, columnSpecArray6, columnSpec5, null, propertySpecArray2, null, null, columnSpec6, columnSpecArray2, null, null, (Granularity)AbsoluteTimeGranularity.DAY, POSITION_PARSER, (Unit)AbsoluteTimeUnit.YEAR);
        String[] stringArray3 = icd9PxMappings.readTargets();
        ColumnSpec columnSpec7 = new ColumnSpec(keyIdSchema, keyIdTable, keyIdColumn, new JoinSpec(keyIdJoinKey, "patient_num", new ColumnSpec(schemaName, PATIENT_DIMENSION, new JoinSpec("patient_num", "patient_num", new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, OBSERVATION_FACT)))))));
        ColumnSpec[] columnSpecArray8 = new ColumnSpec[]{new ColumnSpec(schemaName, OBSERVATION_FACT, "encounter_num"), new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd"), new ColumnSpec(schemaName, OBSERVATION_FACT, "provider_id"), new ColumnSpec(schemaName, OBSERVATION_FACT, "start_date")};
        ColumnSpec columnSpec8 = new ColumnSpec(schemaName, OBSERVATION_FACT, "START_DATE");
        PropertySpec[] propertySpecArray3 = new PropertySpec[]{new PropertySpec("code", null, new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd"), ValueType.NOMINALVALUE)};
        ColumnSpec columnSpec9 = new ColumnSpec(schemaName, OBSERVATION_FACT, "concept_cd", Operator.EQUAL_TO, icd9PxMappings, false);
        if (this.isInKeySetMode()) {
            ColumnSpec[] columnSpecArray9 = new ColumnSpec[1];
            columnSpecArray = columnSpecArray9;
            columnSpecArray9[0] = new ColumnSpec(schemaName, OBSERVATION_FACT, new JoinSpec("encounter_num", "encounter_num", new ColumnSpec(schemaName, VISIT_DIMENSION, new JoinSpec("patient_num", keyIdJoinKey, new ColumnSpec(keyIdSchema, keyIdTable, "RESULT_INSTANCE_ID", Operator.EQUAL_TO, (Mappings)riId)))));
        } else {
            columnSpecArray = null;
        }
        entitySpecArray[2] = new EntitySpec("ICD9 Procedure Codes", null, stringArray3, true, columnSpec7, columnSpecArray8, columnSpec8, null, propertySpecArray3, null, null, columnSpec9, columnSpecArray, null, null, (Granularity)AbsoluteTimeGranularity.DAY, POSITION_PARSER, null);
        EntitySpec[] eventSpecs = entitySpecArray;
        return eventSpecs;
    }

    protected EntitySpec[] primitiveParameterSpecs(String keyIdSchema, String keyIdTable, String keyIdColumn, String keyIdJoinKey) throws IOException {
        return new EntitySpec[0];
    }

    public GranularityFactory getGranularityFactory() {
        return ABS_TIME_GRANULARITY_FACTORY;
    }

    public UnitFactory getUnitFactory() {
        return ABS_TIME_UNIT_FACTORY;
    }

    @BackendProperty(displayName="Query Master ID")
    public void setResultInstanceId(Long resultInstanceId) {
        this.resultInstanceId = resultInstanceId;
        this.setKeyLoaderKeyIdSchema(this.getSchemaName());
        this.setKeyLoaderKeyIdTable("QT_PATIENT_SET_COLLECTION");
        this.setKeyLoaderKeyIdColumn("PATIENT_NUM");
        this.setKeyLoaderKeyIdJoinKey("PATIENT_NUM");
    }

    public Long getResultInstanceId() {
        return this.resultInstanceId;
    }

    public KeySetSpec[] getSelectedKeySetSpecs() throws DataSourceReadException {
        ArrayList<KeySetSpec> result = new ArrayList<KeySetSpec>();
        if (this.resultInstanceId != null) {
            try (Connection con = this.getConnectionSpecInstance().getOrCreate();
                 PreparedStatement stmt = con.prepareStatement("SELECT A1.NAME, A1.USER_ID, A3.DESCRIPTION FROM QT_QUERY_MASTER A1 JOIN QT_QUERY_INSTANCE A2 ON (A1.QUERY_MASTER_ID=A2.QUERY_MASTER_ID) JOIN QT_QUERY_RESULT_INSTANCE A3 ON (A2.QUERY_INSTANCE_ID=A3.QUERY_INSTANCE_ID) WHERE A3.RESULT_INSTANCE_ID = ? AND A1.DELETE_FLAG = 'N' AND A2.DELETE_FLAG = 'N' AND A3.RESULT_TYPE_ID = 1");){
                stmt.setLong(1, this.resultInstanceId);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        result.add(new KeySetSpec((SourceSystem)this.getSourceSystem(), "" + this.resultInstanceId, rs.getString(1) + " (" + rs.getString(2) + ")", rs.getString(3)));
                    }
                }
            }
            catch (SQLException | InvalidConnectionSpecArguments ex) {
                throw new DataSourceReadException(ex);
            }
        }
        return result.toArray(new KeySetSpec[result.size()]);
    }

    public String getKeyType() {
        return "Patient";
    }
}

