/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptHierarchyLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.ModifierDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.ModifierDimensionHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class ModifierDimensionLoader
extends ConceptHierarchyLoader {
    private final ModifierDimensionHandler handler;
    private final Set<String> modifierPaths;

    public ModifierDimensionLoader(ModifierDimensionHandler handler) {
        this.handler = handler;
        this.modifierPaths = new HashSet<String>();
    }

    @Override
    protected void loadConcept(Concept concept) throws SQLException {
        if (concept.isInUse() && concept.isModifier()) {
            for (String path : concept.getHierarchyPaths()) {
                if (!this.modifierPaths.add(path)) continue;
                ModifierDimension modifierDimension = new ModifierDimension();
                modifierDimension.setPath(path);
                modifierDimension.setConceptCode(concept.getConceptCode());
                modifierDimension.setDisplayName(concept.getDisplayName());
                modifierDimension.setSourceSystemCode(concept.getSourceSystemCode());
                modifierDimension.setUpdated(TableUtil.setTimestampAttribute(concept.getUpdated()));
                modifierDimension.setDownloaded(TableUtil.setTimestampAttribute(concept.getDownloaded()));
                this.handler.insert((Object)modifierDimension);
            }
        }
    }
}

