/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.etl.util.RecordHandler;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.MetadataUtil;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientDimension;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.arp.javautil.sql.ConnectionSpec;

public class PatientDimensionHandler
extends RecordHandler<PatientDimension> {
    public static final String TEMP_PATIENT_TABLE = "ek_temp_patient";

    public PatientDimensionHandler(ConnectionSpec connSpec) throws SQLException {
        super(connSpec, "insert into ek_temp_patient(patient_id,patient_id_source,vital_status_cd,birth_date,death_date,sex_cd,age_in_years_num,language_cd,race_cd,marital_status_cd,religion_cd,zip_cd,statecityzip_path,patient_blob,update_date,download_date,import_date,sourcesystem_cd,delete_date) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    }

    protected void setParameters(PreparedStatement ps, PatientDimension patient) throws SQLException {
        ps.setString(1, patient.getEncryptedPatientId());
        ps.setString(2, MetadataUtil.toSourceSystemCode(patient.getEncryptedPatientIdSource()));
        ps.setString(3, patient.getVital());
        ps.setDate(4, patient.getBirthDate());
        ps.setDate(5, patient.getDeathDate());
        ps.setString(6, patient.getGender());
        ps.setObject(7, patient.getAgeInYears());
        ps.setString(8, patient.getLanguage());
        ps.setString(9, patient.getRace());
        ps.setString(10, patient.getMaritalStatus());
        ps.setString(11, patient.getReligion());
        ps.setString(12, patient.getZip());
        ps.setString(13, null);
        ps.setObject(14, null);
        ps.setTimestamp(15, patient.getUpdated());
        ps.setTimestamp(16, patient.getDownloaded());
        ps.setTimestamp(17, this.importTimestamp());
        ps.setString(18, MetadataUtil.toSourceSystemCode(patient.getSourceSystem()));
        ps.setTimestamp(19, patient.getDeletedDate());
    }
}

