/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.etl.util.CodeUtil;
import edu.emory.cci.aiw.i2b2etl.dest.config.Data;
import edu.emory.cci.aiw.i2b2etl.dest.config.Settings;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.MetadataUtil;
import edu.emory.cci.aiw.i2b2etl.dest.table.ActiveStatusCode;
import edu.emory.cci.aiw.i2b2etl.dest.table.DimensionFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.EncounterMappingHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import edu.emory.cci.aiw.i2b2etl.dest.table.VisitDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.VisitDimensionHandler;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.AbsoluteTimeGranularity;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;
import org.protempa.proposition.value.AbsoluteTimeUnit;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.Value;

public class VisitDimensionFactory
extends DimensionFactory {
    private final VisitDimensionHandler visitDimensionHandler;
    private final EncounterMappingHandler encounterMappingHandler;
    private final Settings settings;

    public VisitDimensionFactory(Metadata metadata, Settings settings, Data data, ConnectionSpec dataConnectionSpec) throws SQLException {
        super(data);
        this.settings = settings;
        this.visitDimensionHandler = new VisitDimensionHandler(dataConnectionSpec);
        this.encounterMappingHandler = new EncounterMappingHandler(dataConnectionSpec);
    }

    public VisitDimension getInstance(String encryptedPatientId, String encryptedPatientIdSourceSystem, TemporalProposition encounterProp, Map<UniqueId, Proposition> references) throws SQLException {
        Interval interval = encounterProp.getInterval();
        Date visitStartDate = AbsoluteTimeGranularityUtil.asDate((Long)interval.getMinStart());
        Date visitEndDate = AbsoluteTimeGranularityUtil.asDate((Long)interval.getMinFinish());
        Value visitId = this.getField(this.settings.getVisitDimensionId(), (Proposition)encounterProp, references);
        String visitIdStr = visitId != null ? visitId.getFormatted() : '@' + encryptedPatientId;
        Value inout = this.getField(this.settings.getVisitDimensionInOut(), (Proposition)encounterProp, references);
        String visitSourceSystem = MetadataUtil.toSourceSystemCode(encounterProp.getSourceSystem().getStringRepresentation());
        VisitDimension visitDimension = new VisitDimension();
        visitDimension.setEncryptedPatientId(TableUtil.setStringAttribute(encryptedPatientId));
        visitDimension.setStartDate(TableUtil.setTimestampAttribute(visitStartDate));
        visitDimension.setEndDate(TableUtil.setTimestampAttribute(visitEndDate));
        visitDimension.setVisitId(TableUtil.setStringAttribute(visitIdStr));
        visitDimension.setVisitIdSource(visitSourceSystem);
        visitDimension.setVisitSourceSystem(visitSourceSystem);
        visitDimension.setEncryptedPatientIdSource(encryptedPatientIdSourceSystem);
        visitDimension.setActiveStatus(ActiveStatusCode.getInstance(visitStartDate, interval.getStartGranularity(), visitEndDate, interval.getFinishGranularity()));
        visitDimension.setInOut(CodeUtil.toString((Value)inout));
        if (visitStartDate != null && visitEndDate != null) {
            visitDimension.setLengthOfStayInDays(AbsoluteTimeGranularity.DAY.distance(AbsoluteTimeGranularityUtil.asPosition((Date)visitStartDate).longValue(), AbsoluteTimeGranularityUtil.asPosition((Date)visitEndDate).longValue(), (Granularity)AbsoluteTimeGranularity.DAY, (Unit)AbsoluteTimeUnit.DAY));
        } else {
            visitDimension.setLengthOfStayInDays(null);
        }
        Date updated = encounterProp.getUpdateDate();
        if (updated == null) {
            updated = encounterProp.getCreateDate();
        }
        visitDimension.setUpdated(TableUtil.setTimestampAttribute(updated));
        visitDimension.setDownloaded(TableUtil.setTimestampAttribute(encounterProp.getDownloadDate()));
        visitDimension.setDeletedDate(TableUtil.setTimestampAttribute(encounterProp.getDeleteDate()));
        this.visitDimensionHandler.insert((Object)visitDimension);
        this.encounterMappingHandler.insert((Object)visitDimension);
        return visitDimension;
    }

    public void close() throws SQLException {
        boolean firstClosed = false;
        try {
            this.visitDimensionHandler.close();
            firstClosed = true;
            this.encounterMappingHandler.close();
        }
        catch (SQLException ex) {
            if (!firstClosed) {
                try {
                    this.encounterMappingHandler.close();
                }
                catch (SQLException ignore) {
                    ex.addSuppressed(ignore);
                }
            }
            throw ex;
        }
    }
}

