/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.etl.util.RecordHandler;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.MetadataUtil;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.arp.javautil.sql.ConnectionSpec;

public class ProviderDimensionHandler
extends RecordHandler<ProviderDimension> {
    public static final String TEMP_PROVIDER_TABLE = "ek_temp_provider";

    public ProviderDimensionHandler(ConnectionSpec connSpec) throws SQLException {
        super(connSpec, "insert into ek_temp_provider (provider_id,provider_path,name_char,provider_blob,update_date,download_date,import_date,sourcesystem_cd,upload_id,delete_date) values (?,?,?,?,?,?,?,?,?,?)");
    }

    protected void setParameters(PreparedStatement ps, ProviderDimension provider) throws SQLException {
        Concept concept = provider.getConcept();
        ps.setString(1, TableUtil.setStringAttribute(concept.getConceptCode()));
        ps.setString(2, concept.getFullName());
        ps.setString(3, concept.getDisplayName());
        ps.setObject(4, null);
        ps.setTimestamp(5, provider.getUpdated());
        ps.setTimestamp(6, provider.getDownloaded());
        ps.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
        ps.setString(8, MetadataUtil.toSourceSystemCode(provider.getSourceSystem()));
        ps.setObject(9, null);
        ps.setTimestamp(10, provider.getDeleted());
    }
}

