/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest;

import edu.emory.cci.aiw.etl.dest.config.Database;
import edu.emory.cci.aiw.etl.dest.config.DatabaseSpec;
import edu.emory.cci.aiw.i2b2etl.dest.I2B2QueryResultsHandlerSourceId;
import edu.emory.cci.aiw.i2b2etl.dest.I2b2ETLUtil;
import edu.emory.cci.aiw.i2b2etl.dest.RemoveMethod;
import edu.emory.cci.aiw.i2b2etl.dest.config.Concepts;
import edu.emory.cci.aiw.i2b2etl.dest.config.Configuration;
import edu.emory.cci.aiw.i2b2etl.dest.config.Data;
import edu.emory.cci.aiw.i2b2etl.dest.config.DataSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.Settings;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.MetadataFactory;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuildException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptDimensionHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptDimensionLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.FactHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.InvalidFactException;
import edu.emory.cci.aiw.i2b2etl.dest.table.InvalidPatientRecordException;
import edu.emory.cci.aiw.i2b2etl.dest.table.MetaTableConceptHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.MetaTableConceptLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.ModifierDimensionHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.ModifierDimensionLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientDimensionFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.PropositionFactHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimensionFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.RejectedFactHandlerFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.VisitDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.VisitDimensionFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.DataSource;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceCacheFactory;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.ProtempaEvent;
import org.protempa.ProtempaEventListener;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.backend.ksb.KnowledgeSourceBackend;
import org.protempa.dest.AbstractQueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerCloseException;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.Reference;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

public final class I2b2QueryResultsHandler
extends AbstractQueryResultsHandler {
    private static final String[] OBX_FACT_IDXS = new String[]{"FACT_NOLOB", "FACT_PATCON_DATE_PRVD_IDX", "FACT_CNPT_PAT_ENCT_IDX"};
    private static final int UPLOAD_ID = 0;
    private final Query query;
    private final KnowledgeSource knowledgeSource;
    private final Settings settings;
    private final Data data;
    private final Database database;
    private final ConnectionSpec dataConnectionSpec;
    private final Concepts conceptsSection;
    private List<FactHandler> factHandlers;
    private ConceptDimensionHandler conceptDimensionHandler;
    private ModifierDimensionHandler modifierDimensionHandler;
    private Metadata metadata;
    private final DataSpec providerFullNameSpec;
    private final DataSpec providerFirstNameSpec;
    private final DataSpec providerMiddleNameSpec;
    private final DataSpec providerLastNameSpec;
    private final ConnectionSpec metadataConnectionSpec;
    private final String visitPropId;
    private Connection dataSchemaConnection;
    private final Set<String> dataSourceBackendIds;
    private final RemoveMethod dataRemoveMethod;
    private RemoveMethod metaRemoveMethod;
    private final Set<String> knowledgeSourceBackendIds;
    private final String qrhId;
    private ProviderDimensionFactory providerDimensionFactory;
    private PatientDimensionFactory patientDimensionFactory;
    private VisitDimensionFactory visitDimensionFactory;
    private final Configuration configuration;
    private KnowledgeSourceCache cache;
    private List<? extends ProtempaEventListener> eventListeners;
    private String dataSchemaName;
    private Logger logger = I2b2ETLUtil.logger();

    I2b2QueryResultsHandler(Query query, DataSource dataSource, KnowledgeSource knowledgeSource, Configuration configuration, List<? extends ProtempaEventListener> eventListeners) throws QueryResultsHandlerInitException {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource cannot be null");
        }
        if (knowledgeSource == null) {
            throw new IllegalArgumentException("knowledgeSource cannot be null");
        }
        this.query = query;
        this.knowledgeSource = knowledgeSource;
        this.configuration = configuration;
        this.logger.log(Level.FINE, String.format("Using configuration: %s", this.configuration.getName()));
        this.logger.log(Level.FINER, "STEP: read conf.xml");
        this.settings = this.configuration.getSettings();
        this.data = this.configuration.getData();
        this.conceptsSection = this.configuration.getConcepts();
        this.database = this.configuration.getDatabase();
        DatabaseSpec dataSchemaSpec = this.database.getDataSpec();
        this.dataConnectionSpec = dataSchemaSpec != null ? dataSchemaSpec.toConnectionSpec() : null;
        DatabaseSpec metadataSchemaSpec = this.database.getMetadataSpec();
        this.metadataConnectionSpec = metadataSchemaSpec != null ? metadataSchemaSpec.toConnectionSpec() : null;
        this.providerFullNameSpec = this.data.get(this.settings.getProviderFullName());
        this.providerFirstNameSpec = this.data.get(this.settings.getProviderFirstName());
        this.providerMiddleNameSpec = this.data.get(this.settings.getProviderMiddleName());
        this.providerLastNameSpec = this.data.get(this.settings.getProviderLastName());
        this.visitPropId = this.settings.getVisitDimension();
        RemoveMethod removeMethod = this.settings.getDataRemoveMethod();
        this.dataRemoveMethod = removeMethod != null ? removeMethod : RemoveMethod.TRUNCATE;
        RemoveMethod metaRemoveMethod2 = this.settings.getMetaRemoveMethod();
        this.metaRemoveMethod = metaRemoveMethod2 != null ? metaRemoveMethod2 : RemoveMethod.TRUNCATE;
        DataSourceBackend[] dsBackends = (DataSourceBackend[])dataSource.getBackends();
        this.dataSourceBackendIds = new HashSet<String>();
        for (int i = 0; i < dsBackends.length; ++i) {
            String id = dsBackends[i].getId();
            if (id == null) continue;
            this.dataSourceBackendIds.add(id);
        }
        String sourceSystemCd = this.settings.getSourceSystemCode();
        this.qrhId = sourceSystemCd != null ? sourceSystemCd : I2B2QueryResultsHandlerSourceId.getInstance().getStringRepresentation();
        this.dataSourceBackendIds.add(this.qrhId);
        KnowledgeSourceBackend[] ksBackends = (KnowledgeSourceBackend[])knowledgeSource.getBackends();
        this.knowledgeSourceBackendIds = new HashSet<String>();
        for (int i = 0; i < ksBackends.length; ++i) {
            String id = ksBackends[i].getId();
            if (id == null) continue;
            this.knowledgeSourceBackendIds.add(id);
        }
        this.knowledgeSourceBackendIds.add(this.qrhId);
        this.eventListeners = eventListeners;
    }

    public String getId() {
        return this.qrhId;
    }

    public void start(PropositionDefinitionCache propDefs) throws QueryResultsHandlerProcessingException {
        try {
            this.conceptDimensionHandler = new ConceptDimensionHandler(this.dataConnectionSpec);
            this.modifierDimensionHandler = new ModifierDimensionHandler(this.dataConnectionSpec);
            this.cache = new KnowledgeSourceCacheFactory().getInstance(this.knowledgeSource, propDefs, true);
            this.metadata = new MetadataFactory().getInstance(propDefs, this.qrhId, this.cache, this.collectUserPropositionDefinitions(), this.conceptsSection.getFolderSpecs(), this.settings, this.data, this.metadataConnectionSpec);
            this.providerDimensionFactory = new ProviderDimensionFactory(this.metadata, this.settings, this.dataConnectionSpec);
            this.patientDimensionFactory = new PatientDimensionFactory(this.metadata, this.settings, this.data, this.dataConnectionSpec);
            this.visitDimensionFactory = new VisitDimensionFactory(this.metadata, this.settings, this.data, this.dataConnectionSpec);
            DataRemoverFactory f = new DataRemoverFactory();
            if (this.query.getQueryMode() == QueryMode.REPLACE) {
                f.getInstance(this.dataRemoveMethod).doRemoveData();
            }
            f.getInstance(this.metaRemoveMethod).doRemoveMetadata();
            this.factHandlers = new ArrayList<FactHandler>();
            this.addPropositionFactHandlers();
            this.executePreHook();
            this.disableObservationFactIndexes();
            this.truncateTempTables();
            this.dataSchemaConnection = this.openDataDatabaseConnection();
            this.dataSchemaName = this.dataSchemaConnection.getSchema();
            if (this.settings.getManageCTotalNum()) {
                try (Connection conn = this.openMetadataDatabaseConnection();){
                    conn.setAutoCommit(true);
                    try (CallableStatement mappingCall = conn.prepareCall("{ call ECMETA.EC_CLEAR_C_TOTALNUM() }");){
                        this.logger.log(Level.INFO, "Clearing C_TOTALNUM for query {0}", this.query.getName());
                        mappingCall.execute();
                    }
                }
            }
            this.logger.log(Level.INFO, "Populating observation facts table for query {0} into schema {1}", new Object[]{this.query.getName(), this.dataSchemaName});
        }
        catch (OntologyBuildException | SQLException | KnowledgeSourceReadException ex) {
            throw new QueryResultsHandlerProcessingException("Error during i2b2 load", ex);
        }
    }

    private String rejectedObservationFactTable() {
        return "EK_REJECTED_OBSERVATION_FACT";
    }

    private String tempPatientTableName() {
        return "ek_temp_patient";
    }

    private String tempPatientMappingTableName() {
        return "ek_temp_patient_mapping";
    }

    private String tempVisitTableName() {
        return "ek_temp_visit";
    }

    private String tempEncounterMappingTableName() {
        return "ek_temp_encounter_mapping";
    }

    private String tempProviderTableName() {
        return "ek_temp_provider";
    }

    private String tempConceptTableName() {
        return "ek_temp_concept";
    }

    private String tempObservationFactTableName() {
        return "ek_temp_observation";
    }

    private String tempObservationFactCompleteTableName() {
        return "ek_temp_observation_complete";
    }

    private String tempModifierTableName() {
        return "ek_temp_modifier";
    }

    private void truncateTempTables() throws SQLException {
        this.logger.log(Level.INFO, "Truncating temp data tables for query {0}", this.query.getName());
        try (Connection conn = this.openDataDatabaseConnection();){
            String[] dataschemaTables;
            conn.setAutoCommit(true);
            for (String tableName : dataschemaTables = new String[]{this.tempPatientTableName(), this.tempPatientMappingTableName(), this.tempVisitTableName(), this.tempEncounterMappingTableName(), this.tempProviderTableName(), this.tempConceptTableName(), this.tempModifierTableName(), this.tempObservationFactTableName(), this.tempObservationFactCompleteTableName()}) {
                this.truncateTable(conn, tableName);
            }
            this.logger.log(Level.INFO, "Done truncating temp data tables for query {0}", this.query.getName());
        }
    }

    public void handleQueryResult(String keyId, List<Proposition> propositions, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references) throws QueryResultsHandlerProcessingException {
        this.logger.log(Level.FINER, "Loading patient into i2b2 with props for keyId: {0} : {1}", new Object[]{keyId, propositions == null ? 0 : propositions.size()});
        try {
            HashSet<Proposition> derivedPropositions = new HashSet<Proposition>();
            PatientDimension pd = null;
            for (Proposition prop : propositions) {
                if (!prop.getId().equals(this.visitPropId)) continue;
                pd = this.handlePatient(pd, keyId, prop, references, forwardDerivations, backwardDerivations, derivedPropositions);
            }
        }
        catch (InvalidConceptCodeException | InvalidFactException | InvalidPatientRecordException | SQLException ex) {
            throw new QueryResultsHandlerProcessingException("Load into i2b2 failed for query " + this.query.getName(), (Throwable)ex);
        }
        this.logger.log(Level.FINER, "Done loading patient into i2b2");
    }

    private PatientDimension handlePatient(PatientDimension pd, String keyId, Proposition prop, Map<UniqueId, Proposition> references, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Set<Proposition> derivedPropositions) throws SQLException, InvalidConceptCodeException, InvalidFactException, InvalidPatientRecordException {
        if (pd == null) {
            pd = this.patientDimensionFactory.getInstance(keyId, prop, references);
        }
        ProviderDimension providerDimension = this.providerDimensionFactory.getInstance(prop, this.providerFullNameSpec != null ? this.providerFullNameSpec.getReferenceName() : null, this.providerFullNameSpec != null ? this.providerFullNameSpec.getPropertyName() : null, this.providerFirstNameSpec != null ? this.providerFirstNameSpec.getReferenceName() : null, this.providerFirstNameSpec != null ? this.providerFirstNameSpec.getPropertyName() : null, this.providerMiddleNameSpec != null ? this.providerMiddleNameSpec.getReferenceName() : null, this.providerMiddleNameSpec != null ? this.providerMiddleNameSpec.getPropertyName() : null, this.providerLastNameSpec != null ? this.providerLastNameSpec.getReferenceName() : null, this.providerLastNameSpec != null ? this.providerLastNameSpec.getPropertyName() : null, references);
        VisitDimension vd = this.visitDimensionFactory.getInstance(pd.getEncryptedPatientId(), pd.getEncryptedPatientIdSource(), (TemporalProposition)prop, references);
        for (FactHandler factHandler : this.factHandlers) {
            factHandler.handleRecord(pd, vd, providerDimension, prop, forwardDerivations, backwardDerivations, references, derivedPropositions);
        }
        return pd;
    }

    public void finish() throws QueryResultsHandlerProcessingException {
        SQLException exception;
        String queryId;
        block565: {
            Throwable throwable;
            ResultSet rs4;
            Throwable throwable2;
            Connection conn;
            Object countQuery;
            Throwable throwable3;
            Object call2;
            block558: {
                block557: {
                    Throwable throwable4;
                    Connection conn2;
                    Object factHandler;
                    block554: {
                        block552: {
                            block550: {
                                CallableStatement mappingCall2;
                                block546: {
                                    block544: {
                                        block543: {
                                            this.logger.log(Level.FINE, "Beginning finish for query {0}", this.query.getName());
                                            queryId = this.query.getName();
                                            exception = null;
                                            try {
                                                if (this.factHandlers != null) {
                                                    Iterator<FactHandler> itr = this.factHandlers.iterator();
                                                    while (itr.hasNext()) {
                                                        factHandler = itr.next();
                                                        ((FactHandler)((Object)factHandler)).close();
                                                        itr.remove();
                                                    }
                                                }
                                            }
                                            catch (SQLException ex) {
                                                exception = ex;
                                            }
                                            if (this.dataSchemaConnection != null) {
                                                try {
                                                    this.dataSchemaConnection.close();
                                                    this.dataSchemaConnection = null;
                                                }
                                                catch (SQLException ex) {
                                                    if (exception != null) break block543;
                                                    exception = ex;
                                                }
                                            }
                                        }
                                        if (this.patientDimensionFactory != null) {
                                            try {
                                                this.patientDimensionFactory.close();
                                                this.patientDimensionFactory = null;
                                            }
                                            catch (SQLException ex) {
                                                if (exception != null) break block544;
                                                exception = ex;
                                            }
                                        }
                                    }
                                    this.logger.log(Level.INFO, "Populating dimensions for query {0}", queryId);
                                    if (exception == null) {
                                        try {
                                            conn2 = this.openDataDatabaseConnection();
                                            factHandler = null;
                                            try {
                                                mappingCall2 = conn2.prepareCall("{ call EUREKA.EK_INSERT_PID_MAP_FROMTEMP(?, ?) }");
                                                throwable4 = null;
                                                try {
                                                    conn2.setAutoCommit(true);
                                                    this.logger.log(Level.INFO, "Populating patient dimension for query {0}", queryId);
                                                    mappingCall2.setString(1, this.tempPatientMappingTableName());
                                                    mappingCall2.setInt(2, 0);
                                                    mappingCall2.execute();
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable4 = throwable5;
                                                    throw throwable5;
                                                }
                                                finally {
                                                    if (mappingCall2 != null) {
                                                        if (throwable4 != null) {
                                                            try {
                                                                mappingCall2.close();
                                                            }
                                                            catch (Throwable throwable6) {
                                                                throwable4.addSuppressed(throwable6);
                                                            }
                                                        } else {
                                                            mappingCall2.close();
                                                        }
                                                    }
                                                }
                                            }
                                            catch (Throwable mappingCall2) {
                                                factHandler = mappingCall2;
                                                throw mappingCall2;
                                            }
                                            finally {
                                                if (conn2 != null) {
                                                    if (factHandler != null) {
                                                        try {
                                                            conn2.close();
                                                        }
                                                        catch (Throwable mappingCall2) {
                                                            ((Throwable)factHandler).addSuppressed(mappingCall2);
                                                        }
                                                    } else {
                                                        conn2.close();
                                                    }
                                                }
                                            }
                                        }
                                        catch (SQLException ex) {
                                            exception = ex;
                                        }
                                    }
                                    if (this.visitDimensionFactory != null) {
                                        try {
                                            this.visitDimensionFactory.close();
                                            this.visitDimensionFactory = null;
                                        }
                                        catch (SQLException ex) {
                                            if (exception != null) break block546;
                                            exception = ex;
                                        }
                                    }
                                }
                                if (exception == null) {
                                    try {
                                        conn2 = this.openDataDatabaseConnection();
                                        factHandler = null;
                                        try {
                                            mappingCall2 = conn2.prepareCall("{ call EUREKA.EK_INSERT_EID_MAP_FROMTEMP(?, ?) }");
                                            throwable4 = null;
                                            try {
                                                conn2.setAutoCommit(true);
                                                mappingCall2.setString(1, this.tempEncounterMappingTableName());
                                                mappingCall2.setInt(2, 0);
                                                mappingCall2.execute();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable4 = throwable7;
                                                throw throwable7;
                                            }
                                            finally {
                                                if (mappingCall2 != null) {
                                                    if (throwable4 != null) {
                                                        try {
                                                            mappingCall2.close();
                                                        }
                                                        catch (Throwable throwable8) {
                                                            throwable4.addSuppressed(throwable8);
                                                        }
                                                    } else {
                                                        mappingCall2.close();
                                                    }
                                                }
                                            }
                                        }
                                        catch (Throwable mappingCall3) {
                                            factHandler = mappingCall3;
                                            throw mappingCall3;
                                        }
                                        finally {
                                            if (conn2 != null) {
                                                if (factHandler != null) {
                                                    try {
                                                        conn2.close();
                                                    }
                                                    catch (Throwable mappingCall3) {
                                                        ((Throwable)factHandler).addSuppressed(mappingCall3);
                                                    }
                                                } else {
                                                    conn2.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (SQLException ex) {
                                        exception = ex;
                                    }
                                }
                                if (exception == null) {
                                    try {
                                        conn2 = this.openDataDatabaseConnection();
                                        factHandler = null;
                                        try {
                                            call2 = conn2.prepareCall("{ call EUREKA.EK_INS_PATIENT_FROMTEMP(?, ?) }");
                                            throwable4 = null;
                                            try {
                                                conn2.setAutoCommit(true);
                                                call2.setString(1, this.tempPatientTableName());
                                                call2.setInt(2, 0);
                                                call2.execute();
                                            }
                                            catch (Throwable throwable9) {
                                                throwable4 = throwable9;
                                                throw throwable9;
                                            }
                                            finally {
                                                if (call2 != null) {
                                                    if (throwable4 != null) {
                                                        try {
                                                            call2.close();
                                                        }
                                                        catch (Throwable throwable10) {
                                                            throwable4.addSuppressed(throwable10);
                                                        }
                                                    } else {
                                                        call2.close();
                                                    }
                                                }
                                            }
                                        }
                                        catch (Throwable call2) {
                                            factHandler = call2;
                                            throw call2;
                                        }
                                        finally {
                                            if (conn2 != null) {
                                                if (factHandler != null) {
                                                    try {
                                                        conn2.close();
                                                    }
                                                    catch (Throwable call2) {
                                                        ((Throwable)factHandler).addSuppressed(call2);
                                                    }
                                                } else {
                                                    conn2.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (SQLException ex) {
                                        exception = ex;
                                    }
                                }
                                if (exception == null) {
                                    try {
                                        conn2 = this.openDataDatabaseConnection();
                                        factHandler = null;
                                        try {
                                            call2 = conn2.prepareCall("{ call EUREKA.EK_INS_ENC_VISIT_FROMTEMP(?, ?) }");
                                            throwable4 = null;
                                            try {
                                                conn2.setAutoCommit(true);
                                                this.logger.log(Level.INFO, "Populating visit dimension for query {0}", queryId);
                                                call2.setString(1, this.tempVisitTableName());
                                                call2.setInt(2, 0);
                                                call2.execute();
                                            }
                                            catch (Throwable throwable11) {
                                                throwable4 = throwable11;
                                                throw throwable11;
                                            }
                                            finally {
                                                if (call2 != null) {
                                                    if (throwable4 != null) {
                                                        try {
                                                            call2.close();
                                                        }
                                                        catch (Throwable throwable12) {
                                                            throwable4.addSuppressed(throwable12);
                                                        }
                                                    } else {
                                                        call2.close();
                                                    }
                                                }
                                            }
                                        }
                                        catch (Throwable call3) {
                                            factHandler = call3;
                                            throw call3;
                                        }
                                        finally {
                                            if (conn2 != null) {
                                                if (factHandler != null) {
                                                    try {
                                                        conn2.close();
                                                    }
                                                    catch (Throwable call3) {
                                                        ((Throwable)factHandler).addSuppressed(call3);
                                                    }
                                                } else {
                                                    conn2.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (SQLException ex) {
                                        exception = ex;
                                    }
                                }
                                if (this.providerDimensionFactory != null) {
                                    try {
                                        this.providerDimensionFactory.close();
                                        this.providerDimensionFactory = null;
                                    }
                                    catch (SQLException ex) {
                                        if (exception != null) break block550;
                                        exception = ex;
                                    }
                                }
                            }
                            if (exception == null) {
                                try {
                                    this.logger.log(Level.INFO, "Populating provider dimension for query {0}", queryId);
                                    conn2 = this.openDataDatabaseConnection();
                                    factHandler = null;
                                    try {
                                        conn2.setAutoCommit(true);
                                        call2 = conn2.prepareCall("{ call EUREKA.EK_INS_PROVIDER_FROMTEMP(?, ?) }");
                                        throwable4 = null;
                                        try {
                                            call2.setString(1, this.tempProviderTableName());
                                            call2.setInt(2, 0);
                                            call2.execute();
                                        }
                                        catch (Throwable throwable13) {
                                            throwable4 = throwable13;
                                            throw throwable13;
                                        }
                                        finally {
                                            if (call2 != null) {
                                                if (throwable4 != null) {
                                                    try {
                                                        call2.close();
                                                    }
                                                    catch (Throwable throwable14) {
                                                        throwable4.addSuppressed(throwable14);
                                                    }
                                                } else {
                                                    call2.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (Throwable call4) {
                                        factHandler = call4;
                                        throw call4;
                                    }
                                    finally {
                                        if (conn2 != null) {
                                            if (factHandler != null) {
                                                try {
                                                    conn2.close();
                                                }
                                                catch (Throwable call4) {
                                                    ((Throwable)factHandler).addSuppressed(call4);
                                                }
                                            } else {
                                                conn2.close();
                                            }
                                        }
                                    }
                                }
                                catch (SQLException ex) {
                                    exception = ex;
                                }
                            }
                            if (exception == null) {
                                try {
                                    this.logger.log(Level.INFO, "Populating concept dimension for query {0}", this.query.getName());
                                    new ConceptDimensionLoader(this.conceptDimensionHandler).execute(this.metadata.getAllRoots());
                                }
                                catch (SQLException ex) {
                                    exception = ex;
                                }
                            }
                            if (this.conceptDimensionHandler != null) {
                                try {
                                    this.conceptDimensionHandler.close();
                                    this.conceptDimensionHandler = null;
                                }
                                catch (SQLException ex) {
                                    if (exception != null) break block552;
                                    exception = ex;
                                }
                            }
                        }
                        if (exception == null) {
                            try {
                                conn2 = this.openDataDatabaseConnection();
                                factHandler = null;
                                try {
                                    conn2.setAutoCommit(true);
                                    call2 = conn2.prepareCall("{ call EUREKA.EK_INS_CONCEPT_FROMTEMP(?, ?) }");
                                    throwable4 = null;
                                    try {
                                        call2.setString(1, this.tempConceptTableName());
                                        call2.setInt(2, 0);
                                        call2.execute();
                                    }
                                    catch (Throwable throwable15) {
                                        throwable4 = throwable15;
                                        throw throwable15;
                                    }
                                    finally {
                                        if (call2 != null) {
                                            if (throwable4 != null) {
                                                try {
                                                    call2.close();
                                                }
                                                catch (Throwable throwable16) {
                                                    throwable4.addSuppressed(throwable16);
                                                }
                                            } else {
                                                call2.close();
                                            }
                                        }
                                    }
                                }
                                catch (Throwable call5) {
                                    factHandler = call5;
                                    throw call5;
                                }
                                finally {
                                    if (conn2 != null) {
                                        if (factHandler != null) {
                                            try {
                                                conn2.close();
                                            }
                                            catch (Throwable call5) {
                                                ((Throwable)factHandler).addSuppressed(call5);
                                            }
                                        } else {
                                            conn2.close();
                                        }
                                    }
                                }
                            }
                            catch (SQLException ex) {
                                exception = ex;
                            }
                        }
                        if (exception == null) {
                            try {
                                this.logger.log(Level.INFO, "Populating modifier dimension for query {0}", this.query.getName());
                                new ModifierDimensionLoader(this.modifierDimensionHandler).execute(this.metadata.getModifierRoots());
                            }
                            catch (SQLException ex) {
                                exception = ex;
                            }
                        }
                        if (this.modifierDimensionHandler != null) {
                            try {
                                this.modifierDimensionHandler.close();
                                this.modifierDimensionHandler = null;
                            }
                            catch (SQLException ex) {
                                if (exception != null) break block554;
                                exception = ex;
                            }
                        }
                    }
                    if (exception == null) {
                        try {
                            conn2 = this.openDataDatabaseConnection();
                            factHandler = null;
                            try {
                                conn2.setAutoCommit(true);
                                call2 = conn2.prepareCall("{ call EUREKA.EK_INS_MODIFIER_FROMTEMP(?, ?) }");
                                throwable4 = null;
                                try {
                                    call2.setString(1, this.tempModifierTableName());
                                    call2.setInt(2, 0);
                                    call2.execute();
                                }
                                catch (Throwable throwable17) {
                                    throwable4 = throwable17;
                                    throw throwable17;
                                }
                                finally {
                                    if (call2 != null) {
                                        if (throwable4 != null) {
                                            try {
                                                call2.close();
                                            }
                                            catch (Throwable throwable18) {
                                                throwable4.addSuppressed(throwable18);
                                            }
                                        } else {
                                            call2.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable call6) {
                                factHandler = call6;
                                throw call6;
                            }
                            finally {
                                if (conn2 != null) {
                                    if (factHandler != null) {
                                        try {
                                            conn2.close();
                                        }
                                        catch (Throwable call6) {
                                            ((Throwable)factHandler).addSuppressed(call6);
                                        }
                                    } else {
                                        conn2.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException ex) {
                            exception = ex;
                        }
                    }
                    if (exception == null) {
                        try {
                            this.logger.log(Level.INFO, "Done populating dimensions for query {0}", queryId);
                            conn2 = this.openDataDatabaseConnection();
                            factHandler = null;
                            try {
                                conn2.setAutoCommit(true);
                                this.logger.log(Level.INFO, "Populating observation_fact from temporary table");
                                call2 = conn2.prepareCall("{ call EUREKA.EK_UPDATE_OBSERVATION_FACT(?, ?, ?, ?) }");
                                throwable4 = null;
                                try {
                                    call2.setString(1, this.tempObservationFactTableName());
                                    call2.setString(2, this.tempObservationFactCompleteTableName());
                                    call2.setLong(3, 0L);
                                    call2.setLong(4, this.query.getQueryMode() == QueryMode.UPDATE && this.settings.getMergeOnUpdate() ? 1L : 0L);
                                    call2.execute();
                                }
                                catch (Throwable throwable19) {
                                    throwable4 = throwable19;
                                    throw throwable19;
                                }
                                finally {
                                    if (call2 != null) {
                                        if (throwable4 != null) {
                                            try {
                                                call2.close();
                                            }
                                            catch (Throwable throwable20) {
                                                throwable4.addSuppressed(throwable20);
                                            }
                                        } else {
                                            call2.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable call7) {
                                factHandler = call7;
                                throw call7;
                            }
                            finally {
                                if (conn2 != null) {
                                    if (factHandler != null) {
                                        try {
                                            conn2.close();
                                        }
                                        catch (Throwable call7) {
                                            ((Throwable)factHandler).addSuppressed(call7);
                                        }
                                    } else {
                                        conn2.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException ex) {
                            exception = ex;
                        }
                    }
                    try {
                        this.enableObservationFactIndexes();
                    }
                    catch (SQLException ex) {
                        if (exception != null) break block557;
                        exception = ex;
                    }
                }
                try {
                    this.executePostHook();
                }
                catch (SQLException ex) {
                    if (exception != null) break block558;
                    exception = ex;
                }
            }
            ArrayList<String> cFullNames = new ArrayList<String>();
            if (exception == null && this.metadataConnectionSpec != null) {
                this.logger.log(Level.INFO, "Querying TABLE_ACCESS for full names");
                try {
                    Connection conn3 = this.openMetadataDatabaseConnection();
                    call2 = null;
                    try (Statement stmt2 = conn3.createStatement();){
                        throwable3 = null;
                        try (ResultSet rs2 = stmt2.executeQuery("SELECT DISTINCT C_FULLNAME FROM TABLE_ACCESS");){
                            while (rs2.next()) {
                                cFullNames.add(rs2.getString(1));
                            }
                        }
                        catch (Throwable throwable21) {
                            throwable3 = throwable21;
                            throw throwable21;
                        }
                    }
                    catch (Throwable stmt2) {
                        call2 = stmt2;
                        throw stmt2;
                    }
                    finally {
                        if (conn3 != null) {
                            if (call2 != null) {
                                try {
                                    conn3.close();
                                }
                                catch (Throwable stmt2) {
                                    ((Throwable)call2).addSuppressed(stmt2);
                                }
                            } else {
                                conn3.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
            }
            if (exception == null && !cFullNames.isEmpty()) {
                for (String cFullName : cFullNames) {
                    int count;
                    block560: {
                        this.logger.log(Level.INFO, "Getting number of records loaded for {0}", cFullName);
                        this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_START, ((Object)((Object)this)).getClass(), new Date(), "Count of " + cFullName));
                        countQuery = "SELECT count(*) FROM " + this.tempObservationFactCompleteTableName() + " obx join " + this.tempConceptTableName() + " tc ON (obx.concept_cd=tc.concept_cd) WHERE tc.concept_path like '" + cFullName + "%' AND obx.modifier_cd='@' AND obx.patient_num IS NOT NULL AND obx.encounter_num IS NOT NULL";
                        count = -1;
                        try {
                            throwable3 = null;
                            try (Connection conn4 = this.openDataDatabaseConnection();
                                 Statement stmt = conn4.createStatement();
                                 ResultSet rs3 = stmt.executeQuery((String)countQuery);){
                                if (!rs3.next()) break block560;
                                count = rs3.getInt(1);
                            }
                            catch (Throwable throwable22) {
                                throwable3 = throwable22;
                                throw throwable22;
                            }
                        }
                        catch (SQLException ex) {
                            exception = ex;
                            break;
                        }
                    }
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_STOP, ((Object)((Object)this)).getClass(), new Date(), "Count of " + cFullName));
                    if (exception == null) {
                        this.logger.log(Level.INFO, "{0} {1} record(s) loaded", new Object[]{count, cFullName});
                        this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of " + cFullName + ": " + count));
                        continue;
                    }
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of " + cFullName + ": ERROR (" + exception.getMessage() + ")"));
                }
            }
            if (exception == null) {
                this.logger.log(Level.INFO, "Getting number of patient records loaded");
                this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_START, ((Object)((Object)this)).getClass(), new Date(), "Count of patient records"));
                int count = -1;
                try {
                    conn = this.openDataDatabaseConnection();
                    countQuery = null;
                    try {
                        throwable2 = null;
                        try (Statement stmt = conn.createStatement();){
                            rs4 = stmt.executeQuery("SELECT COUNT(*) FROM " + this.tempPatientTableName());
                            throwable = null;
                            try {
                                if (rs4.next()) {
                                    count = rs4.getInt(1);
                                }
                            }
                            catch (Throwable throwable23) {
                                throwable = throwable23;
                                throw throwable23;
                            }
                            finally {
                                if (rs4 != null) {
                                    if (throwable != null) {
                                        try {
                                            rs4.close();
                                        }
                                        catch (Throwable throwable24) {
                                            throwable.addSuppressed(throwable24);
                                        }
                                    } else {
                                        rs4.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable rs4) {
                            throwable2 = rs4;
                            throw rs4;
                        }
                    }
                    catch (Throwable stmt) {
                        countQuery = stmt;
                        throw stmt;
                    }
                    finally {
                        if (conn != null) {
                            if (countQuery != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable stmt) {
                                    ((Throwable)countQuery).addSuppressed(stmt);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
                this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_STOP, ((Object)((Object)this)).getClass(), new Date(), "Count of patient records"));
                if (exception == null) {
                    this.logger.log(Level.INFO, "{0} patient record(s) loaded", count);
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of patient records: " + count));
                } else {
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of patient records: ERROR (" + exception.getMessage() + ")"));
                }
            }
            if (exception == null) {
                this.logger.log(Level.INFO, "Getting number of visit records loaded");
                this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_START, ((Object)((Object)this)).getClass(), new Date(), "Count of visit records"));
                int count = -1;
                try {
                    conn = this.openDataDatabaseConnection();
                    countQuery = null;
                    try {
                        throwable2 = null;
                        try (Statement stmt = conn.createStatement();){
                            rs4 = stmt.executeQuery("SELECT COUNT(*) FROM " + this.tempVisitTableName());
                            throwable = null;
                            try {
                                if (rs4.next()) {
                                    count = rs4.getInt(1);
                                }
                            }
                            catch (Throwable throwable25) {
                                throwable = throwable25;
                                throw throwable25;
                            }
                            finally {
                                if (rs4 != null) {
                                    if (throwable != null) {
                                        try {
                                            rs4.close();
                                        }
                                        catch (Throwable throwable26) {
                                            throwable.addSuppressed(throwable26);
                                        }
                                    } else {
                                        rs4.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable rs5) {
                            throwable2 = rs5;
                            throw rs5;
                        }
                    }
                    catch (Throwable stmt) {
                        countQuery = stmt;
                        throw stmt;
                    }
                    finally {
                        if (conn != null) {
                            if (countQuery != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable stmt) {
                                    ((Throwable)countQuery).addSuppressed(stmt);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
                this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_STOP, ((Object)((Object)this)).getClass(), new Date(), "Count of visit records"));
                if (exception == null) {
                    this.logger.log(Level.INFO, "{0} visit record(s) loaded", count);
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of visit records: " + count));
                } else {
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of visit records: ERROR (" + exception.getMessage() + ")"));
                }
            }
            if (exception == null) {
                this.logger.log(Level.INFO, "Getting number of provider records loaded");
                this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_START, ((Object)((Object)this)).getClass(), new Date(), "Count of provider records"));
                int count = -1;
                try {
                    conn = this.openDataDatabaseConnection();
                    countQuery = null;
                    try {
                        throwable2 = null;
                        try (Statement stmt = conn.createStatement();){
                            rs4 = stmt.executeQuery("SELECT COUNT(*) FROM " + this.tempProviderTableName());
                            throwable = null;
                            try {
                                if (rs4.next()) {
                                    count = rs4.getInt(1);
                                }
                            }
                            catch (Throwable throwable27) {
                                throwable = throwable27;
                                throw throwable27;
                            }
                            finally {
                                if (rs4 != null) {
                                    if (throwable != null) {
                                        try {
                                            rs4.close();
                                        }
                                        catch (Throwable throwable28) {
                                            throwable.addSuppressed(throwable28);
                                        }
                                    } else {
                                        rs4.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable rs6) {
                            throwable2 = rs6;
                            throw rs6;
                        }
                    }
                    catch (Throwable stmt) {
                        countQuery = stmt;
                        throw stmt;
                    }
                    finally {
                        if (conn != null) {
                            if (countQuery != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable stmt) {
                                    ((Throwable)countQuery).addSuppressed(stmt);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
                this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_STOP, ((Object)((Object)this)).getClass(), new Date(), "Count of provider records"));
                if (exception == null) {
                    this.logger.log(Level.INFO, "{0} provider record(s) loaded", count);
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of provider records: " + count));
                } else {
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of provider records: ERROR (" + exception.getMessage() + ")"));
                }
            }
            if (exception == null) {
                this.logger.log(Level.INFO, "Getting number of concept records loaded");
                this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_START, ((Object)((Object)this)).getClass(), new Date(), "Count of concept records"));
                int count = -1;
                try {
                    conn = this.openDataDatabaseConnection();
                    countQuery = null;
                    try {
                        throwable2 = null;
                        try (Statement stmt = conn.createStatement();){
                            rs4 = stmt.executeQuery("SELECT COUNT(*) FROM " + this.tempConceptTableName());
                            throwable = null;
                            try {
                                if (rs4.next()) {
                                    count = rs4.getInt(1);
                                }
                            }
                            catch (Throwable throwable29) {
                                throwable = throwable29;
                                throw throwable29;
                            }
                            finally {
                                if (rs4 != null) {
                                    if (throwable != null) {
                                        try {
                                            rs4.close();
                                        }
                                        catch (Throwable throwable30) {
                                            throwable.addSuppressed(throwable30);
                                        }
                                    } else {
                                        rs4.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable31) {
                            throwable2 = throwable31;
                            throw throwable31;
                        }
                    }
                    catch (Throwable stmt) {
                        countQuery = stmt;
                        throw stmt;
                    }
                    finally {
                        if (conn != null) {
                            if (countQuery != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable stmt) {
                                    ((Throwable)countQuery).addSuppressed(stmt);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
                this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_STOP, ((Object)((Object)this)).getClass(), new Date(), "Count of concept records"));
                if (exception == null) {
                    this.logger.log(Level.INFO, "{0} concept record(s) loaded", count);
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of concept records: " + count));
                } else {
                    this.fireProtempaEvent(new ProtempaEvent(ProtempaEvent.Level.INFO, ProtempaEvent.Type.QRH_STEP_RESULT, ((Object)((Object)this)).getClass(), new Date(), "Count of concept records: ERROR (" + exception.getMessage() + ")"));
                }
            }
            if (exception == null) {
                try {
                    this.logger.log(Level.INFO, "Done populating observation fact table for query {0}", queryId);
                    if (this.metadataConnectionSpec != null) {
                        this.logger.log(Level.INFO, "Populating metadata tables for query {0}", queryId);
                        String tableName = this.settings.getMetaTableName();
                        MetaTableConceptHandler metaTableHandler = new MetaTableConceptHandler(this.metadataConnectionSpec, tableName);
                        countQuery = null;
                        try {
                            MetaTableConceptLoader metaTableConceptLoader = new MetaTableConceptLoader(metaTableHandler);
                            metaTableConceptLoader.execute(this.metadata.getAllRoots());
                            this.logger.log(Level.INFO, "Done populating metadata tables for query {0}", queryId);
                            break block565;
                        }
                        catch (Throwable throwable32) {
                            countQuery = throwable32;
                            throw throwable32;
                        }
                        finally {
                            if (metaTableHandler != null) {
                                if (countQuery != null) {
                                    try {
                                        metaTableHandler.close();
                                    }
                                    catch (Throwable throwable33) {
                                        ((Throwable)countQuery).addSuppressed(throwable33);
                                    }
                                } else {
                                    metaTableHandler.close();
                                }
                            }
                        }
                    }
                    this.logger.log(Level.INFO, "Skipping metadata tables for query {0}", queryId);
                }
                catch (SQLException ex) {
                    exception = ex;
                }
            }
        }
        if (exception == null && this.settings.getManageCTotalNum()) {
            if (this.dataSchemaName != null) {
                try (Connection conn = this.openMetadataDatabaseConnection();){
                    conn.setAutoCommit(true);
                    try (CallableStatement mappingCall = conn.prepareCall("{ call ECMETA.EC_UPDATE_C_TOTALNUM(?) }");){
                        this.logger.log(Level.INFO, "Updating C_TOTALNUM for query {0}", this.query.getName());
                        mappingCall.setString(1, this.dataSchemaName);
                        mappingCall.execute();
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
            } else {
                this.logger.log(Level.WARNING, "Data schema is unknown, so could not update C_TOTALNUM");
            }
        }
        if (exception != null) {
            this.logger.log(Level.SEVERE, "Load into i2b2 failed for query " + queryId, exception);
            throw new QueryResultsHandlerProcessingException("Load into i2b2 failed for query " + queryId, (Throwable)exception);
        }
    }

    private void fireProtempaEvent(ProtempaEvent evt) {
        for (ProtempaEventListener protempaEventListener : this.eventListeners) {
            protempaEventListener.eventFired(evt);
        }
    }

    public void close() throws QueryResultsHandlerCloseException {
        if (this.factHandlers != null) {
            for (FactHandler factHandler : this.factHandlers) {
                try {
                    factHandler.close();
                }
                catch (SQLException sQLException) {}
            }
            this.factHandlers = null;
        }
        if (this.visitDimensionFactory != null) {
            try {
                this.visitDimensionFactory.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.patientDimensionFactory != null) {
            try {
                this.patientDimensionFactory.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.conceptDimensionHandler != null) {
            try {
                this.conceptDimensionHandler.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.modifierDimensionHandler != null) {
            try {
                this.modifierDimensionHandler.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.dataSchemaConnection != null) {
            try {
                this.dataSchemaConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private PropositionDefinition[] collectUserPropositionDefinitions() {
        PropositionDefinition[] allUserPropDefs = this.query.getPropositionDefinitions();
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        Set propIds = Arrays.asSet((Object[])this.query.getPropositionIds());
        for (PropositionDefinition propDef : allUserPropDefs) {
            if (!propIds.contains(propDef.getId())) continue;
            result.add(propDef);
        }
        return result.toArray(new PropositionDefinition[result.size()]);
    }

    private void addPropositionFactHandlers() throws KnowledgeSourceReadException, SQLException {
        String[] potentialDerivedPropIdsArr = this.metadata.extractDerived();
        Set<String> dimDataTypes = this.settings.getDimensionDataTypes();
        RejectedFactHandlerFactory rejectedFactHandlerFactory = new RejectedFactHandlerFactory(this.dataConnectionSpec, this.rejectedObservationFactTable());
        for (DataSpec dataSpec : this.data.getAll()) {
            if (dimDataTypes.contains(dataSpec.getKey())) continue;
            Link[] links = dataSpec.getReferenceName() != null ? new Link[]{new Reference(dataSpec.getReferenceName())} : null;
            PropositionFactHandler propFactHandler = new PropositionFactHandler(this.dataConnectionSpec, links, dataSpec.getPropertyName(), dataSpec.getStart(), dataSpec.getFinish(), dataSpec.getUnits(), potentialDerivedPropIdsArr, this.metadata, this.cache, rejectedFactHandlerFactory);
            this.factHandlers.add(propFactHandler);
        }
    }

    private void truncateTable(Connection conn, String tableName) throws SQLException {
        String queryId = this.query.getName();
        String sql = "TRUNCATE TABLE " + tableName;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Executing the following SQL for query {0}: {1}", new Object[]{queryId, sql});
        }
        try (Statement st = conn.createStatement();){
            st.execute(sql);
            this.logger.log(Level.FINE, "Done executing SQL for query {0}", queryId);
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "An error occurred truncating the tables for query " + queryId, ex);
            throw ex;
        }
    }

    private void executePreHook() throws SQLException {
        this.logger.log(Level.INFO, "Executing pre-hook");
        try (Connection conn = this.openDataDatabaseConnection();
             CallableStatement stmt = conn.prepareCall("{call EUREKA.EK_PRE_HOOK()}");){
            stmt.execute();
            this.logger.log(Level.INFO, "Pre-hook executed successfully");
        }
    }

    private void executePostHook() throws SQLException {
        this.logger.log(Level.INFO, "Executing post-hook");
        try (Connection conn = this.openDataDatabaseConnection();
             CallableStatement stmt = conn.prepareCall("{call EUREKA.EK_POST_HOOK()}");){
            stmt.execute();
            this.logger.log(Level.INFO, "Post-hook executed successfully");
        }
    }

    private void disableObservationFactIndexes() throws SQLException {
        if (this.query.getQueryMode() == QueryMode.REPLACE || !this.configuration.getSettings().getMergeOnUpdate()) {
            this.logger.log(Level.INFO, "Disabling indices on observation_fact");
            try (Connection conn = this.openDataDatabaseConnection();
                 CallableStatement stmt = conn.prepareCall("{call EUREKA.EK_DISABLE_INDEXES()}");){
                stmt.execute();
                this.logger.log(Level.INFO, "Disabled indices on observation_fact");
            }
        }
    }

    private void enableObservationFactIndexes() throws SQLException {
        if (this.query.getQueryMode() == QueryMode.REPLACE || !this.configuration.getSettings().getMergeOnUpdate()) {
            this.logger.log(Level.INFO, "Enabling indices on observation_fact");
            try (Connection conn = this.openDataDatabaseConnection();
                 CallableStatement stmt = conn.prepareCall("{call EUREKA.EK_ENABLE_INDEXES()}");){
                stmt.execute();
                this.logger.log(Level.INFO, "Enabled indices on observation_fact");
            }
        }
    }

    private Connection openDataDatabaseConnection() throws SQLException {
        return this.dataConnectionSpec.getOrCreate();
    }

    private Connection openMetadataDatabaseConnection() throws SQLException {
        return this.metadataConnectionSpec.getOrCreate();
    }

    private class TableDeleter
    extends DataRemover {
        private TableDeleter() {
        }

        @Override
        void doRemoveData() throws SQLException {
            String queryId = I2b2QueryResultsHandler.this.query.getName();
            I2b2QueryResultsHandler.this.logger.log(Level.INFO, "Deleting data tables for query {0}", queryId);
            String[] dataschemaTables = new String[]{"OBSERVATION_FACT", "CONCEPT_DIMENSION", "PATIENT_DIMENSION", "PATIENT_MAPPING", "PROVIDER_DIMENSION", "VISIT_DIMENSION", "ENCOUNTER_MAPPING", "MODIFIER_DIMENSION"};
            try (Connection conn = I2b2QueryResultsHandler.this.openDataDatabaseConnection();){
                conn.setAutoCommit(true);
                for (String tableName : dataschemaTables) {
                    this.deleteTable(conn, tableName, I2b2QueryResultsHandler.this.dataSourceBackendIds);
                }
                I2b2QueryResultsHandler.this.logger.log(Level.INFO, "Done deleting data for query {0}", queryId);
            }
        }

        @Override
        void doRemoveMetadata() throws SQLException {
            if (I2b2QueryResultsHandler.this.metadataConnectionSpec != null) {
                String queryId = I2b2QueryResultsHandler.this.query.getName();
                I2b2QueryResultsHandler.this.logger.log(Level.INFO, "Deleting metadata for query {0}", queryId);
                try (Connection conn = I2b2QueryResultsHandler.this.openMetadataDatabaseConnection();){
                    conn.setAutoCommit(true);
                    this.deleteTable(conn, I2b2QueryResultsHandler.this.settings.getMetaTableName(), I2b2QueryResultsHandler.this.knowledgeSourceBackendIds);
                    I2b2QueryResultsHandler.this.logger.log(Level.INFO, "Done deleting metadata for query {0}", queryId);
                }
            }
        }

        private void deleteTable(Connection conn, String tableName, Set<String> sourceSystemCodes) throws SQLException {
            String queryId = I2b2QueryResultsHandler.this.query.getName();
            String sql = "DELETE FROM " + tableName;
            if (sourceSystemCodes != null && !sourceSystemCodes.isEmpty()) {
                sql = sql + " WHERE SOURCESYSTEM_CD IN ('" + StringUtils.join(sourceSystemCodes, (String)"','") + "')";
            }
            if (I2b2QueryResultsHandler.this.logger.isLoggable(Level.FINE)) {
                I2b2QueryResultsHandler.this.logger.log(Level.FINE, "Executing the following SQL for query {0}: {1}", new Object[]{queryId, sql});
            }
            try (Statement st = conn.createStatement();){
                st.execute(sql);
                I2b2QueryResultsHandler.this.logger.log(Level.FINE, "Done executing SQL for query {0}", queryId);
            }
            catch (SQLException ex) {
                I2b2QueryResultsHandler.this.logger.log(Level.SEVERE, "An error occurred deleting for query " + queryId, ex);
                throw ex;
            }
        }
    }

    private class TableTruncater
    extends DataRemover {
        private TableTruncater() {
        }

        @Override
        void doRemoveData() throws SQLException {
            String queryId = I2b2QueryResultsHandler.this.query.getName();
            I2b2QueryResultsHandler.this.logger.log(Level.INFO, "Truncating data tables for query {0}", queryId);
            String[] dataschemaTables = new String[]{"OBSERVATION_FACT", "CONCEPT_DIMENSION", "PATIENT_DIMENSION", "PATIENT_MAPPING", "PROVIDER_DIMENSION", "VISIT_DIMENSION", "ENCOUNTER_MAPPING", "MODIFIER_DIMENSION"};
            try (Connection conn = I2b2QueryResultsHandler.this.openDataDatabaseConnection();){
                conn.setAutoCommit(true);
                for (String tableName : dataschemaTables) {
                    I2b2QueryResultsHandler.this.truncateTable(conn, tableName);
                }
                I2b2QueryResultsHandler.this.logger.log(Level.INFO, "Done truncating data tables for query {0}", queryId);
            }
        }

        @Override
        void doRemoveMetadata() throws SQLException {
            if (I2b2QueryResultsHandler.this.metadataConnectionSpec != null) {
                String queryId = I2b2QueryResultsHandler.this.query.getName();
                I2b2QueryResultsHandler.this.logger.log(Level.INFO, "Truncating metadata tables for query {0}", queryId);
                try (Connection conn = I2b2QueryResultsHandler.this.openMetadataDatabaseConnection();){
                    conn.setAutoCommit(true);
                    I2b2QueryResultsHandler.this.truncateTable(conn, I2b2QueryResultsHandler.this.settings.getMetaTableName());
                    I2b2QueryResultsHandler.this.logger.log(Level.INFO, "Done truncating metadata tables for query {0}", queryId);
                }
            }
        }
    }

    private class DataRemoverFactory {
        private DataRemoverFactory() {
        }

        DataRemover getInstance(RemoveMethod removeMethod) {
            switch (removeMethod) {
                case TRUNCATE: {
                    return new TableTruncater();
                }
                case DELETE: {
                    return new TableDeleter();
                }
            }
            throw new AssertionError((Object)("Unexpected remove method " + (Object)((Object)removeMethod)));
        }
    }

    private abstract class DataRemover {
        private DataRemover() {
        }

        abstract void doRemoveData() throws SQLException;

        abstract void doRemoveMetadata() throws SQLException;
    }
}

