/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;

class PathSupport {
    private Concept concept;
    private static final Logger LOGGER = Logger.getLogger(PathSupport.class.getName());
    private static final PathConceptRep SYMBOL_REP = new PathConceptRep(){

        @Override
        public String toString(Concept concept) {
            int end;
            String sym = concept.getSymbol();
            int start = 0;
            boolean modified = false;
            if (sym.charAt(start) == '\\') {
                ++start;
                modified = true;
            }
            if (sym.charAt((end = sym.length()) - 1) == '\\') {
                --end;
                modified = true;
            }
            if (modified) {
                return sym.substring(start, end);
            }
            return sym;
        }
    };
    private static final PathConceptRep DISPLAY_NAME_REP = new PathConceptRep(){

        @Override
        public String toString(Concept concept) {
            return concept.getDisplayName();
        }
    };

    PathSupport() {
    }

    public Concept getConcept() {
        return this.concept;
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
    }

    String getCPath() {
        StringBuilder buf = new StringBuilder();
        this.pathToString(buf, "\\", SYMBOL_REP);
        buf.append("\\");
        return buf.toString();
    }

    String getFullName() {
        StringBuilder buf = new StringBuilder();
        this.appendFullname(buf, "\\", SYMBOL_REP);
        buf.append("\\");
        return buf.toString();
    }

    String getToolTip() {
        StringBuilder buf = new StringBuilder();
        this.appendFullname(buf, " \\ ", DISPLAY_NAME_REP);
        return buf.toString();
    }

    int getLevel() {
        return this.concept.getLevel();
    }

    private void appendFullname(StringBuilder buf, String sep, PathConceptRep rep) {
        this.pathToString(buf, sep, rep);
        buf.append(sep);
        buf.append(rep.toString(this.concept));
    }

    private void pathToString(StringBuilder buf, String sep, PathConceptRep rep) {
        LOGGER.log(Level.FINE, "pathToString: current buf: {0}::{1}", new Object[]{buf.toString(), this.concept.getConceptCode()});
        TreeNode[] path = this.concept.getPath();
        for (int i = 0; i < path.length - 1; ++i) {
            TreeNode tn = path[i];
            buf.append(sep);
            buf.append(rep.toString((Concept)tn));
        }
        LOGGER.log(Level.FINE, "After path: {0}", new Object[]{buf.toString()});
    }

    private static interface PathConceptRep {
        public String toString(Concept var1);
    }
}

