/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata;

import edu.emory.cci.aiw.etl.util.CodeUtil;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.ConceptOperator;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.DataType;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.PathSupport;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.SynonymCode;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.ValueTypeCode;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class UserObject {
    private static final String DEFAULT_FACT_TABLE_COLUMN = "concept_cd";
    private static final String DEFAULT_TABLE_NAME = "concept_dimension";
    private static final String DEFAULT_COLUMN_NAME = "concept_path";
    private static final DataType DEFAULT_DATA_TYPE = DataType.TEXT;
    private static final int TOOL_TIP_MAX_LENGTH = 900;
    private static final int DISPLAY_NAME_MAX_LENGTH = 2000;
    private final ConceptId id;
    private final Concept concept;
    private String displayName;
    private boolean inDataSource;
    private final String conceptCode;
    private DataType dataType;
    private ValueTypeCode valueTypeCode;
    private String sourceSystemId;
    private boolean derived;
    private boolean inUse;
    private final String conceptCodePrefix;
    private String dimCode;
    private Set<String> hierarchyPaths;
    private String appliedPath;
    private String metadataXml;
    private String factTableColumn;
    private String tableName;
    private String columnName;
    private ConceptOperator operator;
    private String cVisualAttributes;
    private String comment;
    private Date downloaded;
    private final PathSupport pathSupport;
    private String fullName;
    private String cPath;
    private String toolTip;
    private int level = -1;
    private SynonymCode synonymCode;
    private boolean alreadyLoaded;
    private boolean rejected;
    private List<String> rejectionReasons;
    private String symbol;
    private Date updated;

    UserObject(ConceptId id, String conceptCodePrefix, Concept concept, Metadata metadata) throws InvalidConceptCodeException {
        assert (id != null) : "id cannot be null";
        this.id = id;
        this.concept = concept;
        this.conceptCode = id.toConceptCode(conceptCodePrefix);
        this.valueTypeCode = ValueTypeCode.UNSPECIFIED;
        this.dataType = DEFAULT_DATA_TYPE;
        this.conceptCodePrefix = conceptCodePrefix;
        this.appliedPath = "@";
        this.factTableColumn = DEFAULT_FACT_TABLE_COLUMN;
        this.tableName = DEFAULT_TABLE_NAME;
        this.columnName = DEFAULT_COLUMN_NAME;
        this.operator = this.defaultOperator();
        this.pathSupport = new PathSupport();
        this.pathSupport.setConcept(this.concept);
        this.synonymCode = SynonymCode.NOT_SYNONYM;
    }

    public String getConceptCodePrefix() {
        return this.conceptCodePrefix;
    }

    public ConceptId getId() {
        return this.id;
    }

    public String getDisplayName() {
        if (this.displayName == null || this.displayName.trim().length() == 0) {
            return this.getConceptCode();
        }
        if (this.displayName.length() <= 2000) {
            return this.displayName;
        }
        return this.displayName.substring(0, 2000);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isInDataSource() {
        return this.inDataSource;
    }

    public void setInDataSource(boolean inDataSource) {
        this.inDataSource = inDataSource;
    }

    public String getConceptCode() {
        return this.conceptCode;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId = CodeUtil.truncateCodeStringIfNeeded((String)sourceSystemId);
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public Concept getParent() {
        return (Concept)this.concept.getParent();
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType == null ? DEFAULT_DATA_TYPE : dataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setValueTypeCode(ValueTypeCode valueTypeCode) {
        this.valueTypeCode = valueTypeCode == null ? ValueTypeCode.UNSPECIFIED : valueTypeCode;
    }

    public ValueTypeCode getValueTypeCode() {
        return this.valueTypeCode;
    }

    public void setOperator(ConceptOperator operator) {
        this.operator = operator == null ? this.defaultOperator() : operator;
    }

    public ConceptOperator getOperator() {
        return this.operator;
    }

    private ConceptOperator defaultOperator() {
        if (this.isInDataSource() && !this.getDimCode().contains("_")) {
            return ConceptOperator.EQUAL;
        }
        return ConceptOperator.LIKE;
    }

    void setDimCode(String dimCode) {
        this.dimCode = dimCode;
    }

    public String getSymbol() {
        return this.getConceptCode();
    }

    public String getCPath() {
        if (this.cPath != null) {
            return this.cPath;
        }
        return this.pathSupport.getCPath();
    }

    public String getFullName() {
        if (this.fullName != null) {
            return this.fullName;
        }
        return this.pathSupport.getFullName();
    }

    public String getToolTipInt() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        return this.pathSupport.getToolTip();
    }

    public String getToolTip() {
        String toolTip = this.getToolTipInt();
        if (toolTip == null || toolTip.length() > 900) {
            toolTip = this.getDisplayName();
            if (toolTip != null && toolTip.length() > 900) {
                return toolTip.substring(0, 900);
            }
            return null;
        }
        return toolTip;
    }

    String getDimCode() {
        String result = this.dimCode;
        if (result == null) {
            result = this.getFullName();
        }
        if (result == null) {
            return "";
        }
        return result;
    }

    public String getMetadataXml() {
        return this.metadataXml;
    }

    public void setMetadataXml(String metadataXml) {
        this.metadataXml = metadataXml;
    }

    public String[] getHierarchyPaths() {
        if (this.hierarchyPaths == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return this.hierarchyPaths.toArray(new String[this.hierarchyPaths.size()]);
    }

    public void addHierarchyPath(String path) {
        if (this.hierarchyPaths == null) {
            this.hierarchyPaths = new HashSet<String>();
        }
        this.hierarchyPaths.add(path);
    }

    public void setAppliedPath(String appliedPath) {
        this.appliedPath = appliedPath == null ? "@" : appliedPath;
    }

    public String getAppliedPath() {
        return this.appliedPath;
    }

    void setFactTableColumn(String factTableColumn) {
        this.factTableColumn = factTableColumn == null ? DEFAULT_FACT_TABLE_COLUMN : factTableColumn;
    }

    String getFactTableColumn() {
        return this.factTableColumn;
    }

    void setTableName(String tableName) {
        this.tableName = tableName == null ? DEFAULT_TABLE_NAME : tableName;
    }

    String getTableName() {
        return this.tableName;
    }

    void setColumnName(String columnName) {
        this.columnName = columnName == null ? DEFAULT_COLUMN_NAME : columnName;
    }

    String getColumnName() {
        return this.columnName;
    }

    void setCVisualAttributes(String attrs) {
        this.cVisualAttributes = attrs;
    }

    String getCVisualAttributes() {
        return this.cVisualAttributes;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(Date downloaded) {
        this.downloaded = downloaded;
    }

    void setFullName(String fullName) {
        this.fullName = fullName;
    }

    void setCPath(String cPath) {
        this.cPath = cPath;
    }

    void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    void setHLevel(int level) {
        this.level = level;
    }

    int getHLevel() {
        return this.level;
    }

    void setSynonymCode(SynonymCode synonymCode) {
        this.synonymCode = synonymCode == null ? SynonymCode.NOT_SYNONYM : synonymCode;
    }

    SynonymCode getSynonymCode() {
        return this.synonymCode;
    }

    boolean isAlreadyLoaded() {
        return this.alreadyLoaded;
    }

    void setAlreadyLoaded(boolean alreadyLoaded) {
        this.alreadyLoaded = alreadyLoaded;
    }

    boolean isRejected() {
        return this.rejected;
    }

    void setRejected(boolean rejected) {
        this.rejected = rejected;
    }

    String[] getRejectionReasons() {
        if (this.rejectionReasons != null) {
            return this.rejectionReasons.toArray(new String[this.rejectionReasons.size()]);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    void addRejectionReason(String reason) {
        if (this.rejectionReasons == null) {
            this.rejectionReasons = new ArrayList<String>();
        }
        this.rejectionReasons.add(reason);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    void setUpdated(Date updated) {
        this.updated = updated;
    }

    Date getUpdated() {
        return this.updated;
    }
}

