/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.config.Data;
import edu.emory.cci.aiw.i2b2etl.dest.config.DataSpec;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;

public class DimensionFactory {
    private final Data data;

    public DimensionFactory(Data data) {
        this.data = data;
    }

    protected Data getData() {
        return this.data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Value getField(String field, Proposition encounterProp, Map<UniqueId, Proposition> references) {
        Logger logger = TableUtil.logger();
        if (field == null) return null;
        DataSpec obxSpec = this.data.get(field);
        assert (obxSpec.getPropertyName() != null) : "propertyName cannot be null";
        if (obxSpec == null) throw new AssertionError((Object)("Invalid key: " + field));
        if (obxSpec.getReferenceName() == null) return encounterProp.getProperty(obxSpec.getPropertyName());
        List uids = encounterProp.getReferences(obxSpec.getReferenceName());
        int size = uids.size();
        if (size <= 0) return null;
        if (size > 1) {
            logger.log(Level.WARNING, "Multiple propositions with {0} property found for {1}, using only the first one", new Object[]{field, encounterProp});
        }
        Proposition prop = references.get(uids.get(0));
        return prop.getProperty(obxSpec.getPropertyName());
    }
}

