/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.DefaultUnionedMetadataQueryBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.sql.DatabaseProduct;
import org.protempa.KnowledgeSourceReadException;

public final class TableAccessReader {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Logger LOGGER = Logger.getLogger(TableAccessReader.class.getName());
    private String[] ontTables;
    private final String excludeTableName;
    private final String[] ekUniqueIds;
    private final DatabaseProduct databaseProduct;

    public TableAccessReader(DatabaseProduct databaseProduct, String excludeTableName, String ... ekUniqueIds) {
        this.databaseProduct = databaseProduct;
        this.excludeTableName = excludeTableName;
        this.ekUniqueIds = (String[])ekUniqueIds.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] read(Connection connection) throws KnowledgeSourceReadException {
        TableAccessReader tableAccessReader = this;
        synchronized (tableAccessReader) {
            block86: {
                if (this.ontTables == null) {
                    Throwable throwable;
                    ResultSet resultSet2;
                    Statement stmt;
                    Throwable throwable2;
                    HashSet<String> tables = new HashSet<String>();
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT DISTINCT C_TABLE_NAME FROM TABLE_ACCESS");
                    if (this.excludeTableName != null) {
                        query.append(" WHERE C_TABLE_NAME <> ?");
                    }
                    try (PreparedStatement stmt2 = connection.prepareStatement(query.toString());){
                        stmt2.setFetchSize(10);
                        if (this.excludeTableName != null) {
                            stmt2.setString(1, this.excludeTableName);
                        }
                        throwable2 = null;
                        try (ResultSet rs = stmt2.executeQuery();){
                            while (rs.next()) {
                                tables.add(rs.getString(1));
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (SQLException ex) {
                        throw new KnowledgeSourceReadException((Throwable)ex);
                    }
                    try {
                        Iterator itr = tables.iterator();
                        while (itr.hasNext()) {
                            String tableName = (String)itr.next();
                            stmt = connection.createStatement();
                            throwable2 = null;
                            try {
                                resultSet2 = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE 1 = 0");
                                throwable = null;
                                try {
                                    ResultSetMetaData metaData = resultSet2.getMetaData();
                                    boolean found = false;
                                    int n = metaData.getColumnCount();
                                    for (int i = 1; i <= n; ++i) {
                                        if (!"EK_UNIQUE_ID".equalsIgnoreCase(metaData.getColumnLabel(i))) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    itr.remove();
                                }
                                catch (Throwable metaData) {
                                    throwable = metaData;
                                    throw metaData;
                                }
                                finally {
                                    if (resultSet2 == null) continue;
                                    if (throwable != null) {
                                        try {
                                            resultSet2.close();
                                        }
                                        catch (Throwable metaData) {
                                            throwable.addSuppressed(metaData);
                                        }
                                        continue;
                                    }
                                    resultSet2.close();
                                }
                            }
                            catch (Throwable resultSet2) {
                                throwable2 = resultSet2;
                                throw resultSet2;
                            }
                            finally {
                                if (stmt == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable resultSet2) {
                                        throwable2.addSuppressed(resultSet2);
                                    }
                                    continue;
                                }
                                stmt.close();
                            }
                        }
                    }
                    catch (SQLException ex) {
                        throw new KnowledgeSourceReadException((Throwable)ex);
                    }
                    if (this.ekUniqueIds.length > 0) {
                        try {
                            DefaultUnionedMetadataQueryBuilder builder = new DefaultUnionedMetadataQueryBuilder();
                            String subQuery = builder.statement("SELECT 1 FROM {0} WHERE EK_UNIQUE_ID IN (''" + String.join((CharSequence)"'',''", this.ekUniqueIds) + "'') AND C_FULLNAME LIKE TA.C_FULLNAME || ''%''" + (this.databaseProduct == DatabaseProduct.POSTGRESQL ? " ESCAPE ''''" : "")).ontTables(tables.toArray(new String[tables.size()])).build();
                            this.LOGGER.log(Level.FINE, "Sql for tables: {0}", "SELECT DISTINCT C_TABLE_NAME FROM TABLE_ACCESS TA WHERE EXISTS (" + subQuery + ")");
                            stmt = connection.createStatement();
                            throwable2 = null;
                            try {
                                resultSet2 = stmt.executeQuery("SELECT DISTINCT C_TABLE_NAME FROM TABLE_ACCESS TA WHERE EXISTS (" + subQuery + ")");
                                throwable = null;
                                try {
                                    resultSet2.setFetchSize(10);
                                    ArrayList<String> l = new ArrayList<String>();
                                    while (resultSet2.next()) {
                                        l.add(resultSet2.getString(1));
                                    }
                                    this.LOGGER.log(Level.FINE, "Tables are: {0}", StringUtils.join(l, (String)","));
                                    this.ontTables = l.toArray(new String[l.size()]);
                                    break block86;
                                }
                                catch (Throwable throwable4) {
                                    throwable = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (resultSet2 != null) {
                                        if (throwable != null) {
                                            try {
                                                resultSet2.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            resultSet2.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (stmt != null) {
                                    if (throwable2 != null) {
                                        try {
                                            stmt.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable2.addSuppressed(throwable7);
                                        }
                                    } else {
                                        stmt.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException ex) {
                            throw new KnowledgeSourceReadException((Throwable)ex);
                        }
                    }
                    this.ontTables = tables.toArray(new String[tables.size()]);
                }
            }
        }
        return (String[])this.ontTables.clone();
    }

    static final class TableAccessReaderBuilder {
        private String excludeTableName;
        private String[] ekUniqueIds;
        private DatabaseProduct databaseProduct;

        public TableAccessReaderBuilder(DatabaseProduct databaseProduct) {
            this.ekUniqueIds = EMPTY_STRING_ARRAY;
            this.databaseProduct = databaseProduct;
        }

        public TableAccessReaderBuilder(TableAccessReaderBuilder builder) {
            this.ekUniqueIds = (String[])builder.ekUniqueIds.clone();
            this.excludeTableName = builder.excludeTableName;
            this.databaseProduct = builder.databaseProduct;
        }

        public TableAccessReaderBuilder excludeTableName(String excludeTableName) {
            this.excludeTableName = excludeTableName;
            return this;
        }

        public TableAccessReaderBuilder restrictTablesBy(String ... ekUniqueIds) {
            this.ekUniqueIds = ekUniqueIds;
            return this;
        }

        public TableAccessReader build() {
            return new TableAccessReader(this.databaseProduct, this.excludeTableName, this.ekUniqueIds);
        }
    }
}

