package edu.emory.cci.aiw.omopetl.dest.table;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import edu.emory.cci.aiw.etl.table.AbstractRecord;
/**
 * CREATE TABLE OMOP.death
(
    person_id                   NUMBER(19)      NOT NULL ,
    death_date                  DATE            NOT NULL ,
    death_datetime              TIMESTAMP       NOT NULL ,
    death_type_concept_id       INTEGER         NOT NULL ,
    cause_concept_id            INTEGER         NOT NULL ,      
    cause_source_value          VARCHAR(50)     NOT NULL ,
    cause_source_concept_id     INTEGER         NOT NULL ,
    death_type_source_value		VARCHAR(50)		NOT NULL
);
 * @author Nita
 *
 */
public class Death extends AbstractRecord {
    
    private String personId;
    private String deathDate;
    private String deathDatetime;
    private String deathTypeConceptId;
    private String causeConceptId;
    private String causeSourceValue;
    private String causeSourceConceptId;
    private String deathTypeSourceValue;

	public String getPersonId() {
        return personId;
    }
    public void setPersonId(String personId) {
        this.personId = personId;
    }
    public String getDeathDate() {
        return deathDate;
    }
    public void setDeathDate(String deathDate) {
        this.deathDate = deathDate;
    }
    public String getDeathDatetime() {
        return deathDatetime;
    }
    public void setDeathDatetime(String deathDatetime) {
        this.deathDatetime = deathDatetime;
    }
    public String getDeathTypeConceptId() {
        return deathTypeConceptId;
    }
    public void setDeathTypeConceptId(String deathTypeConceptId) {
        this.deathTypeConceptId = deathTypeConceptId;
    }
    public String getCauseConceptId() {
        return causeConceptId;
    }
    public void setCauseConceptId(String causeConceptId) {
        this.causeConceptId = causeConceptId;
    }
    public String getCauseSourceValue() {
        return causeSourceValue;
    }
    public void setCauseSourceValue(String causeSourceValue) {
        this.causeSourceValue = causeSourceValue;
    }
    public String getCauseSourceConceptId() {
        return causeSourceConceptId;
    }
    public void setCauseSourceConceptId(String causeSourceConceptId) {
        this.causeSourceConceptId = causeSourceConceptId;
    }
    
    public String getDeathTypeSourceValue() {
		return deathTypeSourceValue;
	}
	public void setDeathTypeSourceValue(String deathTypeSourceValue) {
		this.deathTypeSourceValue = deathTypeSourceValue;
	}
    

}
