package edu.emory.cci.aiw.omopetl.dest.table;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.sql.Clob;
import java.sql.Timestamp;
import java.util.Date;

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/**
 *  * Represents records in the drug_exposure table.
 * 
 * The drug_exposure table has the following DDL:
 * <pre>
 * * CREATE TABLE OMOP.drug_exposure
(
  drug_exposure_id              NUMBER(19)    NOT NULL ,
  person_id                     NUMBER(19)    NOT NULL ,
  drug_concept_id               INTEGER       NOT NULL ,
  drug_exposure_start_date      DATE          NULL ,
  drug_exposure_start_datetime  TIMESTAMP     NOT NULL ,
  drug_exposure_end_date        DATE          NULL ,
  drug_exposure_end_datetime    TIMESTAMP     NOT NULL ,
  verbatim_end_date             DATE          NULL ,
  drug_type_concept_id          INTEGER       NOT NULL ,
  stop_reason                   VARCHAR(20)   NULL ,
  refills                       INTEGER       NULL ,
  quantity                      FLOAT         NULL ,
  days_supply                   INTEGER       NULL ,
  sig                           CLOB          NULL ,
  route_concept_id              INTEGER       NOT NULL ,
  lot_number                    VARCHAR(50)   NULL ,
  provider_id                   NUMBER(19)    NULL ,
  visit_occurrence_id           NUMBER(19)    NULL ,
  visit_detail_id               NUMBER(19)    NULL ,
  drug_source_value             VARCHAR(50)   NULL ,
  drug_source_concept_id        INTEGER       NOT NULL ,
  route_source_value            VARCHAR(50)   NULL ,
  dose_unit_source_value        VARCHAR(50)   NULL
)
*</pre>
 * @author Nita
 *
 */
public class DrugExposure extends AbstractRecord {
    
    private Long drugExposureId;
    private Long personId;
    private Integer drugConceptId;
    private Date drugExposureStartDate;
    private Timestamp drugExposureStartDatetime;
    private Date drugExposureEndDate;
    private Timestamp drugExposureEndDatetime;
    private Date verbatimEndDate;
    private Integer drugTypeConceptId;
    private String stopReason;
    private Integer refills;
    private Float quantity;
    private Integer daysSupply;
    private Clob sig;
    private Integer routeConceptId;
    private String lotNumber;
    private Long providerId;
    private Long visitOccurrenceId;
    private Long visitDetailId;;
    private String drugSourceValue;
    private Integer drugSourceConceptId;
    private String routeSourceValue;
    private String doseUnitSourceValue;
    public Long getDrugExposureId() {
        return drugExposureId;
    }
    public void setDrugExposureId(Long drugExposureId) {
        this.drugExposureId = drugExposureId;
    }
    public Long getPersonId() {
        return personId;
    }
    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public Integer getDrugConceptId() {
        return drugConceptId;
    }
    public void setDrugConceptId(Integer drugConceptId) {
        this.drugConceptId = drugConceptId;
    }
    public Date getDrugExposureStartDate() {
        return drugExposureStartDate;
    }
    public void setDrugExposureStartDate(Date drugExposureStartDate) {
        this.drugExposureStartDate = drugExposureStartDate;
    }
    public Timestamp getDrugExposureStartDatetime() {
        return drugExposureStartDatetime;
    }
    public void setDrugExposureStartDatetime(Timestamp drugExposureStartDatetime) {
        this.drugExposureStartDatetime = drugExposureStartDatetime;
    }
    public Date getDrugExposureEndDate() {
        return drugExposureEndDate;
    }
    public void setDrugExposureEndDate(Date drugExposureEndDate) {
        this.drugExposureEndDate = drugExposureEndDate;
    }
    public Timestamp getDrugExposureEndDatetime() {
        return drugExposureEndDatetime;
    }
    public void setDrugExposureEndDatetime(Timestamp drugExposureEndDatetime) {
        this.drugExposureEndDatetime = drugExposureEndDatetime;
    }
    public Date getVerbatimEndDate() {
        return verbatimEndDate;
    }
    public void setVerbatimEndDate(Date verbatimEndDate) {
        this.verbatimEndDate = verbatimEndDate;
    }
    public Integer getDrugTypeConceptId() {
        return drugTypeConceptId;
    }
    public void setDrugTypeConceptId(Integer drugTypeConceptId) {
        this.drugTypeConceptId = drugTypeConceptId;
    }
    public String getStopReason() {
        return stopReason;
    }
    public void setStopReason(String stopReason) {
        this.stopReason = stopReason;
    }
    public Integer getRefills() {
        return refills;
    }
    public void setRefills(Integer refills) {
        this.refills = refills;
    }
    public Float getQuantity() {
        return quantity;
    }
    public void setQuantity(Float quantity) {
        this.quantity = quantity;
    }
    public Integer getDaysSupply() {
        return daysSupply;
    }
    public void setDaysSupply(Integer daysSupply) {
        this.daysSupply = daysSupply;
    }
    public Clob getSig() {
        return sig;
    }
    public void setSig(Clob sig) {
        this.sig = sig;
    }
    public Integer getRouteConceptId() {
        return routeConceptId;
    }
    public void setRouteConceptId(Integer routeConceptId) {
        this.routeConceptId = routeConceptId;
    }
    public String getLotNumber() {
        return lotNumber;
    }
    public void setLotNumber(String lotNumber) {
        this.lotNumber = lotNumber;
    }
    public Long getProviderId() {
        return providerId;
    }
    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }
    public Long getVisitOccurrenceId() {
        return visitOccurrenceId;
    }
    public void setVisitOccurrenceId(Long visitOccurrenceId) {
        this.visitOccurrenceId = visitOccurrenceId;
    }
    public Long getVisitDetailId() {
        return visitDetailId;
    }
    public void setVisitDetailId(Long visitDetailId) {
        this.visitDetailId = visitDetailId;
    }
    public String getDrugSourceValue() {
        return drugSourceValue;
    }
    public void setDrugSourceValue(String drugSourceValue) {
        this.drugSourceValue = drugSourceValue;
    }
    public Integer getDrugSourceConceptId() {
        return drugSourceConceptId;
    }
    public void setDrugSourceConceptId(Integer drugSourceConceptId) {
        this.drugSourceConceptId = drugSourceConceptId;
    }
    public String getRouteSourceValue() {
        return routeSourceValue;
    }
    public void setRouteSourceValue(String routeSourceValue) {
        this.routeSourceValue = routeSourceValue;
    }
    public String getDoseUnitSourceValue() {
        return doseUnitSourceValue;
    }
    public void setDoseUnitSourceValue(String doseUnitSourceValue) {
        this.doseUnitSourceValue = doseUnitSourceValue;
    }
   
    

}
