package edu.emory.cci.aiw.omopetl.dest.table;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.sql.Timestamp;
import java.util.Date;

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/**
 *  Represents records in the visit_occurrence table.
 * 
 * The visit_occurrence table has the following DDL:
 *  <pre>
 * CREATE TABLE OMOP.procedure_occurrence
(
  procedure_occurrence_id       NUMBER(19)      NOT NULL ,
  person_id                     NUMBER(19)      NOT NULL ,
  procedure_concept_id          INTEGER         NOT NULL ,
  procedure_date                DATE            NULL ,
  procedure_datetime            TIMESTAMP       NOT NULL ,
  procedure_type_concept_id     INTEGER         NOT NULL ,
  modifier_concept_id           INTEGER         NOT NULL ,
  quantity                      INTEGER         NULL ,
  provider_id                   NUMBER(19)      NULL ,
  visit_occurrence_id           NUMBER(19)      NULL ,
  visit_detail_id               NUMBER(19)      NULL ,
  procedure_source_value        VARCHAR(50)     NULL ,
  procedure_source_concept_id   INTEGER         NOT NULL ,
  modifier_source_value         VARCHAR(50)     NULL 
)
 * </pre>
 * @author Nita
 *
 */

public class ProcedureOccurrence extends AbstractRecord {
    
    private Long procedureOccurrenceId;
    private Long personId;
    private Integer procedureConceptId;
    private Date procedureDate;
    private Timestamp procedureDatetime;
    private Integer procedureTypeConceptId;
    private Integer modifierConceptId;
    private Integer quantity;
    private Long providerId;
    private Long visitOccurrenceId;
    private Long visitDetailId;
    private String procedureSourceValue;
    private Integer procedureSourceConceptId;
    private String modifierSourceValue;
    public Long getProcedureOccurrenceId() {
        return procedureOccurrenceId;
    }
    public void setProcedureOccurrenceId(Long procedureOccurrenceId) {
        this.procedureOccurrenceId = procedureOccurrenceId;
    }
    public Long getPersonId() {
        return personId;
    }
    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public Integer getProcedureConceptId() {
        return procedureConceptId;
    }
    public void setProcedureConceptId(Integer procedureConceptId) {
        this.procedureConceptId = procedureConceptId;
    }
    public Date getProcedureDate() {
        return procedureDate;
    }
    public void setProcedureDate(Date procedureDate) {
        this.procedureDate = procedureDate;
    }
    public Timestamp getProcedureDatetime() {
        return procedureDatetime;
    }
    public void setProcedureDatetime(Timestamp procedureDatetime) {
        this.procedureDatetime = procedureDatetime;
    }
    public Integer getProcedureTypeConceptId() {
        return procedureTypeConceptId;
    }
    public void setProcedureTypeConceptId(Integer procedureTypeConceptId) {
        this.procedureTypeConceptId = procedureTypeConceptId;
    }
    public Integer getModifierConceptId() {
        return modifierConceptId;
    }
    public void setModifierConceptId(Integer modifierConceptId) {
        this.modifierConceptId = modifierConceptId;
    }
    public Integer getQuantity() {
        return quantity;
    }
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
    public Long getProviderId() {
        return providerId;
    }
    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }
    public Long getVisitOccurrenceId() {
        return visitOccurrenceId;
    }
    public void setVisitOccurrenceId(Long visitOccurrenceId) {
        this.visitOccurrenceId = visitOccurrenceId;
    }
    public Long getVisitDetailId() {
        return visitDetailId;
    }
    public void setVisitDetailId(Long visitDetailId) {
        this.visitDetailId = visitDetailId;
    }
    public String getProcedureSourceValue() {
        return procedureSourceValue;
    }
    public void setProcedureSourceValue(String procedureSourceValue) {
        this.procedureSourceValue = procedureSourceValue;
    }
    public Integer getProcedureSourceConceptId() {
        return procedureSourceConceptId;
    }
    public void setProcedureSourceConceptId(Integer procedureSourceConceptId) {
        this.procedureSourceConceptId = procedureSourceConceptId;
    }
    public String getModifierSourceValue() {
        return modifierSourceValue;
    }
    public void setModifierSourceValue(String modifierSourceValue) {
        this.modifierSourceValue = modifierSourceValue;
    }
    
    

}
