package edu.emory.cci.aiw.omopetl.dest.table;

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Represents records in the location table.
 * 
 * The location table has the following DDL:
 * <pre>
 * CREATE TABLE OMOP.location
(
  location_id           NUMBER(19)      NOT NULL ,
  address_1             VARCHAR(50)     NULL ,
  address_2             VARCHAR(50)     NULL ,
  city                  VARCHAR(50)     NULL ,
  state                 VARCHAR(2)      NULL ,
  zip                   VARCHAR(9)      NULL ,
  county                VARCHAR(20)     NULL ,
  country               VARCHAR(100)    NULL ,
  location_source_value VARCHAR(50)     NULL ,
  latitude              FLOAT           NULL ,
  longitude             FLOAT           NULL
)
 * </pre>
 * @author Nita
 *
 */
public class Location extends AbstractRecord {
    
    private Long locationId;
    private String address1;
    private String address2;
    private String city;
    private String state;
    private String zip;
    private String county;
    private String country;
    private String locationSourceValue;
    private Float latitude;
    private Float longitude;
    
    public Long getLocationId() {
        return locationId;
    }
    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }
    public String getAddress1() {
        return address1;
    }
    public void setAddress1(String address1) {
        this.address1 = address1;
    }
    public String getAddress2() {
        return address2;
    }
    public void setAddress2(String address2) {
        this.address2 = address2;
    }
    public String getCity() {
        return city;
    }
    public void setCity(String city) {
        this.city = city;
    }
    public String getState() {
        return state;
    }
    public void setState(String state) {
        this.state = state;
    }
    public String getZip() {
        return zip;
    }
    public void setZip(String zip) {
        this.zip = zip;
    }
    public String getCounty() {
        return county;
    }
    public void setCounty(String county) {
        this.county = county;
    }
    public String getCountry() {
        return country;
    }
    public void setCountry(String country) {
        this.country = country;
    }
    public String getLocationSourceValue() {
        return locationSourceValue;
    }
    public void setLocationSourceValue(String locationSourceValue) {
        this.locationSourceValue = locationSourceValue;
    }
    public Float getLatitude() {
        return latitude;
    }
    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }
    public Float getLongitude() {
        return longitude;
    }
    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }
    
    
}
