package edu.emory.cci.aiw.omopetl.dest.table;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.sql.Timestamp;
import java.util.Date;

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/**
 * Represents records in the measurement table.
 * 
 * The measurement table has the following DDL:
 * <pre>
 * CREATE TABLE OMOP.measurement
(
  measurement_id                NUMBER(19)  NOT NULL ,
  person_id                     NUMBER(19)  NOT NULL ,
  measurement_concept_id        INTEGER     NOT NULL ,
  measurement_date              DATE        NULL ,
  measurement_datetime          TIMESTAMP   NOT NULL ,
  measurement_time              VARCHAR(10) NULL,
  measurement_type_concept_id   INTEGER     NOT NULL ,
  operator_concept_id           INTEGER     NULL ,
  value_as_number               FLOAT       NULL ,
  value_as_concept_id           INTEGER     NULL ,
  unit_concept_id               INTEGER     NULL ,
  range_low                     FLOAT       NULL ,
  range_high                    FLOAT       NULL ,
  provider_id                   NUMBER(19)  NULL ,
  visit_occurrence_id           NUMBER(19)  NULL ,
  visit_detail_id               NUMBER(19)  NULL ,
  measurement_source_value      VARCHAR(50) NULL ,
  measurement_source_concept_id INTEGER     NOT NULL ,
  unit_source_value             VARCHAR(50) NULL ,
  value_source_value            VARCHAR(50) NULL
)
 * </pre>
 * @author Nita
 *
 */
public class Measurement extends AbstractRecord{
    private Long measurementId;
    private Long personId;
    private Integer measurementConceptId;
    private Date measurementDate;
    private Timestamp measurementDatetime;
    private String measurementTime;
    private Integer measurementTypeConceptId;
    private Integer operatorConceptId;
    private Float valueAsNumber;
    private Integer valueAsConceptId;
    private Integer unitConceptId;
    private Float rangeLow;
    private Float rangeHigh;
    private Long providerId;
    private Long visitOccurrenceId;
    private Long visitDetailId;
    private String measurementSourceValue;
    private Integer measurementSourceConceptId;
    private String unitSourceValue;
    private String valueSourceValue;
    
    public Long getMeasurementId() {
        return measurementId;
    }
    public void setMeasurementId(Long measurementId) {
        this.measurementId = measurementId;
    }
    public Long getPersonId() {
        return personId;
    }
    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public Integer getMeasurementConceptId() {
        return measurementConceptId;
    }
    public void setMeasurementConceptId(Integer measurementConceptId) {
        this.measurementConceptId = measurementConceptId;
    }
    public Date getMeasurementDate() {
        return measurementDate;
    }
    public void setMeasurementDate(Date measurementDate) {
        this.measurementDate = measurementDate;
    }
    public Timestamp getMeasurementDatetime() {
        return measurementDatetime;
    }
    public void setMeasurementDatetime(Timestamp measurementDatetime) {
        this.measurementDatetime = measurementDatetime;
    }
    public String getMeasurementTime() {
        return measurementTime;
    }
    public void setMeasurementTime(String measurementTime) {
        this.measurementTime = measurementTime;
    }
    public Integer getMeasurementTypeConceptId() {
        return measurementTypeConceptId;
    }
    public void setMeasurementTypeConceptId(Integer measurementTypeConceptId) {
        this.measurementTypeConceptId = measurementTypeConceptId;
    }
    public Integer getOperatorConceptId() {
        return operatorConceptId;
    }
    public void setOperatorConceptId(Integer operatorConceptId) {
        this.operatorConceptId = operatorConceptId;
    }
    public Float getValueAsNumber() {
        return valueAsNumber;
    }
    public void setValueAsNumber(Float valueAsNumber) {
        this.valueAsNumber = valueAsNumber;
    }
    public Integer getValueAsConceptId() {
        return valueAsConceptId;
    }
    public void setValueAsConceptId(Integer valueAsConceptId) {
        this.valueAsConceptId = valueAsConceptId;
    }
    public Integer getUnitConceptId() {
        return unitConceptId;
    }
    public void setUnitConceptId(Integer unitConceptId) {
        this.unitConceptId = unitConceptId;
    }
    public Float getRangeLow() {
        return rangeLow;
    }
    public void setRangeLow(Float rangeLow) {
        this.rangeLow = rangeLow;
    }
    public Float getRangeHigh() {
        return rangeHigh;
    }
    public void setRangeHigh(Float rangeHigh) {
        this.rangeHigh = rangeHigh;
    }
    public Long getProviderId() {
        return providerId;
    }
    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }
    public Long getVisitOccurrenceId() {
        return visitOccurrenceId;
    }
    public void setVisitOccurrenceId(Long visitOccurrenceId) {
        this.visitOccurrenceId = visitOccurrenceId;
    }
    public Long getVisitDetailId() {
        return visitDetailId;
    }
    public void setVisitDetailId(Long visitDetailId) {
        this.visitDetailId = visitDetailId;
    }
    public String getMeasurementSourceValue() {
        return measurementSourceValue;
    }
    public void setMeasurementSourceValue(String measurementSourceValue) {
        this.measurementSourceValue = measurementSourceValue;
    }
    public Integer getMeasurementSourceConceptId() {
        return measurementSourceConceptId;
    }
    public void setMeasurementSourceConceptId(Integer measurementSourceConceptId) {
        this.measurementSourceConceptId = measurementSourceConceptId;
    }
    public String getUnitSourceValue() {
        return unitSourceValue;
    }
    public void setUnitSourceValue(String unitSourceValue) {
        this.unitSourceValue = unitSourceValue;
    }
    public String getValueSourceValue() {
        return valueSourceValue;
    }
    public void setValueSourceValue(String valueSourceValue) {
        this.valueSourceValue = valueSourceValue;
    }
    
    
}
