package edu.emory.cci.aiw.omopetl.dest.table;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.logging.Logger;

/**
 *
 * @author Nita
 */
public class OmopTableHandler {

	private static final Logger LOGGER = Logger.getLogger(OmopTableHandler.class.getName());
    private String insertStatement;
    
    
	
	public OmopTableHandler() {
		super();
		LOGGER.info("Constructing OmopTableHandler");
	}

	public String getInsertStatement(String tableName) {
		switch(tableName) {
		case "address":
			insertStatement =  "insert into address_temp (person_id,location_id) values (?,?)";
			break;
		case "care_site":
			insertStatement =  "insert into care_site_temp "
					+ "(care_site_id, care_site_name, place_of_service_concept_id, "
            		+ "location_id, care_site_source_value, place_of_service_source_value) "
            		+ "values (?,?,?,?,?,?)";
			break;
		case "condition_occurrence":
			insertStatement = "insert into condition_occurrence_temp "
					+ "(condition_occurrence_id, person_id, condition_concept_id, "
					+ "condition_start_date, condition_start_datetime, condition_end_date, "
            		+ "condition_end_datetime, condition_type_concept_id, "
            		+ "stop_reason, provider_id, visit_occurrence_id, "
            		+ "condition_source_value, condition_source_concept_id, "
            		+ "condition_status_source_value, condition_status_concept_id, condition_code_source_value) "
            		+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			break;
		case "death":
			insertStatement = "insert into death_temp "
					+ "(person_id, death_date, death_datetime, "
					+ "death_type_concept_id, cause_concept_id, cause_source_value, "
					+ "cause_source_concept_id, death_type_source_value) "
					+ "values (?,?,?,?,?,?,?,?)";
			break;
		case "drug_exposure":
			insertStatement = "insert into drug_exposure_temp "
					+ "(drug_exposure_id, person_id, drug_concept_id, "
					+ "drug_exposure_start_date, drug_exposure_start_datetime, drug_exposure_end_date, "
					+ "drug_exposure_end_datetime, verbatim_end_date, drug_type_concept_id, "
					+ "stop_reason, refills, quantity, "
					+ "days_supply, sig, route_concept_id, "
					+ "lot_number, provider_id, visit_occurrence_id, "
					+ "drug_source_value, drug_code_type_source_value, drug_source_concept_id, "
					+ "route_source_value, dose_unit_source_value, duration_code) "
					+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			break;
		case "email":
			insertStatement = "insert into email_temp (person_id, email, email_type) values (?,?,?)";
			break;
		case "location":
			insertStatement = "insert into location_temp "
					+ "(location_id, address_1, address_2, "
					+ "city, state, zip, county, "
					+ "location_source_value) "
					+ "values (?,?,?,?,?,?,?,?)";
			break;
		case "measurement":
			insertStatement = "insert into measurement_temp "
					+ "(measurement_id, person_id, measurement_concept_id, "
					+ "measurement_date, measurement_datetime, measurement_type_concept_id, "
					+ "operator_concept_id, value_as_number, value_as_concept_id, "
					+ "unit_concept_id, range_low, range_high, "
					+ "provider_id, visit_occurrence_id, measurement_source_value, "
					+ "measurement_source_concept_id, unit_source_value, value_source_value, "
					+ "operator_concept_source_value) "
					+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			break;
		case "mrn":
			insertStatement = "insert into mrn_temp (person_id, health_system, mrn) values (?,?,?)";
			break;
		case "name":
			insertStatement = "insert into name_temp "
					+ "(person_id, first_name, middle_name, "
					+ "last_name, suffix, prefix) "
					+ "values (?,?,?,?,?,?)"; 
			break;
		case "person":
			insertStatement = "insert into person_temp "
					+ "(person_id, gender_concept_id, year_of_birth, "
					+ "month_of_birth, day_of_birth, birth_datetime, "
					+ "race_concept_id, ethnicity_concept_id, location_id, "
					+ "provider_id, care_site_id, person_source_value, "
					+ "gender_source_value, gender_source_concept_id, race_source_value, "
					+ "race_source_concept_id, ethnicity_source_value, ethnicity_source_concept_id) "
					+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			break;
		case "phone_number":
			insertStatement = "insert into phone_number_temp (person_id, phone_number, phone_type) values (?,?,?)";
			break;
		case "procedure_occurrence":
			insertStatement = "insert into procedure_occurrence_temp "
					+ "(procedure_occurrence_id, person_id, procedure_concept_id, "
					+ "procedure_date, procedure_datetime, procedure_type_concept_id, "
					+ "modifier_concept_id, quantity, provider_id, "
					+ "visit_occurrence_id, procedure_source_value, code_type_source_value, "
					+ "procedure_source_concept_id, qualifier_source_value) "
					+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			break;
		case "provider":
			insertStatement = "insert into provider_temp "
					+ "(provider_id, provider_name, NPI, "
					+ "DEA, specialty_concept_id, care_site_id, "
					+ "year_of_birth, gender_concept_id, provider_source_value, "
					+ "specialty_source_value, specialty_source_concept_id, gender_source_value, "
					+ "gender_source_concept_id) "
					+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
			break;
		case "visit_occurrence":
			insertStatement = "insert into visit_occurrence_temp "
					+ "(visit_occurrence_id, person_id, visit_concept_id, "
					+ "visit_start_date, visit_start_datetime, visit_end_date, "
					+ "visit_end_datetime, visit_type_concept_id, provider_id, "
					+ "care_site_id, visit_source_value, visit_source_concept_id, "
					+ "admitting_source_concept_id, admitting_source_value, discharge_to_concept_id, "
					+ "discharge_to_source_value, preceding_visit_occurrence_id) "
					+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			break;
		}
		return insertStatement;
	}
	
	public void setInsertStatement(String insertStatement) {
		this.insertStatement = insertStatement;
	}

    
}
