/*
 * #%L
 * AIW i2b2 ETL
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package edu.emory.cci.aiw.omopetl.dest.table;

import java.sql.Timestamp;
import java.util.Date;

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/**
 * Represents records in the visit_occurrence table.
 * 
 * The visit_occurrence table has the following DDL:
 * <pre>
CREATE TABLE OMOP.visit_occurrence
(
  visit_occurrence_id           NUMBER(19)  NOT NULL ,
  person_id                     NUMBER(19)  NOT NULL ,
  visit_concept_id              INTEGER     NOT NULL ,
  visit_start_date              DATE        NULL ,
  visit_start_datetime          TIMESTAMP   NOT NULL ,
  visit_end_date                DATE        NULL ,
  visit_end_datetime            TIMESTAMP   NOT NULL ,
  visit_type_concept_id         INTEGER     NOT NULL ,
  provider_id                   NUMBER(19)  NULL,
  care_site_id                  NUMBER(19)  NULL,
  visit_source_value            VARCHAR(50) NULL,
  visit_source_concept_id       INTEGER     NOT NULL ,
  admitted_from_concept_id      INTEGER     NOT NULL ,   
  admitted_from_source_value    VARCHAR(50) NULL ,
  discharge_to_source_value     VARCHAR(50) NULL ,
  discharge_to_concept_id       INTEGER     NOT NULL ,
  preceding_visit_occurrence_id NUMBER(19)  NULL
)
 * </pre>
 * 
 * @author Nita Deshpande
 */
public class VisitOccurrence extends AbstractRecord {

    private Long visitOccurrenceId;
    private Long personId;
    private Integer visitConceptId;
    private Date visitStartDate;
    private Timestamp visitStartDatetime;
    private Date visitEndDate;
    private Timestamp visitEndDatetime;
    private Integer visitTypeConceptId;
    private Long providerId;
    private Long careSiteId;
    private String visitSourceValue;
    private Integer visitSourceConceptId;
    private Integer admittedFromConceptId;
    private String admittedFromSourceValue;
    private String dischargeToSourceValue;
    private Integer dischargeToConceptId;
    private Long precedingVisitOccurrenceId;
    
    
    public Long getVisitOccurrenceId() {
        return visitOccurrenceId;
    }
    public void setVisitOccurrenceId(Long visitOccurrenceId) {
        this.visitOccurrenceId = visitOccurrenceId;
    }
    public Long getPersonId() {
        return personId;
    }
    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public Integer getVisit_conceptId() {
        return visitConceptId;
    }
    public void setVisit_conceptId(Integer visitConceptId) {
        this.visitConceptId = visitConceptId;
    }
    public Date getVisitStartDate() {
        return visitStartDate;
    }
    public void setVisitStartDate(Date visitStartDate) {
        this.visitStartDate = visitStartDate;
    }
    public Timestamp getVisitStartDatetime() {
        return visitStartDatetime;
    }
    public void setVisitStartDatetime(Timestamp visitStartDatetime) {
        this.visitStartDatetime = visitStartDatetime;
    }
    public Date getVisitEndDate() {
        return visitEndDate;
    }
    public void setVisitEndDate(Date visitEndDate) {
        this.visitEndDate = visitEndDate;
    }
    public Timestamp getVisitEndDatetime() {
        return visitEndDatetime;
    }
    public void setVisitEndDatetime(Timestamp visitEndDatetime) {
        this.visitEndDatetime = visitEndDatetime;
    }
    public Integer getVisitTypeConceptId() {
        return visitTypeConceptId;
    }
    public void setVisitTypeConceptId(Integer visitTypeConceptId) {
        this.visitTypeConceptId = visitTypeConceptId;
    }
    public Long getProviderId() {
        return providerId;
    }
    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }
    public Long getCareSiteId() {
        return careSiteId;
    }
    public void setCareSiteId(Long careSiteId) {
        this.careSiteId = careSiteId;
    }
    public String getVisitSourceValue() {
        return visitSourceValue;
    }
    public void setVisitSourceValue(String visitSourceValue) {
        this.visitSourceValue = visitSourceValue;
    }
    public Integer getVisitSourceConceptId() {
        return visitSourceConceptId;
    }
    public void setVisitSourceConceptId(Integer visitSourceConceptId) {
        this.visitSourceConceptId = visitSourceConceptId;
    }
    public Integer getAdmittedFromConceptId() {
        return admittedFromConceptId;
    }
    public void setAdmittedFromConceptId(Integer admittedFromConceptId) {
        this.admittedFromConceptId = admittedFromConceptId;
    }
    public String getAdmittedFromSourceValue() {
        return admittedFromSourceValue;
    }
    public void setAdmittedFromSourceValue(String admittedFromSourceValue) {
        this.admittedFromSourceValue = admittedFromSourceValue;
    }
    public String getDischargeToSourceValue() {
        return dischargeToSourceValue;
    }
    public void setDischargeToSourceValue(String dischargeToSourceValue) {
        this.dischargeToSourceValue = dischargeToSourceValue;
    }
    public Integer getDischargeToConceptId() {
        return dischargeToConceptId;
    }
    public void setDischargeToConceptId(Integer dischargeToConceptId) {
        this.dischargeToConceptId = dischargeToConceptId;
    }
    public Long getPrecedingVisitOccurrenceId() {
        return precedingVisitOccurrenceId;
    }
    public void setPrecedingVisitOccurrenceId(Long precedingVisitOccurrenceId) {
        this.precedingVisitOccurrenceId = precedingVisitOccurrenceId;
    }
    
}
