package edu.emory.cci.aiw.omopetl.dest.table;

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Represents records in the care_site table.
 * 
 * The care_site table has the following DDL:
 * <pre>
 * CREATE TABLE OMOP.care_site
(
  care_site_id                  NUMBER(19)    NOT NULL ,
  care_site_name                VARCHAR(255)  NULL ,
  place_of_service_concept_id   INTEGER       NOT NULL ,
  location_id                   NUMBER(19)    NULL ,
  care_site_source_value        VARCHAR(50)   NULL ,
  place_of_service_source_value VARCHAR(50)   NULL
)
 * </pre>
 * @author Nita
 *
 */

public class CareSite extends AbstractRecord {

    private String careSiteId;
    private String careSiteName;
    private String placeOfServiceConceptId;
    private String locationId;
    private String careSiteSourceValue;
    private String placeOfServiceSourceValue;
    
    public String getCareSiteId() {
        return careSiteId;
    }
    public void setCareSiteId(String careSiteId) {
        this.careSiteId = careSiteId;
    }
    public String getCareSiteName() {
        return careSiteName;
    }
    public void setCareSiteName(String careSiteName) {
        this.careSiteName = careSiteName;
    }
    public String getPlaceOfServiceConceptId() {
        return placeOfServiceConceptId;
    }
    public void setPlaceOfServiceConceptId(String placeOfServiceConceptId) {
        this.placeOfServiceConceptId = placeOfServiceConceptId;
    }
    public String getLocationId() {
        return locationId;
    }
    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }
    public String getCareSiteSourceValue() {
        return careSiteSourceValue;
    }
    public void setCareSiteSourceValue(String careSiteSourceValue) {
        this.careSiteSourceValue = careSiteSourceValue;
    }
    public String getPlaceOfServiceSourceValue() {
        return placeOfServiceSourceValue;
    }
    public void setPlaceOfServiceSourceValue(String placeOfServiceSourceValue) {
        this.placeOfServiceSourceValue = placeOfServiceSourceValue;
    }
    
    
}
