package edu.emory.cci.aiw.omopetl.dest.table;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/**
 * Represents records in the condition_occurrence table.
 * 
 * The condition_occurrence table has the following DDL:
 * <pre>
 * CREATE TABLE OMOP.condition_occurrence
(
  condition_occurrence_id       NUMBER(19)      NOT NULL ,
  person_id                     NUMBER(19)      NOT NULL ,
  condition_concept_id          String         NOT NULL ,
  condition_start_date          DATE            NULL ,
  condition_start_datetime      TIMESTAMP       NOT NULL ,
  condition_end_date            DATE            NULL ,
  condition_end_datetime        TIMESTAMP       NULL ,
  condition_type_concept_id     String         NOT NULL ,
  condition_status_concept_id   String         NOT NULL ,
  stop_reason                   VARCHAR(20)     NULL ,
  provider_id                   NUMBER(19)      NULL ,
  visit_occurrence_id           NUMBER(19)      NULL ,
  visit_detail_id               NUMBER(19)      NULL ,
  condition_source_value        VARCHAR(50)     NULL ,
  condition_source_concept_id   String         NOT NULL ,
  condition_status_source_value VARCHAR(50)     NULL
)
 * </pre>
 * @author Nita
 *
 */
public class ConditionOccurrence extends AbstractRecord {
    
    private String conditionOccurrenceId;
    private String personId;
    private String conditionConceptId;
    private String conditionStartDate;
    private String conditionStartDatetime;
    private String conditionEndDate;
    private String conditionEndDatetime;
    private String conditionTypeConceptId;
    private String conditionStatusConceptId;
    private String stopReason;
    private String providerId;
    private String visitOccurrenceId;
    private String visitDetailId;
    private String conditionSourceValue;
    private String conditionSourceConceptId;
    private String conditionStatusSourceValue;
    private String conditionCodeSourceValue;
    

	public String getConditionOccurrenceId() {
        return conditionOccurrenceId;
    }
    public void setConditionOccurrenceId(String conditionOccurrenceId) {
        this.conditionOccurrenceId = conditionOccurrenceId;
    }
    public String getPersonId() {
        return personId;
    }
    public void setPersonId(String personId) {
        this.personId = personId;
    }
    public String getConditionConceptId() {
        return conditionConceptId;
    }
    public void setConditionConceptId(String conditionConceptId) {
        this.conditionConceptId = conditionConceptId;
    }
    public String getConditionStartDate() {
        return conditionStartDate;
    }
    public void setConditionStartDate(String conditionStartDate) {
        this.conditionStartDate = conditionStartDate;
    }
    public String getConditionStartDatetime() {
        return conditionStartDatetime;
    }
    public void setConditionStartDatetime(String conditionStartDatetime) {
        this.conditionStartDatetime = conditionStartDatetime;
    }
    public String getConditionEndDate() {
        return conditionEndDate;
    }
    public void setConditionEndDate(String conditionEndDate) {
        this.conditionEndDate = conditionEndDate;
    }
    public String getConditionEndDatetime() {
        return conditionEndDatetime;
    }
    public void setConditionEndDatetime(String conditionEndDatetime) {
        this.conditionEndDatetime = conditionEndDatetime;
    }
    public String getConditionTypeConceptId() {
        return conditionTypeConceptId;
    }
    public void setConditionTypeConceptId(String conditionTypeConceptId) {
        this.conditionTypeConceptId = conditionTypeConceptId;
    }
    public String getConditionStatusConceptId() {
        return conditionStatusConceptId;
    }
    public void setConditionStatusConceptId(String conditionStatusConceptId) {
        this.conditionStatusConceptId = conditionStatusConceptId;
    }
    public String getStopReason() {
        return stopReason;
    }
    public void setStopReason(String stopReason) {
        this.stopReason = stopReason;
    }
    public String getProviderId() {
        return providerId;
    }
    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }
    public String getVisitOccurrenceId() {
        return visitOccurrenceId;
    }
    public void setVisitOccurrenceId(String visitOccurrenceId) {
        this.visitOccurrenceId = visitOccurrenceId;
    }
    public String getVisitDetailId() {
        return visitDetailId;
    }
    public void setVisitDetailId(String visitDetailId) {
        this.visitDetailId = visitDetailId;
    }
    public String getConditionSourceValue() {
        return conditionSourceValue;
    }
    public void setConditionSourceValue(String conditionSourceValue) {
        this.conditionSourceValue = conditionSourceValue;
    }
    public String getConditionSourceConceptId() {
        return conditionSourceConceptId;
    }
    public void setConditionSourceConceptId(String conditionSourceConceptId) {
        this.conditionSourceConceptId = conditionSourceConceptId;
    }
    public String getConditionStatusSourceValue() {
        return conditionStatusSourceValue;
    }
    public void setConditionStatusSourceValue(String conditionStatusSourceValue) {
        this.conditionStatusSourceValue = conditionStatusSourceValue;
    }
    
    public String getConditionCodeSourceValue() {
		return conditionCodeSourceValue;
	}
	public void setConditionCodeSourceValue(String conditionCodeSourceValue) {
		this.conditionCodeSourceValue = conditionCodeSourceValue;
	}
}
