package edu.emory.cci.aiw.omopetl.util;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */




import java.text.Format;

import org.protempa.proposition.Parameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.Value;

/**
*
* @author Nita
*/

public class OmopValueWriter implements AutoCloseable{

	
	    public String writeNominal(NominalValue inValue) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(null) : null;
	    }
	    
	    public String writeNominal(NominalValue inValue, Format inFormat) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(inFormat) : null;
	    }
	    
	    public String writeNumber(NumberValue inValue) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(null) : null;
	    }
	    
	    public String writeNumber(NumberValue inValue, Format inFormat) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(inFormat) : null;
	    }
	    
	    public String writeInequality(InequalityNumberValue inValue) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(null) : null;
	    }
	    
	    public String writeInequality(InequalityNumberValue inValue, Format inFormat) throws OmopValueWriterException {
	    	return inValue != null ? inValue.format(inFormat) : null;
	    }
	    
	    public String writeNumber(InequalityNumberValue inValue) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.getNumberValue().format(null) : null;
	    }
	    
	    public String writeNumber(InequalityNumberValue inValue, Format inFormat) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.getNumberValue().format(inFormat) : null;
	    }
	    
	    public String writeInequalityNumber(InequalityNumberValue inValue) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(null) : null;
	    }
	    
	    public String writeInequalityNumber(InequalityNumberValue inValue, Format inFormat) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(inFormat) : null;
	    }
	    
	    public String writeDate(DateValue inValue) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(null) : null;
	    }
	    
	    public String writeDate(DateValue inValue, Format inFormat) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(inFormat) : null;
	    }
	    
	    public String writeBoolean(BooleanValue inValue) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(null) : null;
	    }
	    
	    public String writeBoolean(BooleanValue inValue, Format inFormat) throws OmopValueWriterException { 
	    	return inValue != null ? inValue.format(inFormat) : null;
	    }
	    
	    public String writeId(Proposition inProposition) throws OmopValueWriterException { 
	    	return inProposition.getId();
	    }
	    
	    public String writeUniqueId(Proposition inProposition) throws OmopValueWriterException { 
	    	return inProposition.getUniqueId().getStringRepresentation();
	    }
	    
	    public String writeLocalUniqueId(Proposition inProposition) throws OmopValueWriterException { 
	    	return inProposition.getUniqueId().getLocalUniqueId().getId();
	    }
	    
	    public String writeNumericalId(Proposition inProposition) throws OmopValueWriterException { 
	    	return String.valueOf(inProposition.getUniqueId().getLocalUniqueId().getNumericalId());
	    }
	    
	    /**
	     * Writes the start of a temporal proposition's interval using the value of 
	     * {@link TemporalProposition#getStartFormattedShort() }.
	     * @param inProposition the temporal proposition.
	     * @throws OmopValueWriterException if an error occurred.
	     */
	    public String writeStart(TemporalProposition inProposition) throws OmopValueWriterException { 
	    	return inProposition.getStartFormattedShort();
	    }
	    
	    /**
	     * Writes the start of a temporal proposition's interval. If no format is 
	     * specified, it uses the value of 
	     * {@link TemporalProposition#getStartFormattedShort() }.
	     * @param inProposition the temporal proposition.
	     * @param inFormat the formatter.
	     * @throws OmopValueWriterException if an error occurred.
	     */
	    public String writeStart(TemporalProposition inProposition, Format inFormat) throws OmopValueWriterException { 
	    	String value;
	        if (inFormat == null) {
	            value = inProposition.getStartFormattedShort();
	        } else {
	            value = inProposition.formatStart(inFormat);
	        }
	        return value;
	    }
	    
	    /**
	     * Writes the finish of a temporal proposition's interval using the value 
	     * of {@link TemporalProposition#getFinishFormattedShort() }.
	     * @param inProposition the temporal proposition.
	     * @throws OmopValueWriterException if an error occurred.
	     */
	    public String writeFinish(TemporalProposition inProposition) throws OmopValueWriterException { 
	    	return inProposition.getFinishFormattedShort();
	    }
	    
	    /**
	     * Writes the finish of a temporal proposition's interval. If no format is 
	     * specified, it uses the value of 
	     * {@link TemporalProposition#getFinishFormattedShort() }.
	     * @param inProposition the temporal proposition.
	     * @param inFormat the formatter.
	     * @throws OmopValueWriterException if an error occurred.
	     */
	    public String writeFinish(TemporalProposition inProposition, Format inFormat) throws OmopValueWriterException { 
	    	String value;
	        if (inFormat == null) {
	            value = inProposition.getFinishFormattedShort();
	        } else {
	            value = inProposition.formatFinish(inFormat);
	        }
	        return value;
	    }
	    
	    /**
	     * Writes the length of a temporal proposition's interval using the value 
	     * of {@link TemporalProposition#getLengthFormattedShort() }.
	     * @param inProposition the temporal proposition.
	     * @throws OmopValueWriterException if an error occurred.
	     */
	    public String writeLength(TemporalProposition inProposition) throws OmopValueWriterException { 
	    	return inProposition.getLengthFormattedShort();
	    }
	    
	    /**
	     * Writes the length of a temporal proposition's interval. If no format is 
	     * specified, it uses the value of 
	     * {@link TemporalProposition#getLengthFormattedShort() }.
	     * @param inProposition the temporal proposition.
	     * @param inFormat the formatter.
	     * @throws OmopValueWriterException if an error occurred.
	     */
	    public String writeLength(TemporalProposition inProposition, Format inFormat) throws OmopValueWriterException { 
	    	String value;
	        if (inFormat == null) {
	            value = inProposition.getLengthFormattedShort();
	        } else {
	            value = inProposition.formatLength(inFormat);
	        }
	        return value;
	    }
	    
	    public String writeParameterValue(Parameter inProposition) throws OmopValueWriterException { 
	    	Value value = inProposition.getValue();
	        return writeValue(value);
	    }
	    
	    public String writeParameterValue(Parameter inProposition, Format inFormat) throws OmopValueWriterException {
	    	Value value = inProposition.getValue();
	        return writeValue(value, inFormat);
	    }
	    
	    public String writePropertyValue(Proposition inProposition, String inPropertyName) throws OmopValueWriterException { 
	    	Value value = inProposition.getProperty(inPropertyName);
	        return writeValue(value, null);
	    }
	    
	    public String writePropertyValue(Proposition inProposition, String inPropertyName, Format inFormat) throws OmopValueWriterException { 
	    	Value value = inProposition.getProperty(inPropertyName);
	        return writeValue(value, inFormat);
	    }
	    
	    public String writeValue(Value inValue) throws OmopValueWriterException{ 
	    	return inValue.getFormatted();
	    }
	    
	    public String writeValue(Value inValue, Format inFormat) throws OmopValueWriterException{ 
	    	return inValue.format(inFormat);
	    }
	    
	    public String writeNull() throws OmopValueWriterException{ 
	    	return "NULL";
	    }
	    
	    public String newRow() throws OmopValueWriterException{ 
	    	return "\n";
	    }


	@Override
	public void close() throws Exception {
		// TODO Auto-generated method stub
		
	}
	


}