/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.omopetl.util;

import java.util.logging.Logger;

public class OmopFileOutputHandler {
    private static final Logger LOGGER = Logger.getLogger(OmopFileOutputHandler.class.getName());
    private String selectStatement;
    private String header;

    public OmopFileOutputHandler() {
        LOGGER.info("Constructing OmopFileOutputHandler");
    }

    public String getSelectStatement(String tableName) {
        switch (tableName) {
            case "address": {
                this.selectStatement = "select person_id,location_id from address_final order by person_id";
                break;
            }
            case "care_site": {
                this.selectStatement = "select id, care_site_name, place_of_service_concept_id, location_id, care_site_source_value, place_of_service_source_value from care_site_final order by id";
                break;
            }
            case "condition_occurrence": {
                this.selectStatement = "select id, person_id, condition_concept_id, condition_start_date, condition_start_datetime, condition_end_date, condition_end_datetime, condition_type_concept_id, stop_reason, provider_id, visit_occurrence_id, condition_source_value, condition_source_concept_id, condition_status_source_value, condition_status_concept_id, condition_code_source_value from condition_occurrence_final order by person_id";
                break;
            }
            case "death": {
                this.selectStatement = "select person_id, death_date, death_datetime, death_type_concept_id, cause_concept_id, cause_source_value, cause_source_concept_id, death_type_source_value from death_final order by person_id";
                break;
            }
            case "drug_exposure": {
                this.selectStatement = "select id, person_id, drug_concept_id, drug_exposure_start_date, drug_exposure_start_datetime, drug_exposure_end_date, drug_exposure_end_datetime, verbatim_end_date, drug_type_concept_id, stop_reason, refills, quantity, days_supply, sig, route_concept_id, lot_number, provider_id, visit_occurrence_id, drug_source_value, drug_code_type_source_value, drug_source_concept_id, route_source_value, dose_unit_source_value from drug_exposure_final order by person_id";
                break;
            }
            case "email": {
                this.selectStatement = "select person_id, email, email_type from email_final order by person_id";
                break;
            }
            case "location": {
                this.selectStatement = "select id, address_1, address_2, city, state, zip, county, location_source_value from location_final order by id";
                break;
            }
            case "measurement": {
                this.selectStatement = "select id, person_id, measurement_concept_id, measurement_date, measurement_datetime, measurement_type_concept_id, operator_concept_id, value_as_number, value_as_concept_id, unit_concept_id, range_low, range_high, provider_id, visit_occurrence_id, measurement_source_value, measurement_source_concept_id, unit_source_value, value_source_value, operator_concept_source_value from measurement_final order by person_id";
                break;
            }
            case "mrn": {
                this.selectStatement = "select person_id, health_system, mrn from mrn_final order by person_id";
                break;
            }
            case "name": {
                this.selectStatement = "select person_id, first_name, middle_name, last_name, suffix, prefix from name_final order by person_id";
                break;
            }
            case "person": {
                this.selectStatement = "select person_id, gender_concept_id, year_of_birth, month_of_birth, day_of_birth, birth_datetime, race_concept_id, ethnicity_concept_id, location_id, provider_id, care_site_id, person_source_value, gender_source_value, gender_source_concept_id, race_source_value, race_source_concept_id, ethnicity_source_value, ethnicity_source_concept_id from person_final order by person_id";
                break;
            }
            case "phone_number": {
                this.selectStatement = "select person_id, phone_number, phone_type from phone_number_final order by person_id, phone_type";
                break;
            }
            case "procedure_occurrence": {
                this.selectStatement = "select id, person_id, procedure_concept_id, procedure_date, procedure_datetime, procedure_type_concept_id, modifier_concept_id, quantity, provider_id, visit_occurrence_id, procedure_source_value, code_type_source_value, procedure_source_concept_id, qualifier_source_value from procedure_occurrence_final order by person_id";
                break;
            }
            case "provider": {
                this.selectStatement = "select id, provider_name, NPI, DEA, specialty_concept_id, care_site_id, year_of_birth, gender_concept_id, provider_source_value, specialty_source_value, specialty_source_concept_id, gender_source_value, gender_source_concept_id from provider_final order by id";
                break;
            }
            case "visit_occurrence": {
                this.selectStatement = "select id, person_id, visit_concept_id, visit_start_date, visit_start_datetime, visit_end_date, visit_end_datetime, visit_type_concept_id, provider_id, care_site_id, visit_source_value, visit_source_concept_id, admitting_source_concept_id, admitting_source_value, discharge_to_concept_id, discharge_to_source_value, preceding_visit_occurrence_id from visit_occurrence_final order by person_id";
            }
        }
        return this.selectStatement;
    }

    public void setInsertStatement(String insertStatement) {
        this.selectStatement = insertStatement;
    }

    public String getHeader(String tableName) {
        switch (tableName) {
            case "address": {
                this.header = "\"person_id\"\t\"location_id\"";
                break;
            }
            case "care_site": {
                this.header = "\"care_site_id\"\t\"care_site_name\"\t\"place_of_service_concept_id\"\t\"location_id\"\t\"care_site_source_value\"\t\"place_of_service_source_value\"";
                break;
            }
            case "condition_occurrence": {
                this.header = "\"condition_occurrence_id\"\t\"person_id\"\t\"condition_concept_id\"\t\"condition_start_date\"\t\"condition_start_datetime\"\t\"condition_end_date\"\t\"condition_end_datetime\"\t\"condition_type_concept_id\"\t\"stop_reason\"\t\"provider_id\"\t\"visit_occurrence_id\"\t\"condition_source_value\"\t\"condition_source_concept_id\"\t\"condition_status_source_value\"\t\"condition_status_concept_id\"\t\"condition_code_source_value\"";
                break;
            }
            case "death": {
                this.header = "\"person_id\"\t\"death_date\"\t\"death_datetime\"\t\"death_type_concept_id\"\t\"cause_concept_id\"\t\"cause_source_value\"\t\"cause_source_concept_id\"\t\"death_type_source_value\"";
                break;
            }
            case "drug_exposure": {
                this.header = "\"drug_exposure_id\"\t\"person_id\"\t\"drug_concept_id\"\t\"drug_exposure_start_date\"\t\"drug_exposure_start_datetime\"\t\"drug_exposure_end_date\"\t\"drug_exposure_end_datetime\"\t\"verbatim_end_date\"\t\"drug_type_concept_id\"\t\"stop_reason\"\t\"refills\"\t\"quantity\"\t\"days_supply\"\t\"sig\"\t\"route_concept_id\"\t\"lot_number\"\t\"provider_id\"\t\"visit_occurrence_id\"\t\"drug_source_value\"\t\"drug_code_type_source_value\"\t\"drug_source_concept_id\"\t\"route_source_value\"\t\"dose_unit_source_value\"";
                break;
            }
            case "email": {
                this.header = "\"person_id\"\t\"email\"\t\"email_type\"";
                break;
            }
            case "location": {
                this.header = "\"location_id\"\t\"address_1\"\t\"address_2\"\t\"city\"\t\"state\"\t\"zip\"\t\"county\"\t\"location_source_value\"";
                break;
            }
            case "measurement": {
                this.header = "\"measurement_id\"\t\"person_id\"\t\"measurement_concept_id\"\t\"measurement_date\"\t\"measurement_datetime\"\t\"measurement_type_concept_id\"\t\"operator_concept_id\"\t\"value_as_number\"\t\"value_as_concept_id\"\t\"unit_concept_id\"\t\"range_low\"\t\"range_high\"\t\"provider_id\"\t\"visit_occurrence_id\"\t\"measurement_source_value\"\t\"measurement_source_concept_id\"\t\"unit_source_value\"\t\"value_source_value\"\t\"operator_concept_source_value\"";
                break;
            }
            case "mrn": {
                this.header = "\"person_id\"\t\"health_system\"\t\"mrn\"";
                break;
            }
            case "name": {
                this.header = "\"person_id\"\t\"first_name\"\t\"middle_name\"\t\"last_name\"\t\"suffix\"\t\"prefix\"";
                break;
            }
            case "person": {
                this.header = "\"person_id\"\t\"gender_concept_id\"\t\"year_of_birth\"\t\"month_of_birth\"\t\"day_of_birth\"\t\"birth_datetime\"\t\"race_concept_id\"\t\"ethnicity_concept_id\"\t\"location_id\"\t\"provider_id\"\t\"care_site_id\"\t\"person_source_value\"\t\"gender_source_value\"\t\"gender_source_concept_id\"\t\"race_source_value\"\t\"race_source_concept_id\"\t\"ethnicity_source_value\"\t\"ethnicity_source_concept_id\"";
                break;
            }
            case "phone_number": {
                this.header = "\"person_id\"\t\"phone_number\"\t\"phone_type\"";
                break;
            }
            case "procedure_occurrence": {
                this.header = "\"procedure_occurrence_id\"\t\"person_id\"\t\"procedure_concept_id\"\t\"procedure_date\"\t\"procedure_datetime\"\t\"procedure_type_concept_id\"\t\"modifier_concept_id\"\t\"quantity\"\t\"provider_id\"\t\"visit_occurrence_id\"\t\"procedure_source_value\"\t\"code_type_source_value\"\t\"procedure_source_concept_id\"\t\"qualifier_source_value\"";
                break;
            }
            case "provider": {
                this.header = "\"provider_id\"\t\"provider_name\"\t\"NPI\"\t\"DEA\"\t\"specialty_concept_id\"\t\"care_site_id\"\t\"year_of_birth\"\t\"gender_concept_id\"\t\"provider_source_value\"\t\"specialty_source_value\"\t\"specialty_source_concept_id\"\t\"gender_source_value\"\t\"gender_source_concept_id\"";
                break;
            }
            case "visit_occurrence": {
                this.header = "\"visit_occurrence_id\"\t\"person_id\"\t\"visit_concept_id\"\t\"visit_start_date\"\t\"visit_start_datetime\"\t\"visit_end_date\"\t\"visit_end_datetime\"\t\"visit_type_concept_id\"\t\"provider_id\"\t\"care_site_id\"\t\"visit_source_value\"\t\"visit_source_concept_id\"\t\"admitting_source_concept_id\"\t\"admitting_source_value\"\t\"discharge_to_concept_id\"\t\"discharge_to_source_value\"\t\"preceding_visit_occurrence_id\"";
            }
        }
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

