/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.omopetl.util;

import edu.emory.cci.aiw.omopetl.util.OmopValueWriterException;
import java.text.Format;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.Value;

public class OmopValueWriter
implements AutoCloseable {
    public String writeNominal(NominalValue inValue) throws OmopValueWriterException {
        return inValue != null ? inValue.format(null) : null;
    }

    public String writeNominal(NominalValue inValue, Format inFormat) throws OmopValueWriterException {
        return inValue != null ? inValue.format(inFormat) : null;
    }

    public String writeNumber(NumberValue inValue) throws OmopValueWriterException {
        return inValue != null ? inValue.format(null) : null;
    }

    public String writeNumber(NumberValue inValue, Format inFormat) throws OmopValueWriterException {
        return inValue != null ? inValue.format(inFormat) : null;
    }

    public String writeInequality(InequalityNumberValue inValue) throws OmopValueWriterException {
        return inValue != null ? inValue.format(null) : null;
    }

    public String writeInequality(InequalityNumberValue inValue, Format inFormat) throws OmopValueWriterException {
        return inValue != null ? inValue.format(inFormat) : null;
    }

    public String writeNumber(InequalityNumberValue inValue) throws OmopValueWriterException {
        return inValue != null ? inValue.getNumberValue().format(null) : null;
    }

    public String writeNumber(InequalityNumberValue inValue, Format inFormat) throws OmopValueWriterException {
        return inValue != null ? inValue.getNumberValue().format(inFormat) : null;
    }

    public String writeInequalityNumber(InequalityNumberValue inValue) throws OmopValueWriterException {
        return inValue != null ? inValue.format(null) : null;
    }

    public String writeInequalityNumber(InequalityNumberValue inValue, Format inFormat) throws OmopValueWriterException {
        return inValue != null ? inValue.format(inFormat) : null;
    }

    public String writeDate(DateValue inValue) throws OmopValueWriterException {
        return inValue != null ? inValue.format(null) : null;
    }

    public String writeDate(DateValue inValue, Format inFormat) throws OmopValueWriterException {
        return inValue != null ? inValue.format(inFormat) : null;
    }

    public String writeBoolean(BooleanValue inValue) throws OmopValueWriterException {
        return inValue != null ? inValue.format(null) : null;
    }

    public String writeBoolean(BooleanValue inValue, Format inFormat) throws OmopValueWriterException {
        return inValue != null ? inValue.format(inFormat) : null;
    }

    public String writeId(Proposition inProposition) throws OmopValueWriterException {
        return inProposition.getId();
    }

    public String writeUniqueId(Proposition inProposition) throws OmopValueWriterException {
        return inProposition.getUniqueId().getStringRepresentation();
    }

    public String writeLocalUniqueId(Proposition inProposition) throws OmopValueWriterException {
        return inProposition.getUniqueId().getLocalUniqueId().getId();
    }

    public String writeNumericalId(Proposition inProposition) throws OmopValueWriterException {
        return String.valueOf(inProposition.getUniqueId().getLocalUniqueId().getNumericalId());
    }

    public String writeStart(TemporalProposition inProposition) throws OmopValueWriterException {
        return inProposition.getStartFormattedShort();
    }

    public String writeStart(TemporalProposition inProposition, Format inFormat) throws OmopValueWriterException {
        String value = inFormat == null ? inProposition.getStartFormattedShort() : inProposition.formatStart(inFormat);
        return value;
    }

    public String writeFinish(TemporalProposition inProposition) throws OmopValueWriterException {
        return inProposition.getFinishFormattedShort();
    }

    public String writeFinish(TemporalProposition inProposition, Format inFormat) throws OmopValueWriterException {
        String value = inFormat == null ? inProposition.getFinishFormattedShort() : inProposition.formatFinish(inFormat);
        return value;
    }

    public String writeLength(TemporalProposition inProposition) throws OmopValueWriterException {
        return inProposition.getLengthFormattedShort();
    }

    public String writeLength(TemporalProposition inProposition, Format inFormat) throws OmopValueWriterException {
        String value = inFormat == null ? inProposition.getLengthFormattedShort() : inProposition.formatLength(inFormat);
        return value;
    }

    public String writeParameterValue(Parameter inProposition) throws OmopValueWriterException {
        Value value = inProposition.getValue();
        return this.writeValue(value);
    }

    public String writeParameterValue(Parameter inProposition, Format inFormat) throws OmopValueWriterException {
        Value value = inProposition.getValue();
        return this.writeValue(value, inFormat);
    }

    public String writePropertyValue(Proposition inProposition, String inPropertyName) throws OmopValueWriterException {
        Value value = inProposition.getProperty(inPropertyName);
        return this.writeValue(value, null);
    }

    public String writePropertyValue(Proposition inProposition, String inPropertyName, Format inFormat) throws OmopValueWriterException {
        Value value = inProposition.getProperty(inPropertyName);
        return this.writeValue(value, inFormat);
    }

    public String writeValue(Value inValue) throws OmopValueWriterException {
        return inValue.getFormatted();
    }

    public String writeValue(Value inValue, Format inFormat) throws OmopValueWriterException {
        return inValue.format(inFormat);
    }

    public String writeNull() throws OmopValueWriterException {
        return "NULL";
    }

    public String newRow() throws OmopValueWriterException {
        return "\n";
    }

    @Override
    public void close() throws Exception {
    }
}

