package edu.emory.cci.aiw.omopetl.dest.table;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.sql.Timestamp;
import java.util.Date;

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/**
 * Represents records in the observation table.
 * 
 * The observation table has the following DDL:
 * <pre>
 * --------------------------------------------------------
--  DDL for Table OBSERVATION_TEMP
--------------------------------------------------------

  CREATE TABLE "I2B2OMOP"."OBSERVATION_TEMP" 
   (    "OBSERVATION_ID" VARCHAR2(255 BYTE), 
    "PERSON_ID" VARCHAR2(255 BYTE), 
    "OBSERVATION_CONCEPT_ID" VARCHAR2(255 BYTE), 
    "OBSERVATION_DATE" VARCHAR2(255 BYTE), 
    "OBSERVATION_DATETIME" VARCHAR2(255 BYTE), 
    "OBSERVATION_TYPE_CONCEPT_ID" VARCHAR2(255 BYTE), 
    "VALUE_AS_NUMBER" VARCHAR2(255 BYTE), 
    "VALUE_AS_STRING" VARCHAR2(255 BYTE), 
    "VALUE_AS_CONCEPT_ID" VARCHAR2(255 BYTE), 
    "QUALIFIER_CONCEPT_ID" VARCHAR2(255 BYTE), 
    "UNIT_CONCEPT_ID" VARCHAR2(255 BYTE), 
    "PROVIDER_ID" VARCHAR2(255 BYTE), 
    "VISIT_OCCURRENCE_ID" VARCHAR2(255 BYTE), 
    "OBSERVATION_SOURCE_VALUE" VARCHAR2(255 BYTE), 
    "OBSERVATION_SOURCE_CONCEPT_ID" VARCHAR2(255 BYTE), 
    "UNIT_SOURCE_VALUE" VARCHAR2(255 BYTE), 
    "QUALIFIER_SOURCE_VALUE" VARCHAR2(255 BYTE), 
    "OBSERVATION_TYPE_SOURCE_VALUE" VARCHAR2(255 BYTE)
   ) 

 * </pre>
 * @author Nita
 *
 */
public class Observation extends AbstractRecord{
    private Long observationId;
    private Long personId;
    private Integer observationConceptId;
    private Date observationDate;
    private Timestamp observationDatetime;
    private Integer observationTypeConceptId;
    private Float valueAsNumber;
    private String valueAsString;
    private Integer valueAsConceptId;
    private Integer qualifierConceptId;
    private Integer unitConceptId;
    private Long providerId;
    private Long visitOccurrenceId;
    private String observationSourceValue;
    private Integer observationSourceConceptId;
    private String unitSourceValue;
    private String qualifierSourceValue;
    private String observationTypeSourceValue;
    
    public Long getobservationId() {
        return observationId;
    }
    public void setobservationId(Long observationId) {
        this.observationId = observationId;
    }
    public Long getPersonId() {
        return personId;
    }
    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public Integer getobservationConceptId() {
        return observationConceptId;
    }
    public void setobservationConceptId(Integer observationConceptId) {
        this.observationConceptId = observationConceptId;
    }
    public Date getobservationDate() {
        return observationDate;
    }
    public void setobservationDate(Date observationDate) {
        this.observationDate = observationDate;
    }
    public Timestamp getobservationDatetime() {
        return observationDatetime;
    }
    public void setobservationDatetime(Timestamp observationDatetime) {
        this.observationDatetime = observationDatetime;
    }
    public Integer getobservationTypeConceptId() {
        return observationTypeConceptId;
    }
    public void setobservationTypeConceptId(Integer observationTypeConceptId) {
        this.observationTypeConceptId = observationTypeConceptId;
    }
    public Float getValueAsNumber() {
        return valueAsNumber;
    }
    public void setValueAsNumber(Float valueAsNumber) {
        this.valueAsNumber = valueAsNumber;
    }
    public Integer getValueAsConceptId() {
        return valueAsConceptId;
    }
    public void setValueAsConceptId(Integer valueAsConceptId) {
        this.valueAsConceptId = valueAsConceptId;
    }
    public Integer getUnitConceptId() {
        return unitConceptId;
    }
    public void setUnitConceptId(Integer unitConceptId) {
        this.unitConceptId = unitConceptId;
    }
    public Long getProviderId() {
        return providerId;
    }
    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }
    public Long getVisitOccurrenceId() {
        return visitOccurrenceId;
    }
    public void setVisitOccurrenceId(Long visitOccurrenceId) {
        this.visitOccurrenceId = visitOccurrenceId;
    }
    public String getobservationSourceValue() {
        return observationSourceValue;
    }
    public void setobservationSourceValue(String observationSourceValue) {
        this.observationSourceValue = observationSourceValue;
    }
    public Integer getobservationSourceConceptId() {
        return observationSourceConceptId;
    }
    public void setobservationSourceConceptId(Integer observationSourceConceptId) {
        this.observationSourceConceptId = observationSourceConceptId;
    }
    public String getUnitSourceValue() {
        return unitSourceValue;
    }
    public void setUnitSourceValue(String unitSourceValue) {
        this.unitSourceValue = unitSourceValue;
    }
    public String getValueAsString() {
        return valueAsString;
    }
    public void setValueAsString(String valueAsString) {
        this.valueAsString = valueAsString;
    }
    public Integer getQualifierConceptId() {
        return qualifierConceptId;
    }
    public void setQualifierConceptId(Integer qualifierConceptId) {
        this.qualifierConceptId = qualifierConceptId;
    }
    public String getQualifierSourceValue() {
        return qualifierSourceValue;
    }
    public void setQualifierSourceValue(String qualifierSourceValue) {
        this.qualifierSourceValue = qualifierSourceValue;
    }
    public String getObservationTypeSourceValue() {
        return observationTypeSourceValue;
    }
    public void setObservationTypeSourceValue(String observationTypeSourceValue) {
        this.observationTypeSourceValue = observationTypeSourceValue;
    }    
    
}
