/*
 * #%L
 * AIW i2b2 ETL
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package edu.emory.cci.aiw.omopetl.dest.table;

import java.sql.Timestamp;

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/**
 * Represents records in the Person table.
 * 
 * The Person table has the following DDL:
 * <pre>
 * CREATE TABLE OMOP.person
(
  person_id                     NUMBER(19)  NOT NULL , 
  gender_concept_id             INTEGER     NOT NULL ,
  year_of_birth                 INTEGER     NOT NULL ,
  month_of_birth                INTEGER     NULL,
  day_of_birth                  INTEGER     NULL,
  birthDatetime                TIMESTAMP   NULL,
  deathDatetime                TIMESTAMP   NULL,
  race_concept_id               INTEGER     NOT NULL,
  ethnicity_concept_id          INTEGER     NOT NULL,
  location_id                   NUMBER(19)  NULL,
  provider_id                   NUMBER(19)  NULL,
  care_site_id                  NUMBER(19)  NULL,
  person_source_value           VARCHAR(50) NULL,
  gender_source_value           VARCHAR(50) NULL,
  gender_source_concept_id      INTEGER     NOT NULL,
  race_source_value             VARCHAR(50) NULL,
  race_source_concept_id        INTEGER     NOT NULL,
  ethnicity_source_value        VARCHAR(50) NULL,
  ethnicity_source_concept_id   INTEGER     NOT NULL
)
 * </pre>
 * 
 * @author Nita Deshpande
 */
public class Person extends AbstractRecord {
    private Long personId;
    private Integer genderConceptId;
    private Integer yearOfBirth;
    private Integer monthOfBirth;
    private Integer dayOfBirth;
    private Timestamp birthDatetime;
    private Timestamp deathDatetime;
    private Integer raceConceptId;
    private Integer ethnicityConceptId;
    private Long locationId;
    private Long providerId;
    private Long careSiteId;
    private String personSourceValue;
    private String genderSourceValue;
    private Integer genderSourceConceptId;
    private String raceSourceValue;
    private Integer raceSourceConceptId;
    private String ethnicitySourceValue;
    private Integer ethnicitySourceConceptId;
    public Long getPersonId() {
        return personId;
    }
    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public Integer getGenderConceptId() {
        return genderConceptId;
    }
    public void setGenderConceptId(Integer genderConceptId) {
        this.genderConceptId = genderConceptId;
    }
    public Integer getYearOfBirth() {
        return yearOfBirth;
    }
    public void setYearOfBirth(Integer yearOfBirth) {
        this.yearOfBirth = yearOfBirth;
    }
    public Integer getMonthOfBirth() {
        return monthOfBirth;
    }
    public void setMonthOfBirth(Integer monthOfBirth) {
        this.monthOfBirth = monthOfBirth;
    }
    public Integer getDayOfBirth() {
        return dayOfBirth;
    }
    public void setDayOfBirth(Integer dayOfBirth) {
        this.dayOfBirth = dayOfBirth;
    }
    public Timestamp getBirthDatetime() {
        return birthDatetime;
    }
    public void setBirthDatetime(Timestamp birthDatetime) {
        this.birthDatetime = birthDatetime;
    }
    public Timestamp getDeathDatetime() {
        return deathDatetime;
    }
    public void setDeathDatetime(Timestamp deathDatetime) {
        this.deathDatetime = deathDatetime;
    }
    public Integer getRaceConceptId() {
        return raceConceptId;
    }
    public void setRaceConceptId(Integer raceConceptId) {
        this.raceConceptId = raceConceptId;
    }
    public Integer getEthnicityConceptId() {
        return ethnicityConceptId;
    }
    public void setEthnicityConceptId(Integer ethnicityConceptId) {
        this.ethnicityConceptId = ethnicityConceptId;
    }
    public Long getLocationId() {
        return locationId;
    }
    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }
    public Long getProviderId() {
        return providerId;
    }
    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }
    public Long getCareSiteId() {
        return careSiteId;
    }
    public void setCareSiteId(Long careSiteId) {
        this.careSiteId = careSiteId;
    }
    public String getPersonSourceValue() {
        return personSourceValue;
    }
    public void setPersonSourceValue(String personSourceValue) {
        this.personSourceValue = personSourceValue;
    }
    public String getGenderSourceValue() {
        return genderSourceValue;
    }
    public void setGenderSourceValue(String genderSourceValue) {
        this.genderSourceValue = genderSourceValue;
    }
    public Integer getGenderSourceConceptId() {
        return genderSourceConceptId;
    }
    public void setGenderSourceConceptId(Integer genderSourceConceptId) {
        this.genderSourceConceptId = genderSourceConceptId;
    }
    public String getRaceSourceValue() {
        return raceSourceValue;
    }
    public void setRaceSourceValue(String raceSourceValue) {
        this.raceSourceValue = raceSourceValue;
    }
    public Integer getRaceSourceConceptId() {
        return raceSourceConceptId;
    }
    public void setRaceSourceConceptId(Integer raceSourceConceptId) {
        this.raceSourceConceptId = raceSourceConceptId;
    }
    public String getEthnicitySourceValue() {
        return ethnicitySourceValue;
    }
    public void setEthnicitySourceValue(String ethnicitySourceValue) {
        this.ethnicitySourceValue = ethnicitySourceValue;
    }
    public Integer getEthnicitySourceConceptId() {
        return ethnicitySourceConceptId;
    }
    public void setEthnicitySourceConceptId(Integer ethnicitySourceConceptId) {
        this.ethnicitySourceConceptId = ethnicitySourceConceptId;
    }


    
}
